; GnoMETA/theme.jl
; Gnome2 logo inspiralta sawfish tema
; Licence: freeware
; Szerzo: succuba@elmki.sulinet.hu

; Itt definialom a valtoztathato beallitasokat. Ezek a dolgok
; megjelennek kulon fuleken a Sawfish "Kinezet" paneljen.

(defgroup GnoMETA "GnoMETA"
  :group appearance)

(defgroup titlebar "Cimsor"
    :group (appearance GnoMETA))
 
; A cimsor betutipusa
(defcustom GnoMETA:titlebar-font (get-font "-*-lucidatypewriter-bold-r-normal-*-*-120-*-*-p-*-iso8859-2")
    "A cimsor betutipusa : \\w"
    :type font
    :group (appearance GnoMETA titlebar)
    :after-set (lambda () (reframe-windows-with-style 'GnoMETA)))

; A tranziens cimsor betutipusa
(defcustom GnoMETA:transient-titlebar-font (get-font "-*-lucidatypewriter-bold-r-normal-*-*-100-*-*-p-*-iso8859-2")
    "A cimsor betutipusa : \\w"
    :type font
    :group (appearance GnoMETA titlebar)
    :after-set (lambda () (reframe-windows-with-style 'GnoMETA)))

; Cimsor betuszinek
; Normal cimsor
(defcustom GnoMETA:titlebar-normal-color-font (get-color "#400040004000")
    "Normal cimsor betuszine."
    :type color
    :group (appearance GnoMETA titlebar)
    :after-set (lambda () (reframe-windows-with-style 'GnoMETA)))

; Fokuszalt cimsor
(defcustom GnoMETA:titlebar-focus-color-font (get-color "#000000000000")
    "Fokuszalt cimsor betuszine."
    :type color
    :group (appearance GnoMETA titlebar)
    :after-set (lambda () (reframe-windows-with-style 'GnoMETA)))

; Kijelolt cimsor
(defcustom GnoMETA:titlebar-hilite-color-font (get-color "#DC00DC00DC00")
    "Kurzor alatti cimsor betuszine."
    :type color
    :group (appearance GnoMETA titlebar)
    :after-set (lambda () (reframe-windows-with-style 'GnoMETA)))

; Kattintott cimsor
(defcustom GnoMETA:titlebar-click-color-font (get-color "#FE00F400DF00")
    "Kattintott cimsor betuszine."
    :type color
    :group (appearance GnoMETA titlebar)
    :after-set (lambda () (reframe-windows-with-style 'GnoMETA)))

(let*
 ;; Cimsor pixelszelesseg beallitasa
 ((title-width (lambda (w) 
	(let ((w-width 
	  (car (window-dimensions w)))) 
	    (max 0 (min (- w-width 100) (text-width (window-name w)))))))

  ;; --- Tema kidolgozasa, kepek, betuk, szinek, keretek ---
  (

  ;; Kezdeti beallitasok importalasa a beallitopanelrol meg egyebek
   (define titlebar-title (lambda (w) (window-name w)))
   (define titlefont  (lambda () GnoMETA:titlebar-font))
   (define t-titlefont  (lambda () GnoMETA:transient-titlebar-font))
   (define titlefont-colors (list GnoMETA:titlebar-normal-color-font GnoMETA:titlebar-focus-color-font GnoMETA:titlebar-hilite-color-font GnoMETA:titlebar-click-color-font))

   ;; --- Kepi elemek listaja: inaktiv, aktiv, eger alatti, kattintott ---
     
   ;; Cimsor (inaktiv, fokuszalt) 114 x 24
   (define title-images       (list (make-image "title-ia.png")
                                    (make-image "title-a.png")))
  
   ;; arnyekolt cimsor        114 x 24
   (define shd-title-images   (list (make-image "title-shd-ia.png")   
                                    (make-image "title-shd-a.png")))
  
   ;; Ablak nyomogombjai (inaktiv, fokusztalt, eger alatti, kattintott)
   ;; Mini gomb               31 x 24
   (define iconify-images     (list (make-image "btn-min-ia.png") 
                                    (make-image "btn-min-a.png") 
                                    (make-image "btn-min-h.png") 
	                                (make-image "btn-min-p.png")))
   ;; Maxi gomb               31 x 24
   (define maximize-images    (list (make-image "btn-max-ia.png") 
                                    (make-image "btn-max-a.png")
                                    (make-image "btn-max-h.png")
			                        (make-image "btn-max-p.png")))
   ;; Bezar gomb              31 x 24
   (define close-images       (list (make-image "btn-cl-ia.png")
                                    (make-image "btn-cl-a.png")
                                    (make-image "btn-cl-h.png")
                                    (make-image "btn-cl-p.png")))
   ;; Menu gomb               31 x 24
   (define menu-images        (list (make-image "btn-w-ia.png")
                                    (make-image "btn-w-a.png")
                                    (make-image "btn-w-h.png")
                                    (make-image "btn-w-p.png")))
  
   ;; Ablakszegelyek (inaktiv, fokuszalt)
   ;; Felso                   116 x 16
   (define border-top         (list (make-image "bord-t-ia.png") 
                                    (make-image "bord-t-a.png")))
   ;; arnyekolt felso         116 x 16
   (define shd-border-top     (list (make-image "bord-t-shd-ia.png")
                                    (make-image "bord-t-shd-a.png")))
   ;; Also                    106 x 8
   (define border-bottom      (list (make-image "bord-b-ia.png") 
                                    (make-image "bord-b-a.png")))
   ;; Jobb                    8 x 112
   (define border-right       (list (make-image "bord-r-ia.png")
                                    (make-image "bord-r-a.png")))
   ;; Bal                     8 x 112
   (define border-left        (list (make-image "bord-l-ia.png") 
                                    (make-image "bord-l-a.png")))
     
   ;; Ablak sarkok
   ;; Bal felso tranziens     20 x 16
   (define corner-tl-2        (list (make-image "corn-tlt-ia.png") 
                                    (make-image "corn-tlt-a.png")
                                nil (make-image "corn-tlt-a.png")))
   ;; Jobb felso tranziens    20 x 16
   (define corner-tr-2        (list (make-image "corn-trt-ia.png") 
                                    (make-image "corn-trt-a.png")
                                nil (make-image "corn-trt-a.png")))
   ;; Bal felso               34 x 24
   (define corner-tl          (list (make-image "corn-tl-ia.png")
                                    (make-image "corn-tl-a.png")))
   ;; Bal felso arnyekolt     34 x 24
   (define corner-tl-shd      (list (make-image "corn-tl-shd-ia.png")
                                    (make-image "corn-tl-shd-a.png")))
   ;; Jobb felso              96 x 24
   (define corner-tr          (list (make-image "corn-tr-ia.png")
                                    (make-image "corn-tr-a.png")))
   ;; Jobb felso arnyekolt    96 x 24
   (define corner-tr-shd      (list (make-image "corn-tr-shd-ia.png")
                                    (make-image "corn-tr-shd-a.png")))
   ;; Bal also meretezo       15 x 15
   (define corner-bl          (list (make-image "corn-bl-ia.png") 
                                    (make-image "corn-bl-a.png")))
   ;; Jobb also meretezo      15 x 15
   (define corner-br          (list (make-image "corn-br-ia.png") 
                                    (make-image "corn-br-a.png")))
   ;; --- Keplista vege ---
  
   ;; normal cimsor
   (define ntitle
     `(((background  . ,title-images)
	    (foreground  . ,titlefont-colors)
	    (font        . ,titlefont)
	    (text        . ,window-name)
	    (x-justify   . center)
	    (y-justify   . center)
	    (top-edge    . -24)
	    (left-edge   . 26)
	    (right-edge  . 88)
	    (class       . title))

       ((background  . ,corner-tl)
        (top-edge    . -24)
        (left-edge   . -8)
        (class       . top-left-corner))

       ((background  . ,corner-tr)
        (top-edge    . -24)
        (right-edge  . -8)
        (class       . top-right-corner))))

   ;; Arnyekolt cimsor
   (define stitle
     `(((background . ,shd-title-images)
	    (foreground . ,titlefont-colors)
	    (font       . ,titlefont)
	    (text       . ,window-name)
	    (x-justify  . center)
	    (y-justify  . center)
	    (top-edge   . -24)
	    (left-edge  . 26)
	    (right-edge . 88)
	    (class      . title))

	   ((background . ,corner-tl-shd)
	    (top-edge   . -24)
	    (left-edge  . -8)
	    (class      . top-left-corner))

	   ((background . ,corner-tr-shd)
	    (top-edge   . -24)
	    (right-edge . -8)
	    (class      . top-right-corner))))

   ;; Tranziens normal cimsor
   (define tntitle
     `(((background  . ,border-top)
        (font        . ,t-titlefont)
	    (foreground  . ,titlefont-colors)
	    (text        . ,window-name)
	    (x-justify   . center)
	    (y-justify   . center)
	    (top-edge    . -16)
	    (left-edge   . 12)
	    (right-edge  . 12)
	    (class       . title))))

   ;; Tranziens arnyekolt cimsor
   (define tstitle
     `(((background  . ,shd-border-top)
        (foreground  . ,titlefont-colors)
	    (font        . ,t-titlefont)
	    (text        . ,window-name)
	    (x-justify   . center)
	    (y-justify   . center)
	    (top-edge    . -16)
	    (left-edge   . 12)
	    (right-edge  . 12)
	    (class       . title))))

   ;; Ablakszegelyek
   (define bord
     `(((background  . ,border-left)
	    (top-edge    . 0)
	    (bottom-edge . 4)
	    (left-edge   . -8) 
	    (class       . left-border))

	   ((background  . ,border-right)
	    (top-edge    . 0)
	    (bottom-edge . 4)
	    (right-edge  . -8)
	    (class       . right-border))

	   ((background  . ,border-bottom)
	    (bottom-edge . -8)
	    (right-edge  . 4)  
	    (left-edge   . 4)   
	    (class       . bottom-border))

	   ((background  . ,corner-bl)
	    (bottom-edge . -9)
	    (left-edge   . -9)  
	    (class       . bottom-left-corner))

	   ((background  . ,corner-br)
	    (bottom-edge . -9)
	    (right-edge  . -9) 
	    (class       . bottom-right-corner))))

   ;; Normal gombok
   (define nbtn
     `(((background   . ,menu-images)
        (top-edge     . -24)
	    (left-edge    . -8)
	    (class        . menu-button))

	   ((background  . ,iconify-images)
	    (top-edge    . -24)
	    (right-edge  . 54) 
	    (class       . iconify-button))

	   ((background  . ,maximize-images)
	    (top-edge    . -24)
	    (right-edge  . 23)
	    (class       . maximize-button))

	   ((background  . ,close-images)
	    (top-edge    . -24)
	    (right-edge  . -8)
	    (class       . close-button))))

   ;; Tranziens gombok
   (define tbtn
     `(((background  . ,corner-tl-2)
        (top-edge    . -16)
        (left-edge   . -8)
        (class       . menu-button))

       ((background  . ,corner-tr-2)
        (top-edge   . -16)
        (right-edge . -8)
	    (class      . close-button))))

   ;; --- Itt kezdodik a keretek definicioja ---   

   ;; --- Normal keret (inaktiv) ---
   (define nfrm
     `(,@ntitle ,@nbtn ,@bord)) ;; --- Vege a normal keretnek ---

   ;; --- Nem teglalap alaku ablakok kerete (csak cimsor) ---
   (define shpfrm
     `(,@ntitle ,@nbtn)) ;; --- Vege a shaped keretnek ---

   ;; --- arnyekolt keret (szinten csak cimsor, de mas kepekkel) ---
   (define shdfrm
     `(,@stitle ,@nbtn)) ;; --- Vege az arnyekolt keretnek ---

   ;; --- Tranziens keret (parbeszedablak) ---
   (define tnfrm
     `(,@tntitle ,@tbtn ,@bord)) ;; --- Vege a tranziens keretnek ---
	
   ;; --- Tranziens-shaped keret (csak cimsor, tranziens) ---
   (define tshpfrm
     `(,@tntitle ,@tbtn)) ;; --- Vege a tranziens-shaped keretnek ---
  
   ;; --- arnyekolt tranziens keret ---
   (define tshdfrm
      `(,@tstitle ,@tbtn)) ;; --- Vege az arnyekolt tranziens keretnek ---

  ) ;; --- Vege a pixelszelessegdefinicionak

 ) ;; --- Vege a keretdefinicionak ---

 ;; --- Temadefinicio ---  
 (add-frame-style 'GnoMETA
   (lambda (w type)   
     (case type
      ((default) nfrm)
      ((shaped) shpfrm)
      ((shaded) shdfrm)
      ((transient) tnfrm)
      ((shaped-transient) tshpfrm)
      ((shaded-transient) tshdfrm)
      ((unframed) nil-frame)))) ;; --- Temadefinicio vege ---

 (call-after-property-changed 'WM-NAME
    (lambda ()
       (rebuild-frames-with-style 'GnoMETA)))
) 
;; --- Ez itt a fajl vege. Tovabb olvasni nem erdemes ;-) ---