;; This LISP stuff is pretty much borrowed from mavosBox and Redmonk.
;; I think I know how it works now... almost ;-)

(require 'gradient)

(let*
    ;; Update window title pixel length
    ((title-width
      (lambda (w)
	(let
	    ((w-width (car (window-dimensions w))))
	  (max 0 (min (- w-width 70) (+ (text-width (window-name w)) 40))))))

     (bottom-images (make-image "bottom.png"))

     (top-left-images (list (make-image "top_left.png")))
     (top-left-shaped-images (list (make-image "top_left_s.png")))

     (top-border-images (make-image "top_border.png"))
     (bottom-border-images (make-image "bottom_border.png"))

     (top-right-images (make-image "top_right.png"))
     (top-right-shaped-images (make-image "top_right_s.png"))

     (bottom-left-images (list (make-image "bottom_left_inactive.png")
			       (make-image "bottom_left.png")))

     (bottom-right-images (list (make-image "bottom_right_inactive.png")
				(make-image "bottom_right.png")))

     (close-images (list (make-image "close_normal.png")
			 (make-image "close_active.png") nil
			 (make-image "close_clicked.png")))

     (maximize-images (list (make-image "maximize_normal.png")
			    (make-image "maximize_active.png") nil
			    (make-image "maximize_clicked.png")))

     (iconify-images (list (make-image "minimize_normal.png")
			   (make-image "minimize_active.png") nil
			   (make-image "minimize_clicked.png")))

     (left-images (make-image "left.png"))

     (right-images (make-image "right.png"))

     (text-colors '("white" "white"))

     (fonts '("-adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-iso8859-15"
	      "-adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-iso8859-15"))

     ;; gradients
     (active-from-color (get-color "#4b6983"))
     (active-to-color (get-color "#dcdad5"))

     (inactive-from-color (get-color "#b9b5aa"))
     (inactive-to-color (get-color "#dcdad5"))
			
     (render-gradient (lambda (img state)
			(apply draw-horizontal-gradient img
						  (if (eq state 'focused)
						      (list active-from-color
							    active-to-color)
						    (list inactive-from-color
							  inactive-to-color)))))
     (render-gradient-top-left (lambda (img state)
			(apply draw-vertical-gradient img
						  (if (eq state 'focused)
						      (list active-from-color
							    active-to-color)
						    (list inactive-from-color
							  inactive-to-color)))))

     (render-background (lambda (img state)
			  (clear-image img active-to-color)))
						    
     ;; Icon handling
     (default-icon (make-image "icon.png"))

     (frame `(((background . ,top-left-images)
	       (left-edge . -4)
	       (top-edge . -18)
	       (class . top-left-corner))

	      ;; top hot
	      (;(background . ,top-hot-images)
	       (renderer . ,render-gradient)
	       (render-scale . 2)
	       (foreground . ,text-colors)
	       (text . ,window-name)
	       (x-justify . 19)
	       (y-justify . center)
	       (top-edge . -16)
	       (height . 16)
	       (left-edge . -2)
	       (below-client . t)
	       (width . ,(lambda (w) (+ (title-width w) 30)))
	       (class . title))

	      ;; top left gradient
	      ((renderer . ,render-gradient-top-left)
	       (render-scale . 2)
	       (height . 13)
	       (width . 2)
	       (top-edge . 0)
	       (left-edge . -2)
	       (class . title))

	      ;; menu button
	      ((background . ,(lambda (w)
                     (let ((icon (window-icon-image w)))
                       (if icon icon default-icon))))
	       (top-edge . -16)
	       (left-edge . -2)
	       (width . 16)
	       (height . 16)
	       (class . menu-button))

	      ;; top grey
	      ((renderer . ,render-background)
	       (render-scale . 2)
	       (top-edge . -16)
	       (left-edge . ,(lambda (w) (+ (title-width w) 28)))
	       (right-edge . 40)
	       (height . 16)
	       (class . title))

	      ;; top border
	      ((background . ,top-border-images)
	       (top-edge . -18)
	       (left-edge . 0)
	       (right-edge . 0)
	       (class . top-border))

	      ;; left border
	      ((background . ,left-images)
	       (left-edge . -4)
	       (top-edge . 13)
	       (bottom-edge . 0)
	       (class . left-border))

	      ;; top-right corner
	      ((background . ,top-right-images)
	       (right-edge . -4)
	       (top-edge . -18)
	       (class . top-right-corner))

	      ;; right border
	      ((background . ,right-images)
	       (right-edge . -4)
	       (top-edge . 0)
	       (bottom-edge . 0)
	       (class . right-border))

	      ;; bottom border
	      ((background . ,bottom-images)
	       (left-edge . 0)
	       (right-edge . 0)
	       (bottom-edge . -4)
	       (class . bottom-border))

	      ;; bottom-left corner
	      ((background . ,bottom-left-images)
	       (left-edge . -4)
	       (bottom-edge . -4)
	       (class . bottom-left-corner))

	      ;; bottom-right corner
	      ((background . ,bottom-right-images)
	       (right-edge . -4)
	       (bottom-edge . -4)
	       (class . bottom-right-corner))

	      ;; iconify button
	      ((background . ,iconify-images)
	       (right-edge . 27)
	       (top-edge . -16)
	       (class . iconify-button))

	      ;; maximize button
	      ((background . ,maximize-images)
	       (right-edge . 13)
	       (top-edge . -16)
	       (class . maximize-button))

	      ;; delete button
	      ((background . ,close-images)
	       (right-edge . 0)
	       (top-edge . -16)
	       (class . close-button))))

       (shaped-frame `(((background . ,top-left-shaped-images)
			(left-edge . -4)
			(top-edge . -18)
			(height . 20)
			(class . top-left-corner))

		       ;; top hot
		       ((renderer . ,render-gradient)
			(render-scale . 2)
			(foreground . ,text-colors)
			(text . ,window-name)
			(x-justify . 19)
			(y-justify . center)
			(top-edge . -16)
			(left-edge . -2)
			(height . 16)
			(width . ,(lambda (w) (+ (title-width w) 30)))
			(class . title))

		       ;; menu button
		       ((background . ,(lambda (w)
					 (let ((icon (window-icon-image w)))
					   (if icon icon default-icon))))
			(top-edge . -16)
			(left-edge . -2)
			(width . 16)
			(height . 16)
			(class . menu-button))

		       ;; top border
		       ((background . ,top-border-images)
			(top-edge . -18)
			(left-edge . 0)
			(right-edge . 0)
			(class . top-border))

		       ;; top border
		       ((background . ,bottom-border-images)
			(top-edge . 0)
			(left-edge . 0)
			(right-edge . 0)
			(class . bottom-border))

		       ;; top grey
		       ((renderer . ,render-background)
			(render-scale . 2)
			(top-edge . -16)
			(left-edge . ,(lambda (w) (+ (title-width w) 28)))
			(right-edge . 40)
			(height . 16)
			(class . title))

		       ;; top-right corner
		       ((background . ,top-right-shaped-images)
			(right-edge . -4)
			(top-edge . -18)
			(height . 20)
			(class . top-right-corner))

		       ;; iconify button
		       ((background . ,iconify-images)
			(right-edge . 27)
			(top-edge . -16)
			(class . iconify-button))

		       ;; maximize button
		       ((background . ,maximize-images)
			(right-edge . 13)
			(top-edge . -16)
			(class . maximize-button))

		       ;; delete button
		       ((background . ,close-images)
			(right-edge . 0)
			(top-edge . -16)
			(class . close-button))))

     (transient-frame `(((background . ,top-left-images)
	       (left-edge . -4)
	       (top-edge . -18)
	       (class . top-left-corner))

	      ;; top hot
	      ((renderer . ,render-gradient)
	       (render-scale . 2)
	       (foreground . ,text-colors)
	       (text . ,window-name)
	       (x-justify . 3)
	       (y-justify . center)
	       (top-edge . -16)
	       (left-edge . -2)
	       (height . 16)
	       (width . ,(lambda (w) (+ (title-width w) 30)))
	       (class . title))

	      ;; top left gradient
	      ((renderer . ,render-gradient-top-left)
	       (render-scale . 2)
	       (height . 13)
	       (width . 2)
	       (top-edge . 0)
	       (left-edge . -2)
	       (class . title))

	      ;; top grey
	      ((renderer . ,render-background)
	       (render-scale . 2)
	       (top-edge . -16)
	       (left-edge . ,(lambda (w) (+ (title-width w) 28)))
	       (right-edge . 12)
	       (height . 16)
	       (class . title))

	      ;; left border
	      ((background . ,left-images)
	       (left-edge . -4)
	       (top-edge . 13)
	       (bottom-edge . 0)
	       (class . left-border))

	      ;; top-right corner
	      ((background . ,top-right-images)
	       (right-edge . -4)
	       (top-edge . -18)
	       (class . top-right-corner))

	      ;; right border
	      ((background . ,right-images)
	       (right-edge . -4)
	       (top-edge . 0)
	       (bottom-edge . 0)
	       (class . right-border))

	      ;; top border
	      ((background . ,top-border-images)
	       (left-edge . 0)
	       (right-edge . 0)
	       (top-edge . -18)
	       (class . bottom-border))

	      ;; bottom border
	      ((background . ,bottom-images)
	       (left-edge . 0)
	       (right-edge . 0)
	       (bottom-edge . -4)
	       (class . bottom-border))

	      ;; bottom-left corner
	      ((background . ,bottom-left-images)
	       (left-edge . -4)
	       (bottom-edge . -4)
	       (class . bottom-left-corner))

	      ;; bottom-right corner
	      ((background . ,bottom-right-images)
	       (right-edge . -4)
	       (bottom-edge . -4)
	       (class . bottom-right-corner))

	      ;; delete button
	      ((background . ,close-images)
	       (right-edge . 0)
	       (top-edge . -16)
	       (class . close-button))))

       (shaped-transient-frame `(((background . ,top-left-shaped-images)
			(left-edge . -4)
			(top-edge . -18)
			(class . top-left-corner))

		       ;; top hot
		       ((renderer . ,render-gradient)
			(render-scale . 2)
			(foreground . ,text-colors)
			(text . ,window-name)
			(x-justify . 3)
			(y-justify . center)
			(top-edge . -16)
			(left-edge . -2)
			(height . 16)
			(width . ,(lambda (w) (+ (title-width w) 30)))
			(class . title))

		       ;; top grey
		       ((renderer . ,render-background)
			(render-scale . 2)
			(top-edge . -16)
			(left-edge . ,(lambda (w) (+ (title-width w) 28)))
			(right-edge . 12)
			(height . 16)
			(class . title))

		       ;; top-right corner
		       ((background . ,top-right-shaped-images)
			(right-edge . -4)
			(top-edge . -18)
			(class . top-right-corner))

		       ;; top border
		       ((background . ,top-border-images)
		       (left-edge . 0)
		       (right-edge . 0)
		       (top-edge . -18)
		       (class . bottom-border))

		       ;; bottom border
		       ((background . ,bottom-border-images)
		       (left-edge . 0)
		       (right-edge . 0)
		       (top-edge . 0)
		       (class . bottom-border))

		       ;; delete button
		       ((background . ,close-images)
			(right-edge . 0)
			(top-edge . -16)
			(class . close-button)))))

  (add-frame-style 'GEX
		   (lambda (w type)
		     (case type
		       ((default) frame)
		       ((transient) transient-frame)
		       ((shaped) shaped-frame)
		       ((shaped-transient) shaped-transient-frame))))

  (call-after-property-changed
   'WM_NAME (lambda ()
	      (rebuild-frames-with-style 'GEX))))
