;; LushForest theme by Scott Barnes

(require 'x)

(def-frame-class left-button '((cursor . left_ptr))
 (bind-keys left-button-keymap
  "Button1-Off" 'popup-window-menu
  "Button2-Off" 'toggle-window-sticky
  "Button3-Off" 'maximize-window-toggle))
(def-frame-class right-button '((cursor . left_ptr))
 (bind-keys right-button-keymap
  "Button1-Off" 'delete-window
  "Button2-Off" 'shade-window-toggle
  "Button3-Off" 'iconify-window))

(let*
 ((fore-colors (list "#000000" "#ffffff" "#ffffff"
   "#ffffff" "#000000" "#000000"))
  (righttop (list (make-image "righttop.png")))
  (top (list (make-image "top.png")))
  (lefttop (list (make-image "lefttop.png")))
  (left (list (make-image "left.png")))
  (right (list (make-image "right.png")))
  (leftbottom (list (make-image "leftbottom.png")))
  (bottom (list (make-image "bottom.png")))
  (rightbottom (list (make-image "rightbottom.png")))
  (titlebar (list (make-image "title-i.png") (make-image "title-a.png")
   (make-image "title-a.png") (make-image "title-a.png")
   (make-image "title-i.png") (make-image "title-i.png")))
  (leftbutton (list (make-image "leftbutton-n.png")
   (make-image "leftbutton-n.png") (make-image "leftbutton-n.png")
   (make-image "leftbutton-c.png") (make-image "leftbutton-n.png")
   (make-image "leftbutton-c.png")))
  (rightbutton (list (make-image "rightbutton-n.png")
   (make-image "rightbutton-n.png") (make-image "rightbutton-n.png")
   (make-image "rightbutton-c.png") (make-image "rightbutton-n.png")
   (make-image "rightbutton-c.png")))
  (default-icon (scale-image (make-image "icon.png") 14 14))
  (get-win-icon (lambda (w)
    (let ((icon (window-icon-image w)))
     (if icon (scale-image icon 14 14) default-icon))))
  (normal
   `(
    ((top-edge . -18)
     (right-edge . 19)
     (left-edge . 19)
     (foreground . ,fore-colors)
     (x-justify . 3)
     (y-justify . 1)
     (text . ,window-name)
     (background . ,titlebar)
     (class . title))
    ((top-edge . -18)
     (left-edge . 0)
     (background . ,leftbutton)
     (foreground . ,get-win-icon)
     (class . left-button))
    ((top-edge . -18)
     (right-edge . 0)
     (background . ,rightbutton)
     (class . right-button))
    ((top-edge . -22)
     (left-edge . 0)
     (right-edge . 0)
     (background . ,top)
     (class . top-border))
    ((bottom-edge . 0)
     (top-edge . -18)
     (left-edge . -4)
     (background . ,left)
     (class . left-border))
    ((top-edge . -18)
     (right-edge . -4)
     (bottom-edge . 0)
     (background . ,right)
     (class . right-border))
    ((right-edge . 0)
     (bottom-edge . -4)
     (left-edge . 0)
     (background . ,bottom)
     (class . bottom-border))
    ((top-edge . -22)
     (left-edge . -4)
     (background . ,lefttop)
     (class . top-left-corner))
    ((right-edge . -4)
     (top-edge . -22)
     (background . ,righttop)
     (class . top-right-corner))
    ((bottom-edge . -4)
     (left-edge . -4)
     (background . ,leftbottom)
     (class . bottom-left-corner))
    ((right-edge . -4)
     (bottom-edge . -4)
     (background . ,rightbottom)
     (class . bottom-right-corner))))
  (shape
   `(
    ((left-edge . 19)
     (right-edge . 19)
     (top-edge . -18)
     (foreground . ,fore-colors)
     (x-justify . 3)
     (y-justify . 1)
     (text . ,window-name)
     (background . ,titlebar)
     (class . title))
    ((left-edge . 0)
     (top-edge . -18)
     (background . ,leftbutton)
     (foreground . ,get-win-icon)
     (class . left-button))
    ((top-edge . -18)
     (right-edge . 0)
     (background . ,rightbutton)
     (class . right-button))
    ((right-edge . 0)
     (left-edge . 0)
     (top-edge . -22)
     (background . ,top)
     (class . topline))
    ((top-edge . -18)
     (left-edge . -4)
     (height . 18)
     (background . ,left)
     (class . leftline))
    ((right-edge . -4)
     (height . 18)
     (top-edge . -18)
     (background . ,right)
     (class . rightline))
    ((right-edge . 0)
     (left-edge . 0)
     (top-edge . 0)
     (background . ,bottom)
     (class . bottomline))
    ((top-edge . -22)
     (left-edge . -4)
     (background . ,lefttop)
     (class . topleftline))
    ((right-edge . -4)
     (top-edge . -22)
     (background . ,righttop)
     (class . toprightline))
    ((top-edge . 0)
     (left-edge . -4)
     (background . ,leftbottom)
     (class . bottomleftline))
    ((top-edge . 0)
     (right-edge . -4)
     (background . ,rightbottom)
     (class . bottomrightline)))))
 (add-frame-style 'LushForest
  (lambda (w type)
   (case type
    ((default) normal)
    ((transient) normal)
    ((shaped) shape)
    ((shaped-transient) shape)
	((shaded) shape)
    ((shaded-transient) shape)))))
