/* Evolution calendar - Live view client object
 *
 * Copyright (C) 2001 Ximian, Inc.
 *
 * Author: Federico Mena-Quintero <federico@ximian.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef E_CAL_VIEW_H
#define E_CAL_VIEW_H

#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include "e-cal-types.h"
#include "e-cal-view-listener.h"

G_BEGIN_DECLS

#define E_TYPE_CAL_VIEW            (e_cal_view_get_type ())
#define E_CAL_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), E_TYPE_CAL_VIEW, ECalView))
#define E_CAL_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), E_TYPE_CAL_VIEW, ECalViewClass))
#define E_IS_CAL_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E_TYPE_CAL_VIEW))
#define E_IS_CAL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), E_TYPE_CAL_VIEW))

typedef struct _ECalView ECalView;
typedef struct _ECalViewClass ECalViewClass;
typedef struct _ECalViewPrivate ECalViewPrivate;
struct _ECal;

struct _ECalView {
 	GObject object;
};

struct _ECalViewClass {
	GObjectClass parent_class;

	/* Notification signals */
	void (* objects_added) (ECalView *view, GList *objects);
	void (* objects_modified) (ECalView *view, GList *objects);
	void (* objects_removed) (ECalView *view, GList *uids);
	void (* view_progress) (ECalView *view, char *message, int percent);
	void (* view_done) (ECalView *view, ECalendarStatus status);
};

GType      e_cal_view_get_type (void);

ECalView *e_cal_view_new (DBusGProxy *view_proxy, ECalViewListener *listener, struct _ECal *client);
struct _ECal *e_cal_view_get_client (ECalView *view);
void e_cal_view_start (ECalView *view);

G_END_DECLS

#endif
