/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol-query.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-symbol-query
 * @title: IAnjutaSymbolQuery
 * @short_description: Source code symbol query interface
 * @see_also: #IAnjutaSymbolManager, #IAnjutaSymbol
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-symbol-query.h
 * 
 * A query object will have this interface that allows to tweak various
 * query parameters. Except for the #IAnjutaSymbolQueryName and
 * #IAnjutaSymbolQueryDb parameters, everything else is changable
 * post-creation.
 *
 * Note that chaning a query parameter, except for limit and offset will
 * result in re-preparing the query the next time it is executed, so it is
 * not advisable to change it each time the query is executed. For such
 * cases, create different queries with different parameters.
 *
 * A query is signified by a name enumeration (#IAnjutaSymbolQueryName) which
 * practically determines the query type and its execution condition. Each
 * query name is assigned to pre-defined query statement and can only be
 * set during creation time. Then only its specific ianjuta_symbol_query_search_*()
 * can be used to execute the query. These specific execution methods are
 * provided to make it convenient to pass query parameters easily and to
 * ensure all the needed parameters are given.
 *
 * A query can run in different modes, defined by #IAnjutaSymbolQueryMode, by
 * default it is executed in synchrounous mode #IANJUTA_SYMBOL_QUERY_MODE_SYNC
 * and can be changed using ianjuta_symbol_query_set_mode().
 * #IANJUTA_SYMBOL_QUERY_MODE_ASYNC runs it in asynchronous mode in a separate
 * thread and can be canceled with ianjuta_symbol_query_cancel().
 * 
 * A query runs on a database, defined by #IAnjutaSymbolQueryDb, and can be
 * only selected at creatation time.
 * 
 * In addition, there are many other filters that can be set to the query
 * to refine the query results. For example, ianjuta_symbol_query_set_fields()
 * is used to set the needed symbol fields to retrieve, ianjuta_symbol_query_set_filters()
 * is used to filter the results with symbol types, ianjuta_symbol_query_set_file_scope()
 * limits the results to either public or private scope within the source file,
 * ianjuta_symbol_query_set_group_by() is used to group the results on a given
 * field, ianjuta_symbol_query_set_order_by is used to order the results on a
 * given field.
 * 
 * ianjuta_symbol_query_set_limit() and ianjuta_symbol_query_set_offset() are
 * used to change limit and offset of the resultset. Note again that these
 * parameters do not require re-preparation of query, so can be safely used
 * any time without performance hit.
 */

#include "ianjuta-symbol-query.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_symbol_query_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-symbol-query-quark");
	}
	
	return quark;
}

/**
 * ianjuta_symbol_query_set_cancel:
 * @obj: Self
 * @err: Error propagation and reporting.
 * 
 * Cancels any pending non-sync searches. After calling this, it is
 * guaranteed that "async-result" will not be called any more for any
 * past searches. New searches will have their results signaled as
 * normal.
 */
void
ianjuta_symbol_query_cancel (IAnjutaSymbolQuery *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj));
	IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->cancel (obj, err);
}

/* Default implementation */
static void
ianjuta_symbol_query_cancel_default (IAnjutaSymbolQuery *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_symbol_query_search:
 * @obj: Self
 * @pattern: Search pattern in compliance with SQL LIKE syntax
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search (IAnjutaSymbolQuery *obj, const gchar *pattern, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search (obj, pattern, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_default (IAnjutaSymbolQuery *obj, const gchar *pattern, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_search_all:
 * @obj: Self
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH_ALL query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search_all (IAnjutaSymbolQuery *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search_all (obj, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_all_default (IAnjutaSymbolQuery *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_search_class_parents:
 * @obj: Self
 * @symbol: The class symbol whose parents to get.
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH_CLASS_PARENTS query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search_class_parents (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	g_return_val_if_fail ((symbol == NULL) ||IANJUTA_IS_SYMBOL(symbol), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search_class_parents (obj, symbol, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_class_parents_default (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_search_file:
 * @obj: Self
 * @pattern: Search pattern in compliance with SQL LIKE syntax
 * @file: The file whose symbols are searched.
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH_FILE query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search_file (IAnjutaSymbolQuery *obj, const gchar *pattern,   const GFile *file, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search_file (obj, pattern, file, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_file_default (IAnjutaSymbolQuery *obj, const gchar *pattern,   const GFile *file, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_search_id:
 * @obj: Self
 * @symbol: The symbol id whose details to get.
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH_ID query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search_id (IAnjutaSymbolQuery *obj, gint symbol_id, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search_id (obj, symbol_id, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_id_default (IAnjutaSymbolQuery *obj, gint symbol_id, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_search_in_scope:
 * @obj: Self
 * @pattern: Search pattern in compliance with SQL LIKE syntax
 * @scope: The scope inside which symbols are searched.
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH_IN_SCOPE query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search_in_scope (IAnjutaSymbolQuery *obj, const gchar *pattern,   IAnjutaSymbol *scope, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	g_return_val_if_fail ((scope == NULL) ||IANJUTA_IS_SYMBOL(scope), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search_in_scope (obj, pattern, scope, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_in_scope_default (IAnjutaSymbolQuery *obj, const gchar *pattern,   IAnjutaSymbol *scope, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_search_members:
 * @obj: Self
 * @symbol: The symbol whose members to get.
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH_MEMBERS query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search_members (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	g_return_val_if_fail ((symbol == NULL) ||IANJUTA_IS_SYMBOL(symbol), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search_members (obj, symbol, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_members_default (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_search_parent_scope:
 * @obj: Self
 * @symbol: The symbol whose parent scope is to be found.
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search_parent_scope (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	g_return_val_if_fail ((symbol == NULL) ||IANJUTA_IS_SYMBOL(symbol), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search_parent_scope (obj, symbol, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_parent_scope_default (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_search_parent_scope_file:
 * @symbol: The symbol whose parent scope is to be found.
 * @obj: Self
 * @file_path: The file where the parent scope is to be found.
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE_FILE query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search_parent_scope_file (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol,   const gchar *file_path, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	g_return_val_if_fail ((symbol == NULL) ||IANJUTA_IS_SYMBOL(symbol), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search_parent_scope_file (obj, symbol, file_path, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_parent_scope_file_default (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol,   const gchar *file_path, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_search_scope:
 * @obj: Self
 * @file_path: The file where the scope is.
 * @line: The line where the scope is.
 * @err: Error propagation and reporting.
 * 
 * Executes #IANJUTA_SYMBOL_QUERY_SEARCH_SCOPE query.
 */
IAnjutaIterable*
ianjuta_symbol_query_search_scope (IAnjutaSymbolQuery *obj, const gchar *file_path,   gint line, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj), NULL);
	return IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->search_scope (obj, file_path, line, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_query_search_scope_default (IAnjutaSymbolQuery *obj, const gchar *file_path,   gint line, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_query_set_fields:
 * @obj: Self
 * @n_fields: Then number of fields to retrieve.
 * @fields: The fields to retrieve in the query. The array length must
 *   be @n_fields.
 * @err: Error propagation and reporting.
 * 
 * Sets the fields of Query.
 */
void
ianjuta_symbol_query_set_fields (IAnjutaSymbolQuery *obj, gint n_fields,   IAnjutaSymbolField *fields, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj));
	IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->set_fields (obj, n_fields, fields, err);
}

/* Default implementation */
static void
ianjuta_symbol_query_set_fields_default (IAnjutaSymbolQuery *obj, gint n_fields,   IAnjutaSymbolField *fields, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_symbol_query_set_file_scope:
 * @obj: Self
 * @filescope_search: The filescope to search.
 * @err: Error propagation and reporting.
 * 
 * Sets the filescope search of Query.
 */
void
ianjuta_symbol_query_set_file_scope (IAnjutaSymbolQuery *obj, IAnjutaSymbolQueryFileScope filescope_search, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj));
	IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->set_file_scope (obj, filescope_search, err);
}

/* Default implementation */
static void
ianjuta_symbol_query_set_file_scope_default (IAnjutaSymbolQuery *obj, IAnjutaSymbolQueryFileScope filescope_search, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_symbol_query_set_filters:
 * @obj: Self
 * @filters: The mode of query.
 * @include_types: TRUE if filter is positive, FALSE if reversed.
 * @err: Error propagation and reporting.
 * 
 * Sets the bit mask of symbol type filters. if @include_types is TRUE,
 * symbols satisfying the given symbol types are selected, otherwise
 * they are excluded.
 */
void
ianjuta_symbol_query_set_filters (IAnjutaSymbolQuery *obj, IAnjutaSymbolType filters,   gboolean includes_types, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj));
	IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->set_filters (obj, filters, includes_types, err);
}

/* Default implementation */
static void
ianjuta_symbol_query_set_filters_default (IAnjutaSymbolQuery *obj, IAnjutaSymbolType filters,   gboolean includes_types, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_symbol_query_set_group_by:
 * @obj: Self
 * @field: The field to group results.
 * @err: Error propagation and reporting.
 * 
 * Sets the field with which result of query is grouped. As a result
 * there will be no duplicates of with this field.
 */
void
ianjuta_symbol_query_set_group_by (IAnjutaSymbolQuery *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj));
	IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->set_group_by (obj, field, err);
}

/* Default implementation */
static void
ianjuta_symbol_query_set_group_by_default (IAnjutaSymbolQuery *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_symbol_query_set_limit:
 * @obj: Self
 * @limit: The limit of query.
 * @err: Error propagation and reporting.
 * 
 * Sets the limit of Query results. No more than @limit results are
 * returned.
 */
void
ianjuta_symbol_query_set_limit (IAnjutaSymbolQuery *obj, gint limit, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj));
	IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->set_limit (obj, limit, err);
}

/* Default implementation */
static void
ianjuta_symbol_query_set_limit_default (IAnjutaSymbolQuery *obj, gint limit, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_symbol_query_set_mode:
 * @obj: Self
 * @mode: The mode of query.
 * @err: Error propagation and reporting.
 * 
 * Sets the mode of Query.
 */
void
ianjuta_symbol_query_set_mode (IAnjutaSymbolQuery *obj, IAnjutaSymbolQueryMode mode, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj));
	IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->set_mode (obj, mode, err);
}

/* Default implementation */
static void
ianjuta_symbol_query_set_mode_default (IAnjutaSymbolQuery *obj, IAnjutaSymbolQueryMode mode, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_symbol_query_set_offset:
 * @obj: Self
 * @offset: Offset of the resultset.
 * @err: Error propagation and reporting.
 * 
 * Sets the offset index of Query results.
 */
void
ianjuta_symbol_query_set_offset (IAnjutaSymbolQuery *obj, gint offset, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj));
	IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->set_offset (obj, offset, err);
}

/* Default implementation */
static void
ianjuta_symbol_query_set_offset_default (IAnjutaSymbolQuery *obj, gint offset, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_symbol_query_set_order_by:
 * @obj: Self
 * @field: The field to order the result.
 * @err: Error propagation and reporting.
 * 
 * Sets the field with which result of query is ordered.
 */
void
ianjuta_symbol_query_set_order_by (IAnjutaSymbolQuery *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_QUERY(obj));
	IANJUTA_SYMBOL_QUERY_GET_IFACE (obj)->set_order_by (obj, field, err);
}

/* Default implementation */
static void
ianjuta_symbol_query_set_order_by_default (IAnjutaSymbolQuery *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_symbol_query_base_init (IAnjutaSymbolQueryIface* klass)
{
	static gboolean initialized = FALSE;

	klass->cancel = ianjuta_symbol_query_cancel_default;
	klass->search = ianjuta_symbol_query_search_default;
	klass->search_all = ianjuta_symbol_query_search_all_default;
	klass->search_class_parents = ianjuta_symbol_query_search_class_parents_default;
	klass->search_file = ianjuta_symbol_query_search_file_default;
	klass->search_id = ianjuta_symbol_query_search_id_default;
	klass->search_in_scope = ianjuta_symbol_query_search_in_scope_default;
	klass->search_members = ianjuta_symbol_query_search_members_default;
	klass->search_parent_scope = ianjuta_symbol_query_search_parent_scope_default;
	klass->search_parent_scope_file = ianjuta_symbol_query_search_parent_scope_file_default;
	klass->search_scope = ianjuta_symbol_query_search_scope_default;
	klass->set_fields = ianjuta_symbol_query_set_fields_default;
	klass->set_file_scope = ianjuta_symbol_query_set_file_scope_default;
	klass->set_filters = ianjuta_symbol_query_set_filters_default;
	klass->set_group_by = ianjuta_symbol_query_set_group_by_default;
	klass->set_limit = ianjuta_symbol_query_set_limit_default;
	klass->set_mode = ianjuta_symbol_query_set_mode_default;
	klass->set_offset = ianjuta_symbol_query_set_offset_default;
	klass->set_order_by = ianjuta_symbol_query_set_order_by_default;
	
	if (!initialized) {

		/**
		 * IAnjutaSymbolQuery::async_result:
		 * @ianjutasymbolquery: Self
		 * @arg1: Query result (IAnjutaIterable, IAnjutaSymbol) of an async
		 *     or queued search. NULL if no result is found or some error happened.
		 *
		 * This signal is emitted for every search of the Query involved in async
		 * mode, unless cancled by ianjuta_symbol_query_cancel(). For single queued
		 * query, only result of the last search is emitted (if it wasn't database
		 * was busy when search was invoked). Unlike in sync counterpart,
		 * do not unref @result after use.
		 */
		g_signal_new ("async-result",
			IANJUTA_TYPE_SYMBOL_QUERY,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolQueryIface, async_result),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__OBJECT,
			G_TYPE_NONE,
			1,
			G_TYPE_OBJECT);


		initialized = TRUE;
	}
}

GType
ianjuta_symbol_query_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaSymbolQueryIface),
			(GBaseInitFunc) ianjuta_symbol_query_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaSymbolQuery", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_symbol_query_db_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_QUERY_DB_PROJECT, "IANJUTA_SYMBOL_QUERY_DB_PROJECT", "db-project" }, 
		{ IANJUTA_SYMBOL_QUERY_DB_SYSTEM, "IANJUTA_SYMBOL_QUERY_DB_SYSTEM", "db-system" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolQueryDb", values);
	}

	return type;
}

GType
ianjuta_symbol_query_file_scope_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_QUERY_SEARCH_FS_IGNORE, "IANJUTA_SYMBOL_QUERY_SEARCH_FS_IGNORE", "search-fs-ignore" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_FS_PUBLIC, "IANJUTA_SYMBOL_QUERY_SEARCH_FS_PUBLIC", "search-fs-public" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_FS_PRIVATE, "IANJUTA_SYMBOL_QUERY_SEARCH_FS_PRIVATE", "search-fs-private" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolQueryFileScope", values);
	}

	return type;
}

GType
ianjuta_symbol_query_mode_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_QUERY_MODE_SYNC, "IANJUTA_SYMBOL_QUERY_MODE_SYNC", "mode-sync" }, 
		{ IANJUTA_SYMBOL_QUERY_MODE_ASYNC, "IANJUTA_SYMBOL_QUERY_MODE_ASYNC", "mode-async" }, 
		{ IANJUTA_SYMBOL_QUERY_MODE_QUEUED, "IANJUTA_SYMBOL_QUERY_MODE_QUEUED", "mode-queued" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolQueryMode", values);
	}

	return type;
}

GType
ianjuta_symbol_query_name_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_QUERY_SEARCH, "IANJUTA_SYMBOL_QUERY_SEARCH", "search" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_ALL, "IANJUTA_SYMBOL_QUERY_SEARCH_ALL", "search-all" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_FILE, "IANJUTA_SYMBOL_QUERY_SEARCH_FILE", "search-file" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_IN_SCOPE, "IANJUTA_SYMBOL_QUERY_SEARCH_IN_SCOPE", "search-in-scope" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_ID, "IANJUTA_SYMBOL_QUERY_SEARCH_ID", "search-id" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_MEMBERS, "IANJUTA_SYMBOL_QUERY_SEARCH_MEMBERS", "search-members" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_CLASS_PARENTS, "IANJUTA_SYMBOL_QUERY_SEARCH_CLASS_PARENTS", "search-class-parents" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_SCOPE, "IANJUTA_SYMBOL_QUERY_SEARCH_SCOPE", "search-scope" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE, "IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE", "search-parent-scope" }, 
		{ IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE_FILE, "IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE_FILE", "search-parent-scope-file" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolQueryName", values);
	}

	return type;
}
