/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-buildable.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_BUILDABLE_H_
#define _IANJUTA_BUILDABLE_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_BUILDABLE (ianjuta_buildable_get_type ())
#define IANJUTA_BUILDABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_BUILDABLE, IAnjutaBuildable))
#define IANJUTA_IS_BUILDABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_BUILDABLE))
#define IANJUTA_BUILDABLE_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_BUILDABLE, IAnjutaBuildableIface))

#define IANJUTA_TYPE_BUILDABLE_COMMAND (ianjuta_buildable_command_get_type())

#define IANJUTA_BUILDABLE_ERROR ianjuta_buildable_error_quark()

typedef struct _IAnjutaBuildable IAnjutaBuildable;
typedef struct _IAnjutaBuildableIface IAnjutaBuildableIface;

/**
   * IAnjutaBuildableCommand:
   * @IANJUTA_BUILDABLE_COMMAND_COMPILE: Compile source
   * @IANJUTA_BUILDABLE_COMMAND_BUILD: Build file (normally using make)
   * @IANJUTA_BUILDABLE_COMMAND_BUILD_TARBALL: make dist
   * @IANJUTA_BUILDABLE_COMMAND_INSTALL: make install
   * @IANJUTA_BUILDABLE_COMMAND_CONFIGURE: ./configure
   * @IANJUTA_BUILDABLE_COMMAND_GENERATE: ./autogen.sh
   * @IANJUTA_BUILDABLE_COMMAND_CLEAN: make clean
   * @IANJUTA_BUILDABLE_COMMAND_EXECUTE: ./hello
   * @IANJUTA_BUILDABLE_COMMAND_IS_BUILT: check whether object files are up-to-date      
   * @IANJUTA_BUILDABLE_COMMAND_DISTCLEAN: make distclean
   * @IANJUTA_BUILDABLE_N_COMMANDS: size of enum
   *
   * The enumeration is used to speficy the disered build operation
   */	 
typedef enum {
	IANJUTA_BUILDABLE_COMMAND_COMPILE,
	IANJUTA_BUILDABLE_COMMAND_BUILD,
	IANJUTA_BUILDABLE_COMMAND_BUILD_TARBALL,
	IANJUTA_BUILDABLE_COMMAND_INSTALL,
	IANJUTA_BUILDABLE_COMMAND_CONFIGURE,
	IANJUTA_BUILDABLE_COMMAND_GENERATE,
	IANJUTA_BUILDABLE_COMMAND_CLEAN,
	IANJUTA_BUILDABLE_COMMAND_EXECUTE,
	IANJUTA_BUILDABLE_COMMAND_IS_BUILT,
	IANJUTA_BUILDABLE_COMMAND_AUTORECONF,
	IANJUTA_BUILDABLE_COMMAND_DISTCLEAN,
	IANJUTA_BUILDABLE_N_COMMANDS
} IAnjutaBuildableCommand;


struct _IAnjutaBuildableIface {
	GTypeInterface g_iface;
	

	void (*build) (IAnjutaBuildable *obj, const gchar *uri, GError **err);
	void (*clean) (IAnjutaBuildable *obj, const gchar *uri, GError **err);
	void (*configure) (IAnjutaBuildable *obj, const gchar *uri, GError **err);
	void (*execute) (IAnjutaBuildable *obj, const gchar *uri, GError **err);
	void (*generate) (IAnjutaBuildable *obj, const gchar *uri, GError **err);
	const gchar* (*get_command) (IAnjutaBuildable *obj, IAnjutaBuildableCommand command_id, GError **err);
	void (*install) (IAnjutaBuildable *obj, const gchar *uri, GError **err);
	void (*reset_commands) (IAnjutaBuildable *obj, GError **err);
	void (*set_command) (IAnjutaBuildable *obj, IAnjutaBuildableCommand command_id,  const gchar *command, GError **err);

};

GType ianjuta_buildable_command_get_type (void);

GQuark ianjuta_buildable_error_quark     (void);
GType  ianjuta_buildable_get_type        (void);

void ianjuta_buildable_build (IAnjutaBuildable *obj, const gchar *uri, GError **err);

void ianjuta_buildable_clean (IAnjutaBuildable *obj, const gchar *uri, GError **err);

void ianjuta_buildable_configure (IAnjutaBuildable *obj, const gchar *uri, GError **err);

void ianjuta_buildable_execute (IAnjutaBuildable *obj, const gchar *uri, GError **err);

void ianjuta_buildable_generate (IAnjutaBuildable *obj, const gchar *uri, GError **err);

const gchar* ianjuta_buildable_get_command (IAnjutaBuildable *obj, IAnjutaBuildableCommand command_id, GError **err);

void ianjuta_buildable_install (IAnjutaBuildable *obj, const gchar *uri, GError **err);

void ianjuta_buildable_reset_commands (IAnjutaBuildable *obj, GError **err);

void ianjuta_buildable_set_command (IAnjutaBuildable *obj, IAnjutaBuildableCommand command_id,  const gchar *command, GError **err);


G_END_DECLS

#endif
