/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-breakpoint.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_DEBUGGER_BREAKPOINT_H_
#define _IANJUTA_DEBUGGER_BREAKPOINT_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-debugger.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_DEBUGGER_BREAKPOINT (ianjuta_debugger_breakpoint_get_type ())
#define IANJUTA_DEBUGGER_BREAKPOINT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_DEBUGGER_BREAKPOINT, IAnjutaDebuggerBreakpoint))
#define IANJUTA_IS_DEBUGGER_BREAKPOINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_DEBUGGER_BREAKPOINT))
#define IANJUTA_DEBUGGER_BREAKPOINT_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_DEBUGGER_BREAKPOINT, IAnjutaDebuggerBreakpointIface))

#define IANJUTA_TYPE_DEBUGGER_BREAKPOINT_METHOD (ianjuta_debugger_breakpoint_method_get_type())
#define IANJUTA_TYPE_DEBUGGER_BREAKPOINT_TYPE (ianjuta_debugger_breakpoint_type_get_type())

#define IANJUTA_DEBUGGER_BREAKPOINT_ERROR ianjuta_debugger_breakpoint_error_quark()

typedef struct _IAnjutaDebuggerBreakpoint IAnjutaDebuggerBreakpoint;
typedef struct _IAnjutaDebuggerBreakpointIface IAnjutaDebuggerBreakpointIface;

typedef enum {
	IANJUTA_DEBUGGER_BREAKPOINT_SET_AT_ADDRESS = 1 << 0,
	IANJUTA_DEBUGGER_BREAKPOINT_SET_AT_FUNCTION = 1 << 1,
	IANJUTA_DEBUGGER_BREAKPOINT_ENABLE = 1 << 2,
	IANJUTA_DEBUGGER_BREAKPOINT_IGNORE = 1 << 3,
	IANJUTA_DEBUGGER_BREAKPOINT_CONDITION = 1 << 4
} IAnjutaDebuggerBreakpointMethod;

typedef enum {
	IANJUTA_DEBUGGER_BREAKPOINT_REMOVED = 1 << 0,
	IANJUTA_DEBUGGER_BREAKPOINT_UPDATED = 1 << 17,
	IANJUTA_DEBUGGER_BREAKPOINT_ON_LINE = 1 << 1,
	IANJUTA_DEBUGGER_BREAKPOINT_ON_ADDRESS = 1 << 2,
	IANJUTA_DEBUGGER_BREAKPOINT_ON_FUNCTION = 1 << 3,
	IANJUTA_DEBUGGER_BREAKPOINT_ON_READ = 1 << 4,
	IANJUTA_DEBUGGER_BREAKPOINT_ON_WRITE = 1 << 5,
	IANJUTA_DEBUGGER_BREAKPOINT_WITH_ENABLE = 1 << 16,
	IANJUTA_DEBUGGER_BREAKPOINT_WITH_IGNORE = 1 << 15,
	IANJUTA_DEBUGGER_BREAKPOINT_WITH_TIME = 1 << 11,
	IANJUTA_DEBUGGER_BREAKPOINT_WITH_CONDITION = 1 << 12,
	IANJUTA_DEBUGGER_BREAKPOINT_WITH_TEMPORARY = 1 << 13
} IAnjutaDebuggerBreakpointType;

typedef struct _IAnjutaDebuggerBreakpointItem IAnjutaDebuggerBreakpointItem;
struct _IAnjutaDebuggerBreakpointItem {
	gint type;
	guint id;
	gchar *file;
	guint line;
	gchar *function;
	gulong address;
	gboolean enable;
	guint ignore;
	guint times;
	gchar *condition;
	gboolean temporary;
};


struct _IAnjutaDebuggerBreakpointIface {
	IAnjutaDebuggerIface g_iface;
	

	gboolean (*clear_breakpoint) (IAnjutaDebuggerBreakpoint *obj, guint id,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*condition_breakpoint) (IAnjutaDebuggerBreakpoint *obj, guint id,  const gchar* condition,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*enable_breakpoint) (IAnjutaDebuggerBreakpoint *obj, guint id,  gboolean enable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*ignore_breakpoint) (IAnjutaDebuggerBreakpoint *obj, guint id,  guint ignore,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gint (*implement_breakpoint) (IAnjutaDebuggerBreakpoint *obj, GError **err);
	gboolean (*list_breakpoint) (IAnjutaDebuggerBreakpoint *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*set_breakpoint_at_address) (IAnjutaDebuggerBreakpoint *obj, gulong address,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*set_breakpoint_at_function) (IAnjutaDebuggerBreakpoint *obj, const gchar* file,  const gchar* function,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*set_breakpoint_at_line) (IAnjutaDebuggerBreakpoint *obj, const gchar* file,  guint line,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

};

GType ianjuta_debugger_breakpoint_method_get_type (void);
GType ianjuta_debugger_breakpoint_type_get_type (void);

GQuark ianjuta_debugger_breakpoint_error_quark     (void);
GType  ianjuta_debugger_breakpoint_get_type        (void);

gboolean ianjuta_debugger_breakpoint_clear_breakpoint (IAnjutaDebuggerBreakpoint *obj, guint id,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_breakpoint_condition_breakpoint (IAnjutaDebuggerBreakpoint *obj, guint id,  const gchar* condition,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_breakpoint_enable_breakpoint (IAnjutaDebuggerBreakpoint *obj, guint id,  gboolean enable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_breakpoint_ignore_breakpoint (IAnjutaDebuggerBreakpoint *obj, guint id,  guint ignore,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gint ianjuta_debugger_breakpoint_implement_breakpoint (IAnjutaDebuggerBreakpoint *obj, GError **err);

gboolean ianjuta_debugger_breakpoint_list_breakpoint (IAnjutaDebuggerBreakpoint *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_breakpoint_set_breakpoint_at_address (IAnjutaDebuggerBreakpoint *obj, gulong address,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_breakpoint_set_breakpoint_at_function (IAnjutaDebuggerBreakpoint *obj, const gchar* file,  const gchar* function,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_breakpoint_set_breakpoint_at_line (IAnjutaDebuggerBreakpoint *obj, const gchar* file,  guint line,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);


G_END_DECLS

#endif
