/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-instruction.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_DEBUGGER_INSTRUCTION_H_
#define _IANJUTA_DEBUGGER_INSTRUCTION_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-debugger.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_DEBUGGER_INSTRUCTION (ianjuta_debugger_instruction_get_type ())
#define IANJUTA_DEBUGGER_INSTRUCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_DEBUGGER_INSTRUCTION, IAnjutaDebuggerInstruction))
#define IANJUTA_IS_DEBUGGER_INSTRUCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_DEBUGGER_INSTRUCTION))
#define IANJUTA_DEBUGGER_INSTRUCTION_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_DEBUGGER_INSTRUCTION, IAnjutaDebuggerInstructionIface))

#define IANJUTA_DEBUGGER_INSTRUCTION_ERROR ianjuta_debugger_instruction_error_quark()

typedef struct _IAnjutaDebuggerInstruction IAnjutaDebuggerInstruction;
typedef struct _IAnjutaDebuggerInstructionIface IAnjutaDebuggerInstructionIface;

typedef struct _IAnjutaDebuggerInstructionALine IAnjutaDebuggerInstructionALine;
struct _IAnjutaDebuggerInstructionALine {
	gulong address;
	const gchar *label;
	const gchar *text;
};

typedef struct _IAnjutaDebuggerInstructionDisassembly IAnjutaDebuggerInstructionDisassembly;
struct _IAnjutaDebuggerInstructionDisassembly {
	guint size;
	IAnjutaDebuggerInstructionALine data[];
};


struct _IAnjutaDebuggerInstructionIface {
	IAnjutaDebuggerIface g_iface;
	

	gboolean (*disassemble) (IAnjutaDebuggerInstruction *obj, gulong address,  guint length,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*run_to_address) (IAnjutaDebuggerInstruction *obj, gulong address, GError **err);
	gboolean (*step_in_instruction) (IAnjutaDebuggerInstruction *obj, GError **err);
	gboolean (*step_over_instruction) (IAnjutaDebuggerInstruction *obj, GError **err);

};


GQuark ianjuta_debugger_instruction_error_quark     (void);
GType  ianjuta_debugger_instruction_get_type        (void);

gboolean ianjuta_debugger_instruction_disassemble (IAnjutaDebuggerInstruction *obj, gulong address,  guint length,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_instruction_run_to_address (IAnjutaDebuggerInstruction *obj, gulong address, GError **err);

gboolean ianjuta_debugger_instruction_step_in_instruction (IAnjutaDebuggerInstruction *obj, GError **err);

gboolean ianjuta_debugger_instruction_step_over_instruction (IAnjutaDebuggerInstruction *obj, GError **err);


G_END_DECLS

#endif
