/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-symbol-manager
 * @title: IAnjutaSymbolManager
 * @short_description: Source code symbols manager inteface
 * @see_also: #IAnjutaSymbol
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-symbol-manager.h
 * 
 */

#include "ianjuta-symbol-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_symbol_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-symbol-manager-quark");
	}
	
	return quark;
}

/**
* ianjuta_symbol_manager_get_parents:
* @obj: Self
* @symbol: Symbol which you want to know the parent classes of.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
IAnjutaIterable*
ianjuta_symbol_manager_get_class_parents (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_class_parents (obj, symbol, info_fields, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_class_parents_default (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_members:
* @obj: Self
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @global_search: fixme
* @err: Error propagation and reporting.
* 
* Database query. The returned @IAnjutaIterable object must be unrefed after use.
* 
*/
IAnjutaIterable*
ianjuta_symbol_manager_get_members (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields,   gboolean global_search, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_members (obj, symbol, info_fields, global_search, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_members_default (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields,   gboolean global_search, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_parent_scope: 
* @obj: Self
* @symbol: Symbol which you want to know the parent scope of.
* @filename: Can be NULL. Full path filename where to search for the parent scope symbol.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @err: Error propagation and reporting.
* 
* Find the parent scope given a symbol
* 
* The returned @IAnjutaIterable object should contain just one element if the 
* query is successful, 
* no element or NULL is returned if function went wrong.	
* The returned @IAnjutaIterable object must be unrefed after use.
*/	
IAnjutaIterable*
ianjuta_symbol_manager_get_parent_scope (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   const gchar *filename,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_parent_scope (obj, symbol, filename, info_fields, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_parent_scope_default (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   const gchar *filename,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_scope: 
* @obj: Self
* @filename: full path of the file.
* @line line of @filename in which symbol exist.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @err: Error propagation and reporting.
* 
* Get the scope specified by the line of 
    * the file. 
*
* Returns Iterator should contain just one element if the query is successful, 
* no element or NULL is returned if function went wrong.	
* 
*/
IAnjutaIterable*
ianjuta_symbol_manager_get_scope (IAnjutaSymbolManager *obj, const gchar* filename,   gulong line,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_scope (obj, filename, line, info_fields, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_scope_default (IAnjutaSymbolManager *obj, const gchar* filename,   gulong line,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_symbol_by_id:
* @obj: Self
* @symbol_id unique id of the symbol you want to know about.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @return NULL on error.
*
* A symbol is identified by an unique id. If you have its id you can also 
* have its object IAnjutaSymbol.
*/
IAnjutaSymbol*
ianjuta_symbol_manager_get_symbol_by_id (IAnjutaSymbolManager *obj, gint symbol_id,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_symbol_by_id (obj, symbol_id, info_fields, err);
}

/* Default implementation */
static IAnjutaSymbol*
ianjuta_symbol_manager_get_symbol_by_id_default (IAnjutaSymbolManager *obj, gint symbol_id,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_symbol_more_info:
* @obj: Self
* @symbol symbol of which you want to know more infos about.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @err: Error propagation and reporting.	
*
* While at first sight this function may seem as useless, in a deeper inspection
* you can see that you can achieve speed improvements for example avoiding 
* to pass many info_fields requests to a search query, which itself could require
* complicated joins between engine tables, slowing down the thing.
* It's up to you to see which method is more performant.
*
*/	
IAnjutaIterable*
ianjuta_symbol_manager_get_symbol_more_info (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_symbol_more_info (obj, symbol, info_fields, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_symbol_more_info_default (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_search:
* @obj: Self
* @match_types: If passed IANJUTA_TYPE_MAX the function will not perfom any filter.
* @include_types: Should the result contain or exclude the match_types? TRUE to include them,
*				  FALSE to exclude. For example use may want all symbols but classes.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @match_name: fixme
* @partial_name_match: if TRUE it will search for %match_name%, it FALSE for the exact
* 					string match_name.
* @global_symbols_search: if TRUE it will search only for public/extern functions. 
* 						If FALSE it will search also for static/private functions.
* @global_tags_search: If TRUE it'll search only for system tags, using pkg-config to retrieve installed packages
* infos. If FALSE only current project's symbols will be searched.
* @results_limit: Limit results to an upper bound. -1 If you don't want to use this par.
* @results_offset: Skip results_offset results. -1 If you don't want to use this par.	 
 	* @results_limit Limit results to an upper bound. -1 If you don't want to use this par.
 	* @results_offset Skip results_offset results. -1 If you don't want to use this par.	 
* @err: Error propagation and reporting.
* 
* Database query. The returned @IAnjutaIterable object must be unrefed after use.
* 
*/
IAnjutaIterable*
ianjuta_symbol_manager_search (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *match_name,   gboolean partial_name_match,   gboolean global_symbols_search,   gboolean global_tags_search,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->search (obj, match_types, include_types, info_fields, match_name, partial_name_match, global_symbols_search, global_tags_search, results_limit, results_offset, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_search_default (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *match_name,   gboolean partial_name_match,   gboolean global_symbols_search,   gboolean global_tags_search,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_reached (NULL);
}

static void
ianjuta_symbol_manager_base_init (IAnjutaSymbolManagerIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_class_parents = ianjuta_symbol_manager_get_class_parents_default;
	klass->get_members = ianjuta_symbol_manager_get_members_default;
	klass->get_parent_scope = ianjuta_symbol_manager_get_parent_scope_default;
	klass->get_scope = ianjuta_symbol_manager_get_scope_default;
	klass->get_symbol_by_id = ianjuta_symbol_manager_get_symbol_by_id_default;
	klass->get_symbol_more_info = ianjuta_symbol_manager_get_symbol_more_info_default;
	klass->search = ianjuta_symbol_manager_search_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_symbol_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaSymbolManagerIface),
			(GBaseInitFunc) ianjuta_symbol_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaSymbolManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
