/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debug-manager.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_DEBUG_MANAGER_H_
#define _IANJUTA_DEBUG_MANAGER_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-debugger.h>
#include <libanjuta/interfaces/ianjuta-debugger-breakpoint.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_DEBUG_MANAGER (ianjuta_debug_manager_get_type ())
#define IANJUTA_DEBUG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_DEBUG_MANAGER, IAnjutaDebugManager))
#define IANJUTA_IS_DEBUG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_DEBUG_MANAGER))
#define IANJUTA_DEBUG_MANAGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_DEBUG_MANAGER, IAnjutaDebugManagerIface))

#define IANJUTA_DEBUG_MANAGER_ERROR ianjuta_debug_manager_error_quark()

typedef struct _IAnjutaDebugManager IAnjutaDebugManager;
typedef struct _IAnjutaDebugManagerIface IAnjutaDebugManagerIface;


struct _IAnjutaDebugManagerIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*breakpoint_changed) (IAnjutaDebugManager *obj, IAnjutaDebuggerBreakpointItem *breakpoint);
	/* Signal */
	void (*debugger_started) (IAnjutaDebugManager *obj);
	/* Signal */
	void (*debugger_stopped) (IAnjutaDebugManager *obj, GError *err);
	/* Signal */
	void (*frame_changed) (IAnjutaDebugManager *obj, guint frame,  gint thread);
	/* Signal */
	void (*location_changed) (IAnjutaDebugManager *obj, gulong address,  const gchar* uri,  guint line);
	/* Signal */
	void (*program_exited) (IAnjutaDebugManager *obj);
	/* Signal */
	void (*program_loaded) (IAnjutaDebugManager *obj);
	/* Signal */
	void (*program_moved) (IAnjutaDebugManager *obj, gint pid,  gint tid,  gulong address,  const gchar* file,  guint line);
	/* Signal */
	void (*program_running) (IAnjutaDebugManager *obj);
	/* Signal */
	void (*program_started) (IAnjutaDebugManager *obj);
	/* Signal */
	void (*program_stopped) (IAnjutaDebugManager *obj);
	/* Signal */
	void (*program_unloaded) (IAnjutaDebugManager *obj);
	/* Signal */
	void (*sharedlib_event) (IAnjutaDebugManager *obj);
	/* Signal */
	void (*signal_received) (IAnjutaDebugManager *obj, const gchar* name,  const gchar* description);


};

GQuark ianjuta_debug_manager_error_quark     (void);
GType  ianjuta_debug_manager_get_type        (void);


G_END_DECLS

#endif
