/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-comment.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-comment
 * @title: IAnjutaEditorComment
 * @short_description: Text editor comment interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-comment.h
 * 
 */

#include "ianjuta-editor-comment.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_comment_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-comment-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_comment_block:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Comment/Uncomment out selected block
 */
void
ianjuta_editor_comment_block (IAnjutaEditorComment *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_COMMENT(obj));
	IANJUTA_EDITOR_COMMENT_GET_IFACE (obj)->block (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_comment_block_default (IAnjutaEditorComment *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_comment_box:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Comment/Uncomment out selected block
 */
void
ianjuta_editor_comment_box (IAnjutaEditorComment *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_COMMENT(obj));
	IANJUTA_EDITOR_COMMENT_GET_IFACE (obj)->box (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_comment_box_default (IAnjutaEditorComment *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_comment_stream:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Comment/Uncomment out selected block
 */
void
ianjuta_editor_comment_stream (IAnjutaEditorComment *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_COMMENT(obj));
	IANJUTA_EDITOR_COMMENT_GET_IFACE (obj)->stream (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_comment_stream_default (IAnjutaEditorComment *obj, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_editor_comment_base_init (IAnjutaEditorCommentIface* klass)
{
	static gboolean initialized = FALSE;

	klass->block = ianjuta_editor_comment_block_default;
	klass->box = ianjuta_editor_comment_box_default;
	klass->stream = ianjuta_editor_comment_stream_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_comment_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorCommentIface),
			(GBaseInitFunc) ianjuta_editor_comment_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorComment", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
