/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-project-manager.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_PROJECT_MANAGER_H_
#define _IANJUTA_PROJECT_MANAGER_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_PROJECT_MANAGER (ianjuta_project_manager_get_type ())
#define IANJUTA_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_PROJECT_MANAGER, IAnjutaProjectManager))
#define IANJUTA_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_PROJECT_MANAGER))
#define IANJUTA_PROJECT_MANAGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_PROJECT_MANAGER, IAnjutaProjectManagerIface))

#define IANJUTA_TYPE_PROJECT_MANAGER_CAPABILITIES (ianjuta_project_manager_capabilities_get_type())
#define IANJUTA_TYPE_PROJECT_MANAGER_ELEMENT_TYPE (ianjuta_project_manager_element_type_get_type())
#define IANJUTA_TYPE_PROJECT_MANAGER_TARGET_TYPE (ianjuta_project_manager_target_type_get_type())

typedef enum {
	IANJUTA_PROJECT_MANAGER_CAN_ADD_NONE     = 0,
	IANJUTA_PROJECT_MANAGER_CAN_ADD_GROUP    = 1 << 0,
	IANJUTA_PROJECT_MANAGER_CAN_ADD_TARGET   = 1 << 1,
	IANJUTA_PROJECT_MANAGER_CAN_ADD_SOURCE   = 1 << 2
} IAnjutaProjectManagerCapabilities;

typedef enum {
	IANJUTA_PROJECT_MANAGER_UNKNOWN,
	IANJUTA_PROJECT_MANAGER_SOURCE,
	IANJUTA_PROJECT_MANAGER_TARGET,
	IANJUTA_PROJECT_MANAGER_GROUP
} IAnjutaProjectManagerElementType;

typedef enum {
	IANJUTA_PROJECT_MANAGER_TARGET_UNKNOWN,
	IANJUTA_PROJECT_MANAGER_TARGET_SHAREDLIB,
	IANJUTA_PROJECT_MANAGER_TARGET_STATICLIB,
	IANJUTA_PROJECT_MANAGER_TARGET_EXECUTABLE
} IAnjutaProjectManagerTargetType;

#define IANJUTA_PROJECT_MANAGER_ERROR ianjuta_project_manager_error_quark()

typedef struct _IAnjutaProjectManager IAnjutaProjectManager;
typedef struct _IAnjutaProjectManagerIface IAnjutaProjectManagerIface;

struct _IAnjutaProjectManagerIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*element_added) (IAnjutaProjectManager *obj, const gchar *element_uri);
	/* Signal */
	void (*element_removed) (IAnjutaProjectManager *obj, const gchar *element_uri);
	/* Signal */
	void (*element_selected) (IAnjutaProjectManager *obj, const gchar *element_uri);

	gchar* (*add_group) (IAnjutaProjectManager *obj, const gchar *group_name_to_add,  const gchar *default_location_uri, GError **err);
	gchar* (*add_source) (IAnjutaProjectManager *obj, const gchar *source_uri_to_add,  const gchar *default_location_uri, GError **err);
	GList* (*add_sources) (IAnjutaProjectManager *obj, GList* source_uri_to_add,  const gchar *default_location_uri, GError **err);
	gchar* (*add_target) (IAnjutaProjectManager *obj, const gchar *target_name_to_add,  const gchar *default_location_uri, GError **err);
	IAnjutaProjectManagerCapabilities (*get_capabilities) (IAnjutaProjectManager *obj, GError **err);
	GList* (*get_children) (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err);
	IAnjutaProjectManagerElementType (*get_element_type) (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err);
	GList* (*get_elements) (IAnjutaProjectManager *obj, IAnjutaProjectManagerElementType element_type, GError **err);
	gchar* (*get_parent) (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err);
	gchar* (*get_selected) (IAnjutaProjectManager *obj, GError **err);
	IAnjutaProjectManagerTargetType (*get_target_type) (IAnjutaProjectManager *obj, const gchar *target_uri, GError **err);
	GList* (*get_targets) (IAnjutaProjectManager *obj, IAnjutaProjectManagerTargetType target_type, GError **err);
	gboolean (*is_open) (IAnjutaProjectManager *obj, GError **err);

};
GType ianjuta_project_manager_capabilities_get_type (void);
GType ianjuta_project_manager_element_type_get_type (void);
GType ianjuta_project_manager_target_type_get_type (void);

GQuark ianjuta_project_manager_error_quark     (void);
GType  ianjuta_project_manager_get_type        (void);

gchar* ianjuta_project_manager_add_group (IAnjutaProjectManager *obj, const gchar *group_name_to_add,  const gchar *default_location_uri, GError **err);

gchar* ianjuta_project_manager_add_source (IAnjutaProjectManager *obj, const gchar *source_uri_to_add,  const gchar *default_location_uri, GError **err);

GList* ianjuta_project_manager_add_sources (IAnjutaProjectManager *obj, GList* source_uri_to_add,  const gchar *default_location_uri, GError **err);

gchar* ianjuta_project_manager_add_target (IAnjutaProjectManager *obj, const gchar *target_name_to_add,  const gchar *default_location_uri, GError **err);

IAnjutaProjectManagerCapabilities ianjuta_project_manager_get_capabilities (IAnjutaProjectManager *obj, GError **err);

GList* ianjuta_project_manager_get_children (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err);

IAnjutaProjectManagerElementType ianjuta_project_manager_get_element_type (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err);

GList* ianjuta_project_manager_get_elements (IAnjutaProjectManager *obj, IAnjutaProjectManagerElementType element_type, GError **err);

gchar* ianjuta_project_manager_get_parent (IAnjutaProjectManager *obj, const gchar *element_uri, GError **err);

gchar* ianjuta_project_manager_get_selected (IAnjutaProjectManager *obj, GError **err);

IAnjutaProjectManagerTargetType ianjuta_project_manager_get_target_type (IAnjutaProjectManager *obj, const gchar *target_uri, GError **err);

GList* ianjuta_project_manager_get_targets (IAnjutaProjectManager *obj, IAnjutaProjectManagerTargetType target_type, GError **err);

gboolean ianjuta_project_manager_is_open (IAnjutaProjectManager *obj, GError **err);


G_END_DECLS

#endif
