/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-print.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-print
 * @title: IAnjutaPrint
 * @short_description: Print interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-print.h
 * 
 */

#include "ianjuta-print.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_print_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-print-quark");
	}
	
	return quark;
}

/**
* ianjuta_print_print:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Print the plugin (the file in case of the editor). In most cases this will show
* a print dialog
*/
void
ianjuta_print_print (IAnjutaPrint *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_PRINT(obj));
	IANJUTA_PRINT_GET_IFACE (obj)->print (obj, err);
}

/* Default implementation */
static void
ianjuta_print_print_default (IAnjutaPrint *obj, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_print_print:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Show print preview dialog
*/
void
ianjuta_print_print_preview (IAnjutaPrint *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_PRINT(obj));
	IANJUTA_PRINT_GET_IFACE (obj)->print_preview (obj, err);
}

/* Default implementation */
static void
ianjuta_print_print_preview_default (IAnjutaPrint *obj, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_print_base_init (IAnjutaPrintIface* klass)
{
	static gboolean initialized = FALSE;

	klass->print = ianjuta_print_print_default;
	klass->print_preview = ianjuta_print_print_preview_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_print_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaPrintIface),
			(GBaseInitFunc) ianjuta_print_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaPrint", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
