/* rygel-external-plugin.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-external-plugin.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gio/gio.h>


#define RYGEL_EXTERNAL_TYPE_PLUGIN (rygel_external_plugin_get_type ())
#define RYGEL_EXTERNAL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN, RygelExternalPlugin))
#define RYGEL_EXTERNAL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN, RygelExternalPluginClass))
#define RYGEL_EXTERNAL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN))
#define RYGEL_EXTERNAL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN))
#define RYGEL_EXTERNAL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN, RygelExternalPluginClass))

typedef struct _RygelExternalPlugin RygelExternalPlugin;
typedef struct _RygelExternalPluginClass RygelExternalPluginClass;
typedef struct _RygelExternalPluginPrivate RygelExternalPluginPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_EXTERNAL_TYPE_CONTAINER (rygel_external_container_get_type ())
#define RYGEL_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer))
#define RYGEL_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))
#define RYGEL_EXTERNAL_IS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_IS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))

typedef struct _RygelExternalContainer RygelExternalContainer;
typedef struct _RygelExternalContainerClass RygelExternalContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelExternalPlugin {
	RygelMediaServerPlugin parent_instance;
	RygelExternalPluginPrivate * priv;
	gchar* service_name;
	gchar* root_object;
	guint child_count;
	gboolean searchable;
};

struct _RygelExternalPluginClass {
	RygelMediaServerPluginClass parent_class;
};


static gpointer rygel_external_plugin_parent_class = NULL;

GType rygel_external_plugin_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_EXTERNAL_PLUGIN_DUMMY_PROPERTY
};
RygelExternalPlugin* rygel_external_plugin_new (const gchar* service_name, const gchar* title, guint child_count, gboolean searchable, const gchar* root_object, RygelIconInfo* icon);
RygelExternalPlugin* rygel_external_plugin_construct (GType object_type, const gchar* service_name, const gchar* title, guint child_count, gboolean searchable, const gchar* root_object, RygelIconInfo* icon);
static RygelMediaContainer* rygel_external_plugin_real_get_root_container (RygelMediaServerPlugin* base, GUPnPContext* context);
GType rygel_external_container_get_type (void) G_GNUC_CONST;
RygelExternalContainer* rygel_external_container_new (const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, const gchar* host_ip, RygelExternalContainer* parent, GError** error);
RygelExternalContainer* rygel_external_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, const gchar* host_ip, RygelExternalContainer* parent, GError** error);
static void rygel_external_plugin_finalize (GObject* obj);


RygelExternalPlugin* rygel_external_plugin_construct (GType object_type, const gchar* service_name, const gchar* title, guint child_count, gboolean searchable, const gchar* root_object, RygelIconInfo* icon) {
	RygelExternalPlugin * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (service_name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (root_object != NULL, NULL);
	_tmp0_ = g_strconcat ("Rygel External ", title, NULL);
	self = (RygelExternalPlugin*) rygel_media_server_plugin_construct (object_type, service_name, title, _tmp0_);
	_g_free0 (_tmp0_);
	_tmp1_ = g_strdup (service_name);
	_tmp2_ = _tmp1_;
	_g_free0 (self->service_name);
	self->service_name = _tmp2_;
	self->child_count = child_count;
	self->searchable = searchable;
	_tmp3_ = g_strdup (root_object);
	_tmp4_ = _tmp3_;
	_g_free0 (self->root_object);
	self->root_object = _tmp4_;
	if (icon != NULL) {
		rygel_plugin_add_icon ((RygelPlugin*) self, icon);
	}
	return self;
}


RygelExternalPlugin* rygel_external_plugin_new (const gchar* service_name, const gchar* title, guint child_count, gboolean searchable, const gchar* root_object, RygelIconInfo* icon) {
	return rygel_external_plugin_construct (RYGEL_EXTERNAL_TYPE_PLUGIN, service_name, title, child_count, searchable, root_object, icon);
}


static RygelMediaContainer* rygel_external_plugin_real_get_root_container (RygelMediaServerPlugin* base, GUPnPContext* context) {
	RygelExternalPlugin * self;
	RygelMediaContainer* result = NULL;
	RygelExternalContainer* root_container;
	const gchar* _tmp0_ = NULL;
	RygelExternalContainer* _tmp1_ = NULL;
	RygelExternalContainer* _tmp2_;
	RygelExternalContainer* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (RygelExternalPlugin*) base;
	g_return_val_if_fail (context != NULL, NULL);
	root_container = NULL;
	_tmp0_ = gssdp_client_get_host_ip ((GSSDPClient*) context);
	_tmp1_ = rygel_external_container_new ("0", ((RygelPlugin*) self)->title, self->child_count, self->searchable, self->service_name, self->root_object, _tmp0_, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch4_g_io_error;
		}
		_g_object_unref0 (root_container);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp2_;
	_g_object_unref0 (root_container);
	root_container = _tmp3_;
	goto __finally4;
	__catch4_g_io_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("rygel-external-plugin.vala:67: Failed to connect to session bus: %s", err->message);
		_g_error_free0 (err);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (root_container);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = (RygelMediaContainer*) root_container;
	return result;
}


static void rygel_external_plugin_class_init (RygelExternalPluginClass * klass) {
	rygel_external_plugin_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_SERVER_PLUGIN_CLASS (klass)->get_root_container = rygel_external_plugin_real_get_root_container;
	G_OBJECT_CLASS (klass)->finalize = rygel_external_plugin_finalize;
}


static void rygel_external_plugin_instance_init (RygelExternalPlugin * self) {
}


static void rygel_external_plugin_finalize (GObject* obj) {
	RygelExternalPlugin * self;
	self = RYGEL_EXTERNAL_PLUGIN (obj);
	_g_free0 (self->service_name);
	_g_free0 (self->root_object);
	G_OBJECT_CLASS (rygel_external_plugin_parent_class)->finalize (obj);
}


GType rygel_external_plugin_get_type (void) {
	static volatile gsize rygel_external_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalPlugin), 0, (GInstanceInitFunc) rygel_external_plugin_instance_init, NULL };
		GType rygel_external_plugin_type_id;
		rygel_external_plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_SERVER_PLUGIN, "RygelExternalPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_external_plugin_type_id__volatile, rygel_external_plugin_type_id);
	}
	return rygel_external_plugin_type_id__volatile;
}



