/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.OutStream;
import rfb.AuthFailureException;
import rfb.CMsgHandler;
import rfb.CMsgReader;
import rfb.CMsgReaderV3;
import rfb.CMsgWriter;
import rfb.CMsgWriterV3;
import rfb.CSecurity;
import rfb.ConnFailedException;
import rfb.Exception;
import rfb.LogWriter;
import rfb.SecTypes;

public abstract class CConnection
extends CMsgHandler {
    public static final int RFBSTATE_UNINITIALISED = 0;
    public static final int RFBSTATE_PROTOCOL_VERSION = 1;
    public static final int RFBSTATE_SECURITY_TYPES = 2;
    public static final int RFBSTATE_SECURITY = 3;
    public static final int RFBSTATE_INITIALISATION = 4;
    public static final int RFBSTATE_NORMAL = 5;
    public static final int RFBSTATE_INVALID = 6;
    InStream is;
    OutStream os;
    CMsgReader reader_;
    CMsgWriter writer_;
    boolean shared;
    protected CSecurity security;
    public static final int maxSecTypes = 3;
    public static final int maxAuthTypes = 2;
    int nSecTypes;
    int[] secTypes = new int[3];
    int nAuthTypes;
    int[] authTypes = new int[2];
    int state_ = 0;
    String serverName;
    boolean useProtocol3_3;
    static LogWriter vlog = new LogWriter("CConnection");

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setStreams(InStream inStream, OutStream outStream) {
        this.is = inStream;
        this.os = outStream;
    }

    public void addSecType(int n) {
        if (this.nSecTypes == 3) {
            throw new Exception("too many security types");
        }
        this.secTypes[this.nSecTypes++] = n;
    }

    public void addAuthType(int n) {
        if (this.nAuthTypes == 2) {
            throw new Exception("too many authentication types");
        }
        this.authTypes[this.nAuthTypes++] = n;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    public void setProtocol3_3(boolean bl) {
        this.useProtocol3_3 = bl;
    }

    public void initialiseProtocol() {
        this.state_ = 1;
    }

    public void processMsg() {
        switch (this.state_) {
            case 1: {
                this.processVersionMsg();
                break;
            }
            case 2: {
                this.processSecurityTypesMsg();
                break;
            }
            case 3: {
                this.processSecurityMsg();
                break;
            }
            case 4: {
                this.processInitMsg();
                break;
            }
            case 5: {
                this.reader_.readMsg();
                break;
            }
            case 0: {
                throw new Exception("CConnection.processMsg: not initialised yet?");
            }
            default: {
                throw new Exception("CConnection.processMsg: invalid state");
            }
        }
    }

    public abstract CSecurity getCSecurity(int var1);

    public void authSuccess() {
    }

    public void serverInit() {
        this.state_ = 5;
        vlog.debug("initialisation done");
    }

    public CMsgReader reader() {
        return this.reader_;
    }

    public CMsgWriter writer() {
        return this.writer_;
    }

    public InStream getInStream() {
        return this.is;
    }

    public OutStream getOutStream() {
        return this.os;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int state() {
        return this.state_;
    }

    protected void setState(int n) {
        this.state_ = n;
    }

    void processVersionMsg() {
        vlog.debug("reading protocol version");
        if (!this.cp.readVersion(this.is)) {
            this.state_ = 6;
            throw new Exception("reading version failed: not an RFB server?");
        }
        vlog.info("Server supports RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
        if (!this.useProtocol3_3 && (this.cp.majorVersion > 3 || this.cp.majorVersion == 3 && this.cp.minorVersion >= 7)) {
            this.cp.majorVersion = 3;
            this.cp.minorVersion = 7;
        } else if (this.cp.majorVersion == 3 && this.cp.minorVersion >= 3) {
            this.cp.majorVersion = 3;
            this.cp.minorVersion = 3;
        } else {
            String string = "Server gave unsupported RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion;
            vlog.error(string);
            this.state_ = 6;
            throw new Exception(string);
        }
        this.cp.writeVersion(this.os);
        this.state_ = 2;
        vlog.info("Using RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
    }

    /*
     * Enabled aggressive block sorting
     */
    void processSecurityTypesMsg() {
        int n;
        block9: {
            int n2;
            int[] nArray;
            int n3;
            block11: {
                int n4;
                block10: {
                    block7: {
                        block8: {
                            vlog.debug("processing security types message");
                            n = 0;
                            if (this.cp.majorVersion != 3 || this.cp.minorVersion != 3) break block7;
                            n = this.is.readU32();
                            if (n != 0) break block8;
                            this.throwConnFailedException();
                            break block9;
                        }
                        if (n != 1 && n != 2) {
                            vlog.error("Unknown 3.3 security type " + n);
                            throw new Exception("Unknown 3.3 security type");
                        }
                        break block10;
                    }
                    n3 = this.is.readU8();
                    if (n3 == 0) {
                        this.throwConnFailedException();
                    }
                    nArray = new int[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        nArray[n2] = this.is.readU8();
                        vlog.debug("Server offers security type " + SecTypes.name(nArray[n2]) + "(" + nArray[n2] + ")");
                    }
                    break block11;
                }
                for (n4 = 0; n4 < this.nSecTypes && this.secTypes[n4] != n; ++n4) {
                }
                if (n4 != this.nSecTypes) break block9;
                n = 0;
                break block9;
            }
            for (n2 = 0; n2 < this.nSecTypes; ++n2) {
                for (int i = 0; i < n3; ++i) {
                    if (this.secTypes[n2] != nArray[i]) continue;
                    n = this.secTypes[n2];
                    this.os.writeU8(n);
                    this.os.flush();
                    vlog.debug("Choosing security type " + SecTypes.name(n) + "(" + n + ")");
                    break;
                }
                if (n != 0) break;
            }
        }
        if (n == 0) {
            this.state_ = 6;
            vlog.error("No matching security types");
            throw new Exception("No matching security types");
        }
        this.state_ = 3;
        this.security = this.getCSecurity(n);
        this.processSecurityMsg();
    }

    void processSecurityMsg() {
        vlog.debug("processing security message");
        switch (this.security.processMsg(this)) {
            case 0: {
                this.state_ = 6;
                vlog.error("Authentication failure");
                throw new AuthFailureException("Authentication failure");
            }
            case 1: {
                this.securityCompleted();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.processAuthTypesMsg();
                break;
            }
            default: {
                throw new Exception("CConnection.processMsg: invalid state");
            }
        }
    }

    private void processAuthTypesMsg() {
        int n;
        vlog.debug("processing authentication types message");
        int n2 = 0;
        int n3 = this.is.readU8();
        if (n3 == 0) {
            this.throwConnFailedException();
        }
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = this.is.readU8();
            vlog.debug("Server offers security type " + SecTypes.name(nArray[n]) + "(" + nArray[n] + ")");
        }
        for (n = 0; n < this.nAuthTypes; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (this.authTypes[n] != nArray[i]) continue;
                n2 = this.authTypes[n];
                this.os.writeU8(n2);
                this.os.flush();
                vlog.debug("Choosing security type " + SecTypes.name(n2) + "(" + n2 + ")");
                break;
            }
            if (n2 != 0) break;
        }
        if (n2 == 0) {
            this.state_ = 6;
            vlog.error("No matching authentication types");
            throw new Exception("No matching authentication types");
        }
        this.security = this.getCSecurity(n2);
        this.processSecurityMsg();
    }

    void processInitMsg() {
        vlog.debug("reading server initialisation");
        this.reader_.readServerInit();
    }

    void throwConnFailedException() {
        this.state_ = 6;
        String string = this.is.readString();
        throw new ConnFailedException(string);
    }

    void securityCompleted() {
        this.state_ = 4;
        this.reader_ = new CMsgReaderV3(this, this.is);
        this.writer_ = new CMsgWriterV3(this.cp, this.os);
        vlog.debug("Authentication success!");
        this.authSuccess();
        this.writer_.writeClientInit(this.shared);
    }
}

