/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.OutStream;
import rfb.CConnection;
import rfb.CSecurity;
import rfb.LogWriter;
import rfb.PasswdGetter;
import rfb.VncAuth;

public class CSecurityVncAuth
extends CSecurity {
    boolean hadChallenge;
    PasswdGetter pg;
    static LogWriter vlog = new LogWriter("VncAuth");

    public CSecurityVncAuth(PasswdGetter passwdGetter) {
        this.pg = passwdGetter;
    }

    public int processMsg(CConnection cConnection) {
        InStream inStream = cConnection.getInStream();
        OutStream outStream = cConnection.getOutStream();
        if (!this.hadChallenge) {
            byte[] byArray = new byte[16];
            inStream.readBytes(byArray, 0, 16);
            String string = this.pg.getPasswd();
            if (string == null || string.length() == 0) {
                vlog.error("Getting password failed");
                return 0;
            }
            VncAuth.encryptChallenge(byArray, string);
            outStream.writeBytes(byArray, 0, 16);
            outStream.flush();
            this.hadChallenge = true;
            return 2;
        }
        int n = inStream.readU32();
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                vlog.debug("auth failed");
                return 0;
            }
            case 2: {
                vlog.debug("auth failed - too many tries");
                return 0;
            }
        }
        vlog.error("unknown auth result");
        return 0;
    }

    public String getDescription() {
        return "Password Authentication Without Encryption";
    }
}

