/* GStreamer
 * Copyright (C) <2001> Steve Baker <stevebaker_org@yahoo.co.uk>
 * Copyright (C) 2002, 2003 Andy Wingo <wingo at pobox dot com>
 *
 * gstfloat2_2_int.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __GST_FLOAT2_2_INT_H__
#define __GST_FLOAT2_2_INT_H__


#include <gst/gst.h>

G_BEGIN_DECLS

#define GST_TYPE_FLOAT2_2_INT \
  (gst_float2_2_int_get_type())
#define GST_FLOAT2_2_INT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_FLOAT2_2_INT,GstFloat22Int))
#define GST_FLOAT2_2_INT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_FLOAT2_2_INT,GstFloat22Int))
#define GST_IS_FLOAT2_2_INT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_FLOAT2_2_INT))
#define GST_IS_FLOAT2_2_INT_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_FLOAT2_2_INT))

#define GST_FLOAT2_2_INT_CHANNEL(list)   ((GstFloat22IntInputChannel*)(list->data))

typedef struct _GstFloat22Int GstFloat22Int;
typedef struct _GstFloat22IntClass GstFloat22IntClass;
typedef struct _GstFloat22IntInputChannel GstFloat22IntInputChannel;

struct _GstFloat22Int {
  GstElement element;

  GstPad *srcpad;
  GstPad *sinkpad;
  
  guint rate;
  guint channels;
  gboolean interleaved;
};

struct _GstFloat22IntClass {
  GstElementClass parent_class;
};

GType gst_float2_2_int_get_type(void);
gboolean gst_float2_2_int_factory_init (GstPlugin *plugin);

G_END_DECLS

#endif /* __GST_FLOAT2_2_INT_H__ */
