/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __ID3TYPES_H__
#define __ID3TYPES_H__

#include <glib.h>
#include <gst/gst.h>

G_BEGIN_DECLS

#define GST_TYPE_ID3TYPES \
  (gst_id3types_get_type ())
#define GST_ID3TYPES(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GST_TYPE_ID3TYPES, GstID3Types))
#define GST_ID3TYPES_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), GST_TYPE_ID3TYPES, GstID3Types))
#define GST_IS_ID3TYPES(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GST_TYPE_ID3TYPES))
#define GST_IS_ID3TYPES_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), GST_TYPE_ID3TYPES))

typedef struct _GstID3Types GstID3Types;
typedef struct _GstID3TypesClass GstID3TypesClass;

struct _GstID3Types {
  GstElement element;

  GstPad *sinkpad, *srcpad;

  GstCaps *metadata;
  guint id3_tag_size;
  gboolean pass_through;
};

struct _GstID3TypesClass {
  GstElementClass parent_class;
};

GType gst_id3types_get_type (void);

G_END_DECLS

#endif /* __ID3TYPES_H__ */
