from main import USERHOME, HOME, NAME, PURGE_KEY
from factory.DisplayFactory import DisplayFactory
from display.Window import Window
from config.ConfigManager import ConfigManager
from utils import singleton
from utils import dialog
from utils import vfs
from config import settings
import admin

from main import _

import os
import gtk


# This class starts, restarts and kills Displays
class Starter:

    def __init__(self):

        # the set of open displays as a hashtable "id -> display"
        self.__open_displays = {}

        self.__factory = singleton.get(DisplayFactory)
        self.__config = singleton.get(ConfigManager)

        self.__config.watch("profile", self.__on_change_profile)


    #
    # Reacts on observer messages from the display.
    #
    def __on_display_action(self, src, cmd, *args):

        if (cmd == src.OBS_CLOSE):
            id = args[0]
            admin.remove_display(id)
            del src

        elif (cmd == src.OBS_RESTART):
            id = args[0]
            admin.restart_display(id)
            del src

        #end if



    #
    # Reacts on changing the user profile.
    #
    def __on_change_profile(self, key, value):

        if (settings.profile == value): return
        
        # shut down displays
        for id, d in self.__open_displays.items():
            d.remove_display()
            del self.__open_displays[id]

        settings.profile = value
        # load displays
        self.start_displays()
        print "PROFILE CHANGE", value
        pass
        


    #
    # Reacts on changes in the list of displays.
    #
    def __on_watch(self, key, value):

        displays = admin.get_displays()

        # check whether displays have been added
        for id in displays.keys():
            if (not self.__open_displays.has_key(id)):
                self.__add_display(id, displays[id])
        #end for

        # check whether displays have been removed
        for id in self.__open_displays.keys():
            if (not displays.has_key(id)):
                self.__remove_display(id)
        #end for


    #
    # Adds the given display.
    #
    def __add_display(self, id, path):

        if (not self.__open_displays.has_key(id)):
            dsp = self.__create_display(id, path)
            self.__open_displays[id] = dsp

            if (dsp):
                print "[" + path + "]"
                self.__open_displays[id] = dsp
                dsp.add_observer(self.__on_display_action)
                win = Window(dsp)
                win.move(-2000, -2000)
                win.show()
                dsp.show()
        #end if



    #
    # Creates and returns a new display from the given data, or None in case
    # of an error.
    #
    def __create_display(self, id, path):

        try:
            if (not vfs.exists(path)): raise IOError("File does not exist.")
            fd = vfs.open(path, "r")
        except:
            import traceback; traceback.print_exc()
            dialog.warning(_("Could not open display file '%(path)s'")
                           % vars(),
                           _("The display file could not be opened because "
                             "the file was not readable."))
            admin.remove_display(id)

            return None

        data = vfs.read_all(fd)
        fd.close()

        dir = os.path.dirname(path)

        vfs.chdir(dir)
        display = self.__factory.create_display(id, data)

        if (not display):
            dialog.warning(_("Invalid display file '%(path)s'") % vars(),
                           _("The display file contains invalid data and "
                             "could not be loaded."))
            admin.remove_display(id)

        return display



    #
    # Removes the given display.
    #
    def __remove_display(self, id):

        if (self.__open_displays.has_key(id)):
            print "closing", id
            if (self.__open_displays[id]):
                self.__open_displays[id].remove_display()
            del self.__open_displays[id]
            
            import gc
            print "collected garbage:", gc.collect(),
            print "    uncollectable:", len(gc.garbage)

        gtk.timeout_add(500, self.__purge_config)



    #
    # Purges unused config entries.
    #
    # TODO: implement it in a more efficient way
    #
    def __purge_config(self):

        for dir in self.__config.list("profiles", settings.profile):
            if (not dir[0].isdigit()): continue

            to_remove = 1
            for id in self.__open_displays.keys():
                if (dir.startswith(id)):
                    to_remove = 0
                    break
            #end for

            if (to_remove):
                # get paths to purge
                purge = self.__config.get("profiles", settings.profile,
                                          dir, PURGE_KEY).split(",")
                for p in purge:
                    if (not p): continue

                    # relative paths are relative to USERHOME
                    p = os.path.normpath(os.path.join(USERHOME, p))
                    
                    # make sure that only paths below USERHOME can be purged
                    if (p.startswith(USERHOME) and os.path.exists(p)):
                        print "purging path", p
                        os.system("rm -rf " + p)
                #end for
                
                print "purging", dir
                self.__config.clear("profiles", settings.profile, dir)
        #end for



    #
    # Starts up all displays.
    #
    def start_displays(self):

        # watches main/displays in the configuration base and calls on_watch if
        # something's changed
        self.__config.watch("profiles", settings.profile, "main", "displays",
                            self.__on_watch)

        displays = self.__config.get("profiles", settings.profile,
                                     "main", "displays")
        self.__on_watch(None, None)
