from DisplayTarget import DisplayTarget
from TargetCanvas import TargetCanvas
from utils.datatypes import *

import gtk


#
# Class for plotting graphs.
#
class TargetPlotter(TargetCanvas):

    def __init__(self, parent, display):

        # history of plot values
        self.__history = []
        
        # maximum size of visible values
        self.__size = 50


        self.__bgcolor = ""
        self.__fgcolor = "navy"


        TargetCanvas.__init__(self, parent, display)
        self._set_property_type("value", TYPE_FLOAT)
        self._set_property_type("bg-color", TYPE_STRING)
        self._set_property_type("color", TYPE_STRING)



    #
    # Plots the values from the history.
    #
    def __plot(self):

        bg, fg = self.__bgcolor, self.__fgcolor
        cmd = ""
        if (bg):
            cmd += "color %(bg)s, rectangle -1.0 1.0 1.0 -1.0 1," % vars()
        else:
            cmd += "clear,"
        cmd += "color %(fg)s, " % vars()
        
        x = -1.0
        delta_x = 2.0 / (self.__size - 1)

        max_value = max(1.0, max(self.__history))
        scale = 1.0 / max_value
        
        prev_x, prev_y = x, self.__history[0]
        prev_y *= scale
        prev_y = (prev_y * 2) - 1.0
        for y in self.__history[1:]:
            y *= scale
            y = (y * 2) - 1.0
            cmd += "line %(prev_x)f %(prev_y)f %(x)f %(y)f," % vars()
            prev_x, prev_y = x, y
            x += delta_x
        #end for

        TargetCanvas.set_config(self, "graphics", cmd)
        


    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "value"):
            self.__history.append(value / 100.0)
            self.__plot()
            if (len(self.__history) > 50): self.__history.pop(0)

        elif (key == "bg-color"): self.__bgcolor = value
        elif (key == "color"): self.__fgcolor = value

        else:
            DisplayTarget.set_config(self, key, value)
