/*
 *  Copyright (C) 2003 Marco Pesenti Gritti
 *  Copyright (C) 2003 Christian Persch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: ephy-cookie-manager.h,v 1.3 2003/11/26 13:26:38 chpe Exp $
 */

#ifndef EPHY_COOKIE_MANAGER_H
#define EPHY_COOKIE_MANAGER_H

#include <glib-object.h>
#include <glib.h>

G_BEGIN_DECLS

#define EPHY_TYPE_COOKIE_MANAGER		(ephy_cookie_manager_get_type ())
#define EPHY_COOKIE_MANAGER(o)			(G_TYPE_CHECK_INSTANCE_CAST ((o), EPHY_TYPE_COOKIE_MANAGER, EphyCookieManager))
#define EPHY_COOKIE_MANAGER_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST((k), EPHY_TYPE_COOKIE_MANAGER, EphyCookieManagerClass))
#define EPHY_IS_COOKIE_MANAGER(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), EPHY_TYPE_COOKIE_MANAGER))
#define EPHY_IS_COOKIE_MANAGER_CLASS(k)		(G_TYPE_CHECK_CLASS_TYPE ((k), EPHY_TYPE_COOKIE_MANAGER))
#define EPHY_COOKIE_MANAGER_GET_CLASS(inst)	(G_TYPE_INSTANCE_GET_INTERFACE ((inst), EPHY_TYPE_COOKIE_MANAGER, EphyCookieManagerIFace))

#define EPHY_TYPE_COOKIE			(ephy_cookie_get_type ())

typedef struct EphyCookieManager	EphyCookieManager;
typedef struct EphyCookieManagerIFace	EphyCookieManagerIFace;

typedef enum
{
	EPHY_COOKIE_P3P_STATE_UNKNOWN,
	EPHY_COOKIE_P3P_STATE_ACCEPTED,
	EPHY_COOKIE_P3P_STATE_DOWNGRADED,
	EPHY_COOKIE_P3P_STATE_FLAGGED,
	EPHY_COOKIE_P3P_STATE_REJECTED
} EphyCookieP3PState;

typedef enum
{
	EPHY_COOKIE_P3P_POLICY_UNKNOWN,
	EPHY_COOKIE_P3P_POLICY_NONE,
	EPHY_COOKIE_P3P_POLICY_NO_CONSENT,
	EPHY_COOKIE_P3P_POLICY_IMPLICIT_CONSENT,
	EPHY_COOKIE_P3P_POLICY_EXPLICIT_CONSENT,
	EPHY_COOKIE_P3P_POLICY_NO_II,
} EphyCookieP3PPolicy;

typedef struct
{
	char *name;
	char *value;
	char *domain;
	char *path;
	gulong expires;
	glong real_expires;
	guint is_secure : 1;
	guint is_session : 1;
	guint p3p_state : 3;
	guint p3p_policy : 3;
} EphyCookie;

struct EphyCookieManagerIFace
{
	GTypeInterface base_iface;

	/* Signals */
	void	(* added)	(EphyCookieManager *manager,
				 EphyCookie *cookie);
	void	(* changed)	(EphyCookieManager *manager,
				 EphyCookie *cookie);
	void	(* deleted)	(EphyCookieManager *manager,
				 EphyCookie *cookie);
	void	(* rejected)	(EphyCookieManager *manager,
				 const char *url);
	void	(* cleared)	(EphyCookieManager *manager);

	/* Methods */
	GList *	(* list)	(EphyCookieManager *manager);
	void	(* remove)	(EphyCookieManager *manager,
				 const EphyCookie *cookie);
	void	(* clear)	(EphyCookieManager *manager);
};

/* EphyCookie */

GType		ephy_cookie_get_type	(void);

EphyCookie     *ephy_cookie_new		(void);

EphyCookie     *ephy_cookie_copy	(const EphyCookie *cookie);

void		ephy_cookie_free	(EphyCookie *cookie);

/* EphyCookieManager */

GType 		ephy_cookie_manager_get_type		(void);

GList *		ephy_cookie_manager_list_cookies	(EphyCookieManager *manager);

void		ephy_cookie_manager_remove_cookie	(EphyCookieManager *manager,
							 const EphyCookie *cookie);

void		ephy_cookie_manager_clear		(EphyCookieManager *manager);

G_END_DECLS

#endif
