/************************************************************************************/
/* Copyright (C) 2003 Benoît Dejean <bnet@ifrance.com>				    */
/* 										    */
/* This program is free software; you can redistribute it and/or modify		    */
/* it under the terms of the GNU General Public License as published by		    */
/* the Free Software Foundation; either version 2 of the License, or		    */
/* (at your option) any later version.						    */
/* 										    */
/* This program is distributed in the hope that it will be useful,		    */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		    */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    */
/* GNU General Public License for more details.					    */
/* 										    */
/* You should have received a copy of the GNU General Public License		    */
/* along with this program; if not, write to the Free Software			    */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	    */
/* 										    */
/* http:www.gnu.org/licenses/gpl.html						    */
/************************************************************************************/

/* Benoît Dejean bnet at ifrance dot com */

%module glibtop	
%{
#include <glibtop.h>

  enum netload_if_flags
    {
      GLIBTOP_IF_FLAGS_UP = 1,
      GLIBTOP_IF_FLAGS_BROADCAST,
      GLIBTOP_IF_FLAGS_DEBUG,
      GLIBTOP_IF_FLAGS_LOOPBACK,
      GLIBTOP_IF_FLAGS_POINTOPOINT,
      GLIBTOP_IF_FLAGS_RUNNING,
      GLIBTOP_IF_FLAGS_NOARP,
      GLIBTOP_IF_FLAGS_PROMISC,
      GLIBTOP_IF_FLAGS_ALLMULTI,
      GLIBTOP_IF_FLAGS_OACTIVE,
      GLIBTOP_IF_FLAGS_SIMPLEX,
      GLIBTOP_IF_FLAGS_LINK0,
      GLIBTOP_IF_FLAGS_LINK1,
      GLIBTOP_IF_FLAGS_LINK2,
      GLIBTOP_IF_FLAGS_ALTPHYS,
      GLIBTOP_IF_FLAGS_MULTICAST
    };

  enum ppp_state
    {
      GLIBTOP_PPP_STATE_UNKNOWN = 0,
      GLIBTOP_PPP_STATE_HANGUP,
      GLIBTOP_PPP_STATE_ONLINE
    };

%}

%init
%{
  glibtop_init();	
%}


extern PyObject* get_cpu();


extern PyObject* get_mem();


extern PyObject* get_swap();


extern PyObject* get_uptime();


extern PyObject* get_loadavg();


extern PyObject* get_proclist(PyObject* which, PyObject *arg);

#define GLIBTOP_KERN_PROC_ALL           0
#define GLIBTOP_KERN_PROC_PID           1
#define GLIBTOP_KERN_PROC_PGRP          2
#define GLIBTOP_KERN_PROC_SESSION       3
#define GLIBTOP_KERN_PROC_TTY           4
#define GLIBTOP_KERN_PROC_UID           5
#define GLIBTOP_KERN_PROC_RUID          6
      
#define GLIBTOP_KERN_PROC_MASK          15
      
#define GLIBTOP_EXCLUDE_IDLE            0x1000
#define GLIBTOP_EXCLUDE_SYSTEM          0x2000
#define GLIBTOP_EXCLUDE_NOTTY           0x4000


extern PyObject* get_proc_state(PyObject *pid);

#define GLIBTOP_PROCESS_RUNNING                 1
#define GLIBTOP_PROCESS_INTERRUPTIBLE           2
#define GLIBTOP_PROCESS_UNINTERRUPTIBLE         4
#define GLIBTOP_PROCESS_ZOMBIE                  8
#define GLIBTOP_PROCESS_STOPPED                 16
#define GLIBTOP_PROCESS_SWAPPING                32


extern PyObject* get_proc_uid(PyObject *pid);


extern PyObject* get_proc_mem(PyObject *pid);


extern PyObject* get_proc_time(PyObject *pid);


extern PyObject* get_proc_signal(PyObject* ppid);


extern PyObject* get_proc_kernel(PyObject* ppid);

#define GLIBTOP_KFLAGS_STARTING         1
#define GLIBTOP_KFLAGS_EXITING          2
#define GLIBTOP_KFLAGS_PTRACED          4
#define GLIBTOP_KFLAGS_TRACESYS         8
#define GLIBTOP_KFLAGS_FORKNOEXEC       16
#define GLIBTOP_KFLAGS_SUPERPRIV        32
#define GLIBTOP_KFLAGS_DUMPEDCORE       64
#define GLIBTOP_KFLAGS_SIGNALED         128


extern PyObject* get_proc_segment(PyObject* ppid);


extern PyObject* get_proc_args(PyObject* ppid);


extern PyObject* get_proc_map(PyObject* ppid);

#define GLIBTOP_MAP_ENTRY_START         1
#define GLIBTOP_MAP_ENTRY_END           2
#define GLIBTOP_MAP_ENTRY_OFFSET        3
#define GLIBTOP_MAP_ENTRY_PERM          4
#define GLIBTOP_MAP_ENTRY_INODE         5
#define GLIBTOP_MAP_ENTRY_DEVICE        6
#define GLIBTOP_MAP_ENTRY_FILENAME      7
#define GLIBTOP_MAP_PERM_READ           1
#define GLIBTOP_MAP_PERM_WRITE          2
#define GLIBTOP_MAP_PERM_EXECUTE        4
#define GLIBTOP_MAP_PERM_SHARED         8
#define GLIBTOP_MAP_PERM_PRIVATE        16


extern PyObject* get_netload(PyObject *interface);

enum netload_if_flags
  {
    GLIBTOP_IF_FLAGS_UP = 1,
    GLIBTOP_IF_FLAGS_BROADCAST,
    GLIBTOP_IF_FLAGS_DEBUG,
    GLIBTOP_IF_FLAGS_LOOPBACK,
    GLIBTOP_IF_FLAGS_POINTOPOINT,
    GLIBTOP_IF_FLAGS_RUNNING,
    GLIBTOP_IF_FLAGS_NOARP,
    GLIBTOP_IF_FLAGS_PROMISC,
    GLIBTOP_IF_FLAGS_ALLMULTI,
    GLIBTOP_IF_FLAGS_OACTIVE,
    GLIBTOP_IF_FLAGS_SIMPLEX,
    GLIBTOP_IF_FLAGS_LINK0,
    GLIBTOP_IF_FLAGS_LINK1,
    GLIBTOP_IF_FLAGS_LINK2,
    GLIBTOP_IF_FLAGS_ALTPHYS,
    GLIBTOP_IF_FLAGS_MULTICAST
  };


extern PyObject* get_ppp(PyObject *device);

enum ppp_state
  {
    GLIBTOP_PPP_STATE_UNKNOWN = 0,
    GLIBTOP_PPP_STATE_HANGUP,
    GLIBTOP_PPP_STATE_ONLINE
  };


extern PyObject *get_mountlist(PyObject *allfs);


extern PyObject *get_fsusage(PyObject *mount_dir);



