/* rygel-mpris-plugin-factory.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-mpris-plugin-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_MPRIS_TYPE_PLUGIN_FACTORY (rygel_mpris_plugin_factory_get_type ())
#define RYGEL_MPRIS_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, RygelMPRISPluginFactory))
#define RYGEL_MPRIS_PLUGIN_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, RygelMPRISPluginFactoryClass))
#define RYGEL_MPRIS_IS_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY))
#define RYGEL_MPRIS_IS_PLUGIN_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY))
#define RYGEL_MPRIS_PLUGIN_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, RygelMPRISPluginFactoryClass))

typedef struct _RygelMPRISPluginFactory RygelMPRISPluginFactory;
typedef struct _RygelMPRISPluginFactoryClass RygelMPRISPluginFactoryClass;
#define _rygel_mpris_plugin_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_mpris_plugin_factory_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMPRISPluginFactoryPrivate RygelMPRISPluginFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMprisPluginFactoryLoadPluginsData RygelMprisPluginFactoryLoadPluginsData;
typedef struct _RygelMprisPluginFactoryLoadActivatablePluginsData RygelMprisPluginFactoryLoadActivatablePluginsData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RYGEL_MPRIS_TYPE_PLUGIN (rygel_mpris_plugin_get_type ())
#define RYGEL_MPRIS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPlugin))
#define RYGEL_MPRIS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))
#define RYGEL_MPRIS_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))

typedef struct _RygelMPRISPlugin RygelMPRISPlugin;
typedef struct _RygelMPRISPluginClass RygelMPRISPluginClass;
typedef struct _RygelMprisPluginFactoryLoadPluginData RygelMprisPluginFactoryLoadPluginData;
typedef struct _RygelMPRISParamSpecPluginFactory RygelMPRISParamSpecPluginFactory;

struct _RygelMPRISPluginFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMPRISPluginFactoryPrivate * priv;
};

struct _RygelMPRISPluginFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMPRISPluginFactory *self);
};

struct _RygelMPRISPluginFactoryPrivate {
	FreeDesktopDBusObject* dbus_obj;
	DBusGConnection* connection;
	RygelPluginLoader* loader;
};

struct _RygelMprisPluginFactoryLoadPluginsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMPRISPluginFactory* self;
	char** services;
	gint _tmp0_;
	gint services_length1;
	gint _services_size_;
	char** _tmp1_;
	gboolean _tmp2_;
	RygelPlugin* _tmp3_;
	char** service_collection;
	int service_collection_length1;
	int service_it;
	char* service;
	GError * _inner_error_;
};

struct _RygelMprisPluginFactoryLoadActivatablePluginsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMPRISPluginFactory* self;
	char** services;
	gint _tmp0_;
	gint services_length1;
	gint _services_size_;
	char** _tmp1_;
	gboolean _tmp2_;
	RygelPlugin* _tmp3_;
	char** service_collection;
	int service_collection_length1;
	int service_it;
	char* service;
	GError * _inner_error_;
};

struct _RygelMprisPluginFactoryLoadPluginData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMPRISPluginFactory* self;
	char* service_name;
	FreeDesktopProperties* props;
	GHashTable* props_hash;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GError * err;
	char* title;
	char* _tmp2_;
	char** mime_types;
	char** _tmp3_;
	gint mime_types_length1;
	gint _mime_types_size_;
	char** _tmp4_;
	char** schemes;
	char** _tmp5_;
	gint schemes_length1;
	gint _schemes_size_;
	char** _tmp6_;
	RygelMPRISPlugin* plugin;
	GError * _inner_error_;
};

struct _RygelMPRISParamSpecPluginFactory {
	GParamSpec parent_instance;
};


extern RygelMPRISPluginFactory* plugin_factory;
RygelMPRISPluginFactory* plugin_factory = NULL;
static gpointer rygel_mpris_plugin_factory_parent_class = NULL;

gpointer rygel_mpris_plugin_factory_ref (gpointer instance);
void rygel_mpris_plugin_factory_unref (gpointer instance);
GParamSpec* rygel_mpris_param_spec_plugin_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_mpris_value_set_plugin_factory (GValue* value, gpointer v_object);
void rygel_mpris_value_take_plugin_factory (GValue* value, gpointer v_object);
gpointer rygel_mpris_value_get_plugin_factory (const GValue* value);
GType rygel_mpris_plugin_factory_get_type (void) G_GNUC_CONST;
void module_init (RygelPluginLoader* loader);
RygelMPRISPluginFactory* rygel_mpris_plugin_factory_new (RygelPluginLoader* loader, GError** error);
RygelMPRISPluginFactory* rygel_mpris_plugin_factory_construct (GType object_type, RygelPluginLoader* loader, GError** error);
#define RYGEL_MPRIS_PLUGIN_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, RygelMPRISPluginFactoryPrivate))
enum  {
	RYGEL_MPRIS_PLUGIN_FACTORY_DUMMY_PROPERTY
};
#define RYGEL_MPRIS_PLUGIN_FACTORY_DBUS_SERVICE "org.freedesktop.DBus"
#define RYGEL_MPRIS_PLUGIN_FACTORY_DBUS_OBJECT "/org/freedesktop/DBus"
#define RYGEL_MPRIS_PLUGIN_FACTORY_SERVICE_PREFIX "org.mpris.MediaPlayer2."
#define RYGEL_MPRIS_PLUGIN_FACTORY_MEDIA_PLAYER_PATH "/org/mpris/MediaPlayer2"
static void rygel_mpris_plugin_factory_load_plugins (RygelMPRISPluginFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_mpris_plugin_factory_load_plugins_finish (RygelMPRISPluginFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_mpris_plugin_factory_load_plugins_data_free (gpointer _data);
static void rygel_mpris_plugin_factory_load_plugins_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_mpris_plugin_factory_load_plugins_co (RygelMprisPluginFactoryLoadPluginsData* data);
static void rygel_mpris_plugin_factory_load_plugin (RygelMPRISPluginFactory* self, const char* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_mpris_plugin_factory_load_plugin_finish (RygelMPRISPluginFactory* self, GAsyncResult* _res_);
static void rygel_mpris_plugin_factory_load_activatable_plugins (RygelMPRISPluginFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_mpris_plugin_factory_load_activatable_plugins_finish (RygelMPRISPluginFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_mpris_plugin_factory_load_activatable_plugins_data_free (gpointer _data);
static void rygel_mpris_plugin_factory_load_activatable_plugins_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_mpris_plugin_factory_load_activatable_plugins_co (RygelMprisPluginFactoryLoadActivatablePluginsData* data);
static void rygel_mpris_plugin_factory_name_owner_changed (RygelMPRISPluginFactory* self, FreeDesktopDBusObject* dbus_obj, const char* name, const char* old_owner, const char* new_owner);
static void _rygel_mpris_plugin_factory_name_owner_changed_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* _sender, const char* name, const char* old_owner, const char* new_owner, gpointer self);
static void rygel_mpris_plugin_factory_load_plugin_data_free (gpointer _data);
static void rygel_mpris_plugin_factory_load_plugin_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_mpris_plugin_factory_load_plugin_co (RygelMprisPluginFactoryLoadPluginData* data);
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY_IFACE "org.mpris.MediaPlayer2"
static char** _vala_array_dup6 (char** self, int length);
static char** _vala_array_dup7 (char** self, int length);
RygelMPRISPlugin* rygel_mpris_plugin_new (const char* service_name, const char* title, char** mime_types, int mime_types_length1, char** schemes, int schemes_length1);
RygelMPRISPlugin* rygel_mpris_plugin_construct (GType object_type, const char* service_name, const char* title, char** mime_types, int mime_types_length1, char** schemes, int schemes_length1);
GType rygel_mpris_plugin_get_type (void) G_GNUC_CONST;
static void rygel_mpris_plugin_factory_finalize (RygelMPRISPluginFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 31 "rygel-mpris-plugin-factory.vala"
void module_init (RygelPluginLoader* loader) {
#line 212 "rygel-mpris-plugin-factory.c"
	GError * _inner_error_ = NULL;
#line 31 "rygel-mpris-plugin-factory.vala"
	g_return_if_fail (loader != NULL);
#line 216 "rygel-mpris-plugin-factory.c"
	{
		RygelMPRISPluginFactory* _tmp0_;
		RygelMPRISPluginFactory* _tmp1_;
#line 33 "rygel-mpris-plugin-factory.vala"
		_tmp0_ = rygel_mpris_plugin_factory_new (loader, &_inner_error_);
#line 222 "rygel-mpris-plugin-factory.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch6_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 33 "rygel-mpris-plugin-factory.vala"
		plugin_factory = (_tmp1_ = _tmp0_, _rygel_mpris_plugin_factory_unref0 (plugin_factory), _tmp1_);
#line 233 "rygel-mpris-plugin-factory.c"
	}
	goto __finally6;
	__catch6_dbus_gerror:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 35 "rygel-mpris-plugin-factory.vala"
			g_critical ("rygel-mpris-plugin-factory.vala:35: Failed to fetch list of MPRIS serv" \
"ices: %s\n", _error_->message);
#line 244 "rygel-mpris-plugin-factory.c"
			_g_error_free0 (_error_);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 51 "rygel-mpris-plugin-factory.vala"
RygelMPRISPluginFactory* rygel_mpris_plugin_factory_construct (GType object_type, RygelPluginLoader* loader, GError** error) {
#line 264 "rygel-mpris-plugin-factory.c"
	RygelMPRISPluginFactory* self;
	DBusGConnection* _tmp0_;
	DBusGConnection* _tmp1_;
	FreeDesktopDBusObject* _tmp2_;
	RygelPluginLoader* _tmp3_;
	GError * _inner_error_ = NULL;
#line 51 "rygel-mpris-plugin-factory.vala"
	g_return_val_if_fail (loader != NULL, NULL);
#line 273 "rygel-mpris-plugin-factory.c"
	self = (RygelMPRISPluginFactory*) g_type_create_instance (object_type);
#line 52 "rygel-mpris-plugin-factory.vala"
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
#line 277 "rygel-mpris-plugin-factory.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_rygel_mpris_plugin_factory_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 52 "rygel-mpris-plugin-factory.vala"
	self->priv->connection = (_tmp1_ = _tmp0_, _dbus_g_connection_unref0 (self->priv->connection), _tmp1_);
#line 54 "rygel-mpris-plugin-factory.vala"
	self->priv->dbus_obj = (_tmp2_ = free_desktop_dbus_object_dbus_proxy_new (self->priv->connection, RYGEL_MPRIS_PLUGIN_FACTORY_DBUS_SERVICE, RYGEL_MPRIS_PLUGIN_FACTORY_DBUS_OBJECT), _g_object_unref0 (self->priv->dbus_obj), _tmp2_);
#line 56 "rygel-mpris-plugin-factory.vala"
	self->priv->loader = (_tmp3_ = _g_object_ref0 (loader), _g_object_unref0 (self->priv->loader), _tmp3_);
#line 58 "rygel-mpris-plugin-factory.vala"
	rygel_mpris_plugin_factory_load_plugins (self, NULL, NULL);
#line 297 "rygel-mpris-plugin-factory.c"
	return self;
}


#line 51 "rygel-mpris-plugin-factory.vala"
RygelMPRISPluginFactory* rygel_mpris_plugin_factory_new (RygelPluginLoader* loader, GError** error) {
#line 51 "rygel-mpris-plugin-factory.vala"
	return rygel_mpris_plugin_factory_construct (RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, loader, error);
#line 306 "rygel-mpris-plugin-factory.c"
}


static void rygel_mpris_plugin_factory_load_plugins_data_free (gpointer _data) {
	RygelMprisPluginFactoryLoadPluginsData* data;
	data = _data;
	rygel_mpris_plugin_factory_unref (data->self);
	g_slice_free (RygelMprisPluginFactoryLoadPluginsData, data);
}


static void rygel_mpris_plugin_factory_load_plugins (RygelMPRISPluginFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMprisPluginFactoryLoadPluginsData* _data_;
	_data_ = g_slice_new0 (RygelMprisPluginFactoryLoadPluginsData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_mpris_plugin_factory_load_plugins);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mpris_plugin_factory_load_plugins_data_free);
	_data_->self = rygel_mpris_plugin_factory_ref (self);
	rygel_mpris_plugin_factory_load_plugins_co (_data_);
}


static void rygel_mpris_plugin_factory_load_plugins_finish (RygelMPRISPluginFactory* self, GAsyncResult* _res_, GError** error) {
	RygelMprisPluginFactoryLoadPluginsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_mpris_plugin_factory_load_plugins_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMprisPluginFactoryLoadPluginsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_mpris_plugin_factory_load_plugins_co (data);
}


static gboolean rygel_mpris_plugin_factory_load_plugins_co (RygelMprisPluginFactoryLoadPluginsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
	}
	_state_0:
	data->_state_ = 1;
	free_desktop_dbus_object_list_names (data->self->priv->dbus_obj, rygel_mpris_plugin_factory_load_plugins_ready, data);
	return FALSE;
	_state_1:
	data->services = (data->_tmp1_ = free_desktop_dbus_object_list_names_finish (data->self->priv->dbus_obj, data->_res_, &data->_tmp0_, &data->_inner_error_), data->services_length1 = data->_tmp0_, data->_services_size_ = data->services_length1, data->_tmp1_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		data->service_collection = data->services;
		data->service_collection_length1 = data->services_length1;
		for (data->service_it = 0; data->service_it < data->services_length1; data->service_it = data->service_it + 1) {
			data->service = g_strdup (data->service_collection[data->service_it]);
			{
#line 65 "rygel-mpris-plugin-factory.vala"
				if (g_str_has_prefix (data->service, RYGEL_MPRIS_PLUGIN_FACTORY_SERVICE_PREFIX)) {
#line 66 "rygel-mpris-plugin-factory.vala"
					data->_tmp2_ = (data->_tmp3_ = rygel_plugin_loader_get_plugin_by_name (data->self->priv->loader, data->service)) == NULL;
#line 393 "rygel-mpris-plugin-factory.c"
					_g_object_unref0 (data->_tmp3_);
				} else {
#line 65 "rygel-mpris-plugin-factory.vala"
					data->_tmp2_ = FALSE;
#line 398 "rygel-mpris-plugin-factory.c"
				}
#line 65 "rygel-mpris-plugin-factory.vala"
				if (data->_tmp2_) {
#line 402 "rygel-mpris-plugin-factory.c"
					data->_state_ = 2;
					rygel_mpris_plugin_factory_load_plugin (data->self, data->service, rygel_mpris_plugin_factory_load_plugins_ready, data);
					return FALSE;
					_state_2:
#line 67 "rygel-mpris-plugin-factory.vala"
					rygel_mpris_plugin_factory_load_plugin_finish (data->self, data->_res_);
#line 409 "rygel-mpris-plugin-factory.c"
				}
				_g_free0 (data->service);
			}
		}
	}
	data->_state_ = 3;
	rygel_mpris_plugin_factory_load_activatable_plugins (data->self, rygel_mpris_plugin_factory_load_plugins_ready, data);
	return FALSE;
	_state_3:
#line 71 "rygel-mpris-plugin-factory.vala"
	rygel_mpris_plugin_factory_load_activatable_plugins_finish (data->self, data->_res_, &data->_inner_error_);
#line 421 "rygel-mpris-plugin-factory.c"
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			data->services = (_vala_array_free (data->services, data->services_length1, (GDestroyNotify) g_free), NULL);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->services = (_vala_array_free (data->services, data->services_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->services = (_vala_array_free (data->services, data->services_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_mpris_plugin_factory_load_activatable_plugins_data_free (gpointer _data) {
	RygelMprisPluginFactoryLoadActivatablePluginsData* data;
	data = _data;
	rygel_mpris_plugin_factory_unref (data->self);
	g_slice_free (RygelMprisPluginFactoryLoadActivatablePluginsData, data);
}


static void rygel_mpris_plugin_factory_load_activatable_plugins (RygelMPRISPluginFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMprisPluginFactoryLoadActivatablePluginsData* _data_;
	_data_ = g_slice_new0 (RygelMprisPluginFactoryLoadActivatablePluginsData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_mpris_plugin_factory_load_activatable_plugins);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mpris_plugin_factory_load_activatable_plugins_data_free);
	_data_->self = rygel_mpris_plugin_factory_ref (self);
	rygel_mpris_plugin_factory_load_activatable_plugins_co (_data_);
}


static void rygel_mpris_plugin_factory_load_activatable_plugins_finish (RygelMPRISPluginFactory* self, GAsyncResult* _res_, GError** error) {
	RygelMprisPluginFactoryLoadActivatablePluginsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_mpris_plugin_factory_load_activatable_plugins_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMprisPluginFactoryLoadActivatablePluginsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_mpris_plugin_factory_load_activatable_plugins_co (data);
}


#line 87 "rygel-mpris-plugin-factory.vala"
static void _rygel_mpris_plugin_factory_name_owner_changed_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* _sender, const char* name, const char* old_owner, const char* new_owner, gpointer self) {
#line 493 "rygel-mpris-plugin-factory.c"
	rygel_mpris_plugin_factory_name_owner_changed (self, _sender, name, old_owner, new_owner);
}


static gboolean rygel_mpris_plugin_factory_load_activatable_plugins_co (RygelMprisPluginFactoryLoadActivatablePluginsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
	}
	_state_0:
	data->_state_ = 4;
	free_desktop_dbus_object_list_activatable_names (data->self->priv->dbus_obj, rygel_mpris_plugin_factory_load_activatable_plugins_ready, data);
	return FALSE;
	_state_4:
	data->services = (data->_tmp1_ = free_desktop_dbus_object_list_activatable_names_finish (data->self->priv->dbus_obj, data->_res_, &data->_tmp0_, &data->_inner_error_), data->services_length1 = data->_tmp0_, data->_services_size_ = data->services_length1, data->_tmp1_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		data->service_collection = data->services;
		data->service_collection_length1 = data->services_length1;
		for (data->service_it = 0; data->service_it < data->services_length1; data->service_it = data->service_it + 1) {
			data->service = g_strdup (data->service_collection[data->service_it]);
			{
#line 78 "rygel-mpris-plugin-factory.vala"
				if (g_str_has_prefix (data->service, RYGEL_MPRIS_PLUGIN_FACTORY_SERVICE_PREFIX)) {
#line 79 "rygel-mpris-plugin-factory.vala"
					data->_tmp2_ = (data->_tmp3_ = rygel_plugin_loader_get_plugin_by_name (data->self->priv->loader, data->service)) == NULL;
#line 544 "rygel-mpris-plugin-factory.c"
					_g_object_unref0 (data->_tmp3_);
				} else {
#line 78 "rygel-mpris-plugin-factory.vala"
					data->_tmp2_ = FALSE;
#line 549 "rygel-mpris-plugin-factory.c"
				}
#line 78 "rygel-mpris-plugin-factory.vala"
				if (data->_tmp2_) {
#line 553 "rygel-mpris-plugin-factory.c"
					data->_state_ = 5;
					rygel_mpris_plugin_factory_load_plugin (data->self, data->service, rygel_mpris_plugin_factory_load_activatable_plugins_ready, data);
					return FALSE;
					_state_5:
#line 80 "rygel-mpris-plugin-factory.vala"
					rygel_mpris_plugin_factory_load_plugin_finish (data->self, data->_res_);
#line 560 "rygel-mpris-plugin-factory.c"
				}
				_g_free0 (data->service);
			}
		}
	}
#line 84 "rygel-mpris-plugin-factory.vala"
	g_signal_connect (data->self->priv->dbus_obj, "name-owner-changed", (GCallback) _rygel_mpris_plugin_factory_name_owner_changed_free_desktop_dbus_object_name_owner_changed, data->self);
#line 568 "rygel-mpris-plugin-factory.c"
	data->services = (_vala_array_free (data->services, data->services_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 87 "rygel-mpris-plugin-factory.vala"
static void rygel_mpris_plugin_factory_name_owner_changed (RygelMPRISPluginFactory* self, FreeDesktopDBusObject* dbus_obj, const char* name, const char* old_owner, const char* new_owner) {
#line 584 "rygel-mpris-plugin-factory.c"
	RygelPlugin* plugin;
#line 87 "rygel-mpris-plugin-factory.vala"
	g_return_if_fail (self != NULL);
#line 87 "rygel-mpris-plugin-factory.vala"
	g_return_if_fail (dbus_obj != NULL);
#line 87 "rygel-mpris-plugin-factory.vala"
	g_return_if_fail (name != NULL);
#line 87 "rygel-mpris-plugin-factory.vala"
	g_return_if_fail (old_owner != NULL);
#line 87 "rygel-mpris-plugin-factory.vala"
	g_return_if_fail (new_owner != NULL);
#line 91 "rygel-mpris-plugin-factory.vala"
	plugin = rygel_plugin_loader_get_plugin_by_name (self->priv->loader, name);
#line 93 "rygel-mpris-plugin-factory.vala"
	if (plugin != NULL) {
#line 600 "rygel-mpris-plugin-factory.c"
		gboolean _tmp0_ = FALSE;
#line 94 "rygel-mpris-plugin-factory.vala"
		if (_vala_strcmp0 (old_owner, "") != 0) {
#line 94 "rygel-mpris-plugin-factory.vala"
			_tmp0_ = _vala_strcmp0 (new_owner, "") == 0;
#line 606 "rygel-mpris-plugin-factory.c"
		} else {
#line 94 "rygel-mpris-plugin-factory.vala"
			_tmp0_ = FALSE;
#line 610 "rygel-mpris-plugin-factory.c"
		}
#line 94 "rygel-mpris-plugin-factory.vala"
		if (_tmp0_) {
#line 95 "rygel-mpris-plugin-factory.vala"
			g_debug ("rygel-mpris-plugin-factory.vala:95: Service '%s' going down, marking i" \
"t as unavailable", name);
#line 97 "rygel-mpris-plugin-factory.vala"
			rygel_plugin_set_available (plugin, FALSE);
#line 618 "rygel-mpris-plugin-factory.c"
		} else {
			gboolean _tmp1_ = FALSE;
#line 98 "rygel-mpris-plugin-factory.vala"
			if (_vala_strcmp0 (old_owner, "") == 0) {
#line 98 "rygel-mpris-plugin-factory.vala"
				_tmp1_ = _vala_strcmp0 (new_owner, "") != 0;
#line 625 "rygel-mpris-plugin-factory.c"
			} else {
#line 98 "rygel-mpris-plugin-factory.vala"
				_tmp1_ = FALSE;
#line 629 "rygel-mpris-plugin-factory.c"
			}
#line 98 "rygel-mpris-plugin-factory.vala"
			if (_tmp1_) {
#line 99 "rygel-mpris-plugin-factory.vala"
				g_debug ("rygel-mpris-plugin-factory.vala:99: Service '%s' up again, marking it " \
"as available", name);
#line 100 "rygel-mpris-plugin-factory.vala"
				rygel_plugin_set_available (plugin, TRUE);
#line 637 "rygel-mpris-plugin-factory.c"
			}
		}
	} else {
#line 102 "rygel-mpris-plugin-factory.vala"
		if (g_str_has_prefix (name, RYGEL_MPRIS_PLUGIN_FACTORY_SERVICE_PREFIX)) {
#line 104 "rygel-mpris-plugin-factory.vala"
			rygel_mpris_plugin_factory_load_plugin (self, name, NULL, NULL);
#line 645 "rygel-mpris-plugin-factory.c"
		}
	}
	_g_object_unref0 (plugin);
}


static void rygel_mpris_plugin_factory_load_plugin_data_free (gpointer _data) {
	RygelMprisPluginFactoryLoadPluginData* data;
	data = _data;
	_g_free0 (data->service_name);
	rygel_mpris_plugin_factory_unref (data->self);
	g_slice_free (RygelMprisPluginFactoryLoadPluginData, data);
}


static void rygel_mpris_plugin_factory_load_plugin (RygelMPRISPluginFactory* self, const char* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMprisPluginFactoryLoadPluginData* _data_;
	_data_ = g_slice_new0 (RygelMprisPluginFactoryLoadPluginData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_mpris_plugin_factory_load_plugin);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mpris_plugin_factory_load_plugin_data_free);
	_data_->self = rygel_mpris_plugin_factory_ref (self);
	_data_->service_name = g_strdup (service_name);
	rygel_mpris_plugin_factory_load_plugin_co (_data_);
}


static void rygel_mpris_plugin_factory_load_plugin_finish (RygelMPRISPluginFactory* self, GAsyncResult* _res_) {
	RygelMprisPluginFactoryLoadPluginData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_mpris_plugin_factory_load_plugin_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMprisPluginFactoryLoadPluginData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_mpris_plugin_factory_load_plugin_co (data);
}


static char** _vala_array_dup6 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static char** _vala_array_dup7 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gboolean rygel_mpris_plugin_factory_load_plugin_co (RygelMprisPluginFactoryLoadPluginData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 6:
		goto _state_6;
	}
	_state_0:
	data->props = free_desktop_properties_dbus_proxy_new (data->self->priv->connection, data->service_name, RYGEL_MPRIS_PLUGIN_FACTORY_MEDIA_PLAYER_PATH);
	{
		data->_state_ = 6;
		free_desktop_properties_get_all (data->props, RYGEL_MPRIS_MEDIA_PLAYER_PROXY_IFACE, rygel_mpris_plugin_factory_load_plugin_ready, data);
		return FALSE;
		_state_6:
		data->_tmp0_ = free_desktop_properties_get_all_finish (data->props, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == DBUS_GERROR) {
				goto __catch7_dbus_gerror;
			}
			_g_hash_table_unref0 (data->props_hash);
			_g_object_unref0 (data->props);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
#line 116 "rygel-mpris-plugin-factory.vala"
		data->props_hash = (data->_tmp1_ = data->_tmp0_, _g_hash_table_unref0 (data->props_hash), data->_tmp1_);
#line 737 "rygel-mpris-plugin-factory.c"
	}
	goto __finally7;
	__catch7_dbus_gerror:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 118 "rygel-mpris-plugin-factory.vala"
			g_warning ("rygel-mpris-plugin-factory.vala:118: Failed to fetch properties of plu" \
"gin %s: %s.", data->service_name, data->err->message);
#line 747 "rygel-mpris-plugin-factory.c"
			_g_error_free0 (data->err);
			_g_hash_table_unref0 (data->props_hash);
			_g_object_unref0 (data->props);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->err);
		}
	}
	__finally7:
	if (data->_inner_error_ != NULL) {
		_g_hash_table_unref0 (data->props_hash);
		_g_object_unref0 (data->props);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->title = g_strdup (g_value_get_string ((GValue*) g_hash_table_lookup (data->props_hash, "Identity")));
#line 126 "rygel-mpris-plugin-factory.vala"
	if (data->title == NULL) {
#line 127 "rygel-mpris-plugin-factory.vala"
		data->title = (data->_tmp2_ = g_strdup (data->service_name), _g_free0 (data->title), data->_tmp2_);
#line 776 "rygel-mpris-plugin-factory.c"
	}
	data->mime_types = (data->_tmp4_ = (data->_tmp3_ = g_value_get_boxed ((GValue*) g_hash_table_lookup (data->props_hash, "SupportedMimeTypes")), (data->_tmp3_ == NULL) ? ((gpointer) data->_tmp3_) : _vala_array_dup6 (data->_tmp3_, g_strv_length (g_value_get_boxed ((GValue*) g_hash_table_lookup (data->props_hash, "SupportedMimeTypes"))))), data->mime_types_length1 = g_strv_length (g_value_get_boxed ((GValue*) g_hash_table_lookup (data->props_hash, "SupportedMimeTypes"))), data->_mime_types_size_ = data->mime_types_length1, data->_tmp4_);
	data->schemes = (data->_tmp6_ = (data->_tmp5_ = g_value_get_boxed ((GValue*) g_hash_table_lookup (data->props_hash, "SupportedUriSchemes")), (data->_tmp5_ == NULL) ? ((gpointer) data->_tmp5_) : _vala_array_dup7 (data->_tmp5_, g_strv_length (g_value_get_boxed ((GValue*) g_hash_table_lookup (data->props_hash, "SupportedUriSchemes"))))), data->schemes_length1 = g_strv_length (g_value_get_boxed ((GValue*) g_hash_table_lookup (data->props_hash, "SupportedUriSchemes"))), data->_schemes_size_ = data->schemes_length1, data->_tmp6_);
	data->plugin = rygel_mpris_plugin_new (data->service_name, data->title, data->mime_types, data->mime_types_length1, data->schemes, data->schemes_length1);
#line 138 "rygel-mpris-plugin-factory.vala"
	rygel_plugin_loader_add_plugin (data->self->priv->loader, (RygelPlugin*) data->plugin);
#line 783 "rygel-mpris-plugin-factory.c"
	_g_object_unref0 (data->plugin);
	data->schemes = (_vala_array_free (data->schemes, data->schemes_length1, (GDestroyNotify) g_free), NULL);
	data->mime_types = (_vala_array_free (data->mime_types, data->mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data->title);
	_g_hash_table_unref0 (data->props_hash);
	_g_object_unref0 (data->props);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_mpris_value_plugin_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_mpris_value_plugin_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_mpris_plugin_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_mpris_value_plugin_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_mpris_plugin_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_mpris_value_plugin_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_mpris_value_plugin_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMPRISPluginFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_mpris_plugin_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_mpris_value_plugin_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMPRISPluginFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_mpris_plugin_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_mpris_param_spec_plugin_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelMPRISParamSpecPluginFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_mpris_value_get_plugin_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_mpris_value_set_plugin_factory (GValue* value, gpointer v_object) {
	RygelMPRISPluginFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_mpris_plugin_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_mpris_plugin_factory_unref (old);
	}
}


void rygel_mpris_value_take_plugin_factory (GValue* value, gpointer v_object) {
	RygelMPRISPluginFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_mpris_plugin_factory_unref (old);
	}
}


static void rygel_mpris_plugin_factory_class_init (RygelMPRISPluginFactoryClass * klass) {
	rygel_mpris_plugin_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MPRIS_PLUGIN_FACTORY_CLASS (klass)->finalize = rygel_mpris_plugin_factory_finalize;
	g_type_class_add_private (klass, sizeof (RygelMPRISPluginFactoryPrivate));
}


static void rygel_mpris_plugin_factory_instance_init (RygelMPRISPluginFactory * self) {
	self->priv = RYGEL_MPRIS_PLUGIN_FACTORY_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_mpris_plugin_factory_finalize (RygelMPRISPluginFactory* obj) {
	RygelMPRISPluginFactory * self;
	self = RYGEL_MPRIS_PLUGIN_FACTORY (obj);
	_g_object_unref0 (self->priv->dbus_obj);
	_dbus_g_connection_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->loader);
}


GType rygel_mpris_plugin_factory_get_type (void) {
	static volatile gsize rygel_mpris_plugin_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mpris_plugin_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_mpris_value_plugin_factory_init, rygel_mpris_value_plugin_factory_free_value, rygel_mpris_value_plugin_factory_copy_value, rygel_mpris_value_plugin_factory_peek_pointer, "p", rygel_mpris_value_plugin_factory_collect_value, "p", rygel_mpris_value_plugin_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISPluginFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mpris_plugin_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMPRISPluginFactory), 0, (GInstanceInitFunc) rygel_mpris_plugin_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_mpris_plugin_factory_type_id;
		rygel_mpris_plugin_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMPRISPluginFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_mpris_plugin_factory_type_id__volatile, rygel_mpris_plugin_factory_type_id);
	}
	return rygel_mpris_plugin_factory_type_id__volatile;
}


gpointer rygel_mpris_plugin_factory_ref (gpointer instance) {
	RygelMPRISPluginFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_mpris_plugin_factory_unref (gpointer instance) {
	RygelMPRISPluginFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MPRIS_PLUGIN_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




