/* rygel-playbin-player.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;
typedef struct _RygelPlaybinPlayerPrivate RygelPlaybinPlayerPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelPlaybinPlayer {
	GObject parent_instance;
	RygelPlaybinPlayerPrivate * priv;
};

struct _RygelPlaybinPlayerClass {
	GObjectClass parent_class;
};

struct _RygelPlaybinPlayerPrivate {
	GstElement* playbin;
	char* _playback_state;
};


static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static gpointer rygel_playbin_player_parent_class = NULL;
static RygelMediaPlayerIface* rygel_playbin_player_rygel_media_player_parent_iface = NULL;

GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerPrivate))
enum  {
	RYGEL_PLAYBIN_PLAYER_DUMMY_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE,
	RYGEL_PLAYBIN_PLAYER_URI,
	RYGEL_PLAYBIN_PLAYER_VOLUME,
	RYGEL_PLAYBIN_PLAYER_DURATION,
	RYGEL_PLAYBIN_PLAYER_POSITION
};
static RygelPlaybinPlayer* rygel_playbin_player_new (void);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type);
static gboolean rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_playbin_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
RygelPlaybinPlayer* rygel_playbin_player_get_default (void);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, const char* time);
GstClockTime rygel_playbin_time_from_string (const char* str);
static char** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static char** _vala_array_dup1 (char** self, int length);
static char** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static char** _vala_array_dup2 (char** self, int length);
static inline const char* _dynamic_get_uri0 (GstElement* obj);
static inline void _dynamic_set_uri1 (GstElement* obj, const char* value);
static inline double _dynamic_get_volume2 (GstElement* obj);
static inline void _dynamic_set_volume3 (GstElement* obj, double value);
char* rygel_playbin_time_to_string (GstClockTime time);
static void rygel_playbin_player_finalize (GObject* obj);
static void rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const char* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const char* RYGEL_PLAYBIN_PLAYER_mime_types[26] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-mod", "audio/x-wav", "audio/x-ac3", "audio/x-m4a", "video/x-theora", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/mpeg", "video/mp4", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv", "audio/L16;rate=44100;channels=2", "audio/L16;rate=44100;channels=1"};


#line 169 "rygel-playbin-player.vala"
static gboolean _rygel_playbin_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
#line 108 "rygel-playbin-player.c"
	gboolean result;
	result = rygel_playbin_player_bus_handler (self, bus, message);
	return result;
}


#line 133 "rygel-playbin-player.vala"
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type) {
#line 117 "rygel-playbin-player.c"
	RygelPlaybinPlayer * self;
	GstElement* _tmp0_;
	GstBus* bus;
#line 133 "rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
#line 134 "rygel-playbin-player.vala"
	self->priv->playbin = (_tmp0_ = gst_element_factory_make ("playbin2", NULL), _gst_object_unref0 (self->priv->playbin), _tmp0_);
#line 135 "rygel-playbin-player.vala"
	g_assert (self->priv->playbin != NULL);
#line 138 "rygel-playbin-player.vala"
	bus = gst_element_get_bus (self->priv->playbin);
#line 139 "rygel-playbin-player.vala"
	gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_playbin_player_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
#line 131 "rygel-playbin-player.c"
	_gst_object_unref0 (bus);
	return self;
}


#line 133 "rygel-playbin-player.vala"
static RygelPlaybinPlayer* rygel_playbin_player_new (void) {
#line 133 "rygel-playbin-player.vala"
	return rygel_playbin_player_construct (RYGEL_PLAYBIN_TYPE_PLAYER);
#line 141 "rygel-playbin-player.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 142 "rygel-playbin-player.vala"
RygelPlaybinPlayer* rygel_playbin_player_get_default (void) {
#line 152 "rygel-playbin-player.c"
	RygelPlaybinPlayer* result = NULL;
#line 143 "rygel-playbin-player.vala"
	if (rygel_playbin_player_player == NULL) {
#line 156 "rygel-playbin-player.c"
		RygelPlaybinPlayer* _tmp0_;
#line 144 "rygel-playbin-player.vala"
		rygel_playbin_player_player = (_tmp0_ = rygel_playbin_player_new (), _g_object_unref0 (rygel_playbin_player_player), _tmp0_);
#line 160 "rygel-playbin-player.c"
	}
	result = _g_object_ref0 (rygel_playbin_player_player);
#line 147 "rygel-playbin-player.vala"
	return result;
#line 165 "rygel-playbin-player.c"
}


#line 150 "rygel-playbin-player.vala"
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, const char* time) {
#line 171 "rygel-playbin-player.c"
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	self = (RygelPlaybinPlayer*) base;
#line 150 "rygel-playbin-player.vala"
	g_return_val_if_fail (time != NULL, FALSE);
#line 151 "rygel-playbin-player.vala"
	g_debug (_ ("Seeking to %s."), time);
#line 179 "rygel-playbin-player.c"
	result = gst_element_seek (self->priv->playbin, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, (gint64) rygel_playbin_time_from_string (time), GST_SEEK_TYPE_NONE, (gint64) (-1));
#line 152 "rygel-playbin-player.vala"
	return result;
#line 183 "rygel-playbin-player.c"
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


#line 161 "rygel-playbin-player.vala"
static char** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
#line 200 "rygel-playbin-player.c"
	RygelPlaybinPlayer * self;
	char** result = NULL;
	char** _tmp0_;
	const char** _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	result = (_tmp1_ = (_tmp0_ = RYGEL_PLAYBIN_PLAYER_protocols, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols))), *result_length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols), _tmp1_);
#line 162 "rygel-playbin-player.vala"
	return result;
#line 209 "rygel-playbin-player.c"
}


static char** _vala_array_dup2 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


#line 165 "rygel-playbin-player.vala"
static char** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
#line 226 "rygel-playbin-player.c"
	RygelPlaybinPlayer * self;
	char** result = NULL;
	char** _tmp0_;
	const char** _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	result = (_tmp1_ = (_tmp0_ = RYGEL_PLAYBIN_PLAYER_mime_types, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup2 (_tmp0_, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types))), *result_length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types), _tmp1_);
#line 166 "rygel-playbin-player.vala"
	return result;
#line 235 "rygel-playbin-player.c"
}


#line 169 "rygel-playbin-player.vala"
static gboolean rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message) {
#line 241 "rygel-playbin-player.c"
	gboolean result = FALSE;
#line 169 "rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 169 "rygel-playbin-player.vala"
	g_return_val_if_fail (bus != NULL, FALSE);
#line 169 "rygel-playbin-player.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 171 "rygel-playbin-player.vala"
	switch (message->type) {
#line 251 "rygel-playbin-player.c"
		case GST_MESSAGE_EOS:
		{
#line 173 "rygel-playbin-player.vala"
			g_debug ("rygel-playbin-player.vala:173: EOS");
#line 175 "rygel-playbin-player.vala"
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 177 "rygel-playbin-player.vala"
			break;
#line 260 "rygel-playbin-player.c"
		}
		case GST_MESSAGE_ERROR:
		{
			GError* _error_;
			char* error_message;
			GError* _tmp0_ = NULL;
			GError* _tmp1_;
			char* _tmp2_ = NULL;
			char* _tmp3_;
			_error_ = NULL;
			error_message = NULL;
#line 182 "rygel-playbin-player.vala"
			(gst_message_parse_error (message, &_tmp0_, &_tmp2_), _error_ = (_tmp1_ = _tmp0_, _g_error_free0 (_error_), _tmp1_));
#line 182 "rygel-playbin-player.vala"
			error_message = (_tmp3_ = _tmp2_, _g_free0 (error_message), _tmp3_);
#line 184 "rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:184: Error from GStreamer element %s: %s", gst_object_get_name ((GstObject*) self->priv->playbin), error_message);
#line 187 "rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:187: Going to STOPPED state");
#line 189 "rygel-playbin-player.vala"
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 282 "rygel-playbin-player.c"
			_g_free0 (error_message);
			_g_error_free0 (_error_);
#line 191 "rygel-playbin-player.vala"
			break;
#line 287 "rygel-playbin-player.c"
		}
	}
	result = TRUE;
#line 194 "rygel-playbin-player.vala"
	return result;
#line 293 "rygel-playbin-player.c"
}


static const char* rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base) {
	const char* result;
	RygelPlaybinPlayer* self;
	self = (RygelPlaybinPlayer*) base;
	result = self->priv->_playback_state;
#line 62 "rygel-playbin-player.vala"
	return result;
#line 304 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base, const char* value) {
	RygelPlaybinPlayer* self;
	char* _tmp0_;
	const char* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	self = (RygelPlaybinPlayer*) base;
#line 66 "rygel-playbin-player.vala"
	g_debug (_ ("Changing playback state to %s.."), value);
#line 67 "rygel-playbin-player.vala"
	self->priv->_playback_state = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_playback_state), _tmp0_);
#line 321 "rygel-playbin-player.c"
	_tmp1_ = self->priv->_playback_state;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("STOPPED"))))
	switch (0) {
		default:
		{
#line 71 "rygel-playbin-player.vala"
			gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 72 "rygel-playbin-player.vala"
			break;
#line 332 "rygel-playbin-player.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("PAUSED_PLAYBACK"))))
	switch (0) {
		default:
		{
#line 74 "rygel-playbin-player.vala"
			gst_element_set_state (self->priv->playbin, GST_STATE_PAUSED);
#line 75 "rygel-playbin-player.vala"
			break;
#line 342 "rygel-playbin-player.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("PLAYING"))))
	switch (0) {
		default:
		{
#line 77 "rygel-playbin-player.vala"
			gst_element_set_state (self->priv->playbin, GST_STATE_PLAYING);
#line 78 "rygel-playbin-player.vala"
			break;
#line 352 "rygel-playbin-player.c"
		}
	} else
	switch (0) {
		default:
		{
#line 80 "rygel-playbin-player.vala"
			break;
#line 360 "rygel-playbin-player.c"
		}
	}
	g_object_notify ((GObject *) self, "playback-state");
}


static inline const char* _dynamic_get_uri0 (GstElement* obj) {
	const char* result;
	g_object_get (obj, "uri", &result, NULL);
	return result;
}


static const char* rygel_playbin_player_real_get_uri (RygelMediaPlayer* base) {
	const char* result;
	RygelPlaybinPlayer* self;
	self = (RygelPlaybinPlayer*) base;
	result = _dynamic_get_uri0 (self->priv->playbin);
#line 87 "rygel-playbin-player.vala"
	return result;
#line 381 "rygel-playbin-player.c"
}


static inline void _dynamic_set_uri1 (GstElement* obj, const char* value) {
	g_object_set (obj, "uri", value, NULL);
}


static void rygel_playbin_player_real_set_uri (RygelMediaPlayer* base, const char* value) {
	RygelPlaybinPlayer* self;
	self = (RygelPlaybinPlayer*) base;
#line 91 "rygel-playbin-player.vala"
	_dynamic_set_uri1 (self->priv->playbin, value);
#line 92 "rygel-playbin-player.vala"
	g_debug (_ ("URI set to %s."), value);
#line 397 "rygel-playbin-player.c"
	g_object_notify ((GObject *) self, "uri");
}


static inline double _dynamic_get_volume2 (GstElement* obj) {
	double result;
	g_object_get (obj, "volume", &result, NULL);
	return result;
}


static double rygel_playbin_player_real_get_volume (RygelMediaPlayer* base) {
	double result;
	RygelPlaybinPlayer* self;
	self = (RygelPlaybinPlayer*) base;
	result = _dynamic_get_volume2 (self->priv->playbin);
#line 98 "rygel-playbin-player.vala"
	return result;
#line 416 "rygel-playbin-player.c"
}


static inline void _dynamic_set_volume3 (GstElement* obj, double value) {
	g_object_set (obj, "volume", value, NULL);
}


static void rygel_playbin_player_real_set_volume (RygelMediaPlayer* base, double value) {
	RygelPlaybinPlayer* self;
	self = (RygelPlaybinPlayer*) base;
#line 102 "rygel-playbin-player.vala"
	_dynamic_set_volume3 (self->priv->playbin, value);
#line 103 "rygel-playbin-player.vala"
	g_debug (_ ("volume set to %f."), value);
#line 432 "rygel-playbin-player.c"
	g_object_notify ((GObject *) self, "volume");
}


static char* rygel_playbin_player_real_get_duration (RygelMediaPlayer* base) {
	char* result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 dur = 0LL;
	self = (RygelPlaybinPlayer*) base;
#line 109 "rygel-playbin-player.vala"
	format = GST_FORMAT_TIME;
#line 112 "rygel-playbin-player.vala"
	if (gst_element_query_duration (self->priv->playbin, &format, &dur)) {
#line 447 "rygel-playbin-player.c"
		result = rygel_playbin_time_to_string ((GstClockTime) dur);
#line 113 "rygel-playbin-player.vala"
		return result;
#line 451 "rygel-playbin-player.c"
	} else {
		result = g_strdup ("00:00:00");
#line 115 "rygel-playbin-player.vala"
		return result;
#line 456 "rygel-playbin-player.c"
	}
}


static char* rygel_playbin_player_real_get_position (RygelMediaPlayer* base) {
	char* result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 pos = 0LL;
	self = (RygelPlaybinPlayer*) base;
#line 122 "rygel-playbin-player.vala"
	format = GST_FORMAT_TIME;
#line 125 "rygel-playbin-player.vala"
	if (gst_element_query_position (self->priv->playbin, &format, &pos)) {
#line 471 "rygel-playbin-player.c"
		result = rygel_playbin_time_to_string ((GstClockTime) pos);
#line 126 "rygel-playbin-player.vala"
		return result;
#line 475 "rygel-playbin-player.c"
	} else {
		result = g_strdup ("00:00:00");
#line 128 "rygel-playbin-player.vala"
		return result;
#line 480 "rygel-playbin-player.c"
	}
}


static void rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass) {
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlaybinPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_playbin_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_playbin_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE, "playback-state");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME, "volume");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION, "duration");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION, "position");
}


static void rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = rygel_playbin_player_real_seek;
	iface->get_protocols = rygel_playbin_player_real_get_protocols;
	iface->get_mime_types = rygel_playbin_player_real_get_mime_types;
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
	iface->get_uri = rygel_playbin_player_real_get_uri;
	iface->set_uri = rygel_playbin_player_real_set_uri;
	iface->get_volume = rygel_playbin_player_real_get_volume;
	iface->set_volume = rygel_playbin_player_real_set_volume;
	iface->get_duration = rygel_playbin_player_real_get_duration;
	iface->get_position = rygel_playbin_player_real_get_position;
}


static void rygel_playbin_player_instance_init (RygelPlaybinPlayer * self) {
	self->priv = RYGEL_PLAYBIN_PLAYER_GET_PRIVATE (self);
	self->priv->_playback_state = g_strdup ("STOPPED");
}


static void rygel_playbin_player_finalize (GObject* obj) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (obj);
	_gst_object_unref0 (self->priv->playbin);
	_g_free0 (self->priv->_playback_state);
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
}


GType rygel_playbin_player_get_type (void) {
	static volatile gsize rygel_playbin_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_playbin_player_type_id__volatile, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__volatile;
}


static void rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (object);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		g_value_set_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		g_value_set_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_DURATION:
		g_value_take_string (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_POSITION:
		g_value_take_string (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (object);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




