/*
 *  Copyright (C) 2003  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_go_button_h
#define __galeon_go_button_h

#include "galeon-tbi.h"

/* object forward declarations */

typedef struct _GaleonGoButton GaleonGoButton;
typedef struct _GaleonGoButtonClass GaleonGoButtonClass;
typedef struct _GaleonGoButtonPrivate GaleonGoButtonPrivate;

/**
 * TbiZoom object
 */

#define GALEON_TYPE_GO_BUTTON			(galeon_go_button_get_type())
#define GALEON_GO_BUTTON(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), \
						 GALEON_TYPE_GO_BUTTON, GaleonGoButton))
#define GALEON_GO_BUTTON_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GALEON_TYPE_GO_BUTTON,\
						 GaleonGoButtonClass))
#define GALEON_IS_GO_BUTTON(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), \
						 GALEON_TYPE_GO_BUTTON))
#define GALEON_IS_GO_BUTTON_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GALEON_TYPE_GO_BUTTON))
#define GALEON_GO_BUTTON_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GALEON_TYPE_GO_BUTTON,\
						 GaleonGoButtonClass))

struct _GaleonGoButtonClass 
{
	GaleonTbiClass parent_class;
};

/* Remember: fields are public read-only */
struct _GaleonGoButton
{
	GaleonTbi parent_object;
	GaleonGoButtonPrivate *priv;
};

/* this class is abstract */

GType				galeon_go_button_get_type		(void);
GaleonGoButton *		galeon_go_button_new			(void);
void				galeon_go_button_set_sensitive		(GaleonGoButton *b, gboolean s);

#endif
