/* spui.c
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include "spui.h"
#include "SRMessages.h"
#include "libsrconf.h"
#include <glade/glade.h>
#include "srintl.h"
#include "defui.h"
#include "gnopiui.h"

#define INVALID_VOICE "test"

typedef enum
{
    PUNCTUATION_IGNORE,
    PUNCTUATION_SAME,
    PUNCTUATION_MOST,
    PUNCTUATION_ALL,
    PUNCTUATION_NUMBER
}PunctuationType;

typedef enum
{
    TEXT_ECHO_CHARACTER,
    TEXT_ECHO_WORD,
    TEXT_ECHO_NUMBER
}TextEchoType;

enum 
{
    VOICE_GNOPERNICUS_SPEAKER,
    VOICE_GNOME_SPEAK_SPEAKER,
    VOICE_VOLUME,
    VOICE_RATE,
    VOICE_PITCH,
    
    VOICE_NO_COLUMN
};

enum
{
    SPEECH_DICTIONARY_WORD,
    SPEECH_DICTIONARY_REPLACER,
    
    SPEECH_DICTIONARY_NO_COLUMN
};

struct {
    GtkWidget	*w_speech_settings;
    GtkWidget	*ck_count;
    GtkWidget	*ck_spaces;
    GtkWidget	*ck_cursors;
    GtkWidget	*ck_modifiers;
    GtkWidget	*ck_dictionary;
    GtkWidget	*bt_dictionary;
    GtkWidget	*rb_punctuation [PUNCTUATION_NUMBER];
    GtkWidget	*rb_text_echo [TEXT_ECHO_NUMBER];
} spui_speech_settings;

struct {
    GtkWidget	*w_dictionary;
    GtkWidget	*w_dict_add_modify;
    GtkWidget	*et_word;
    GtkWidget	*et_replace;
    GtkWidget	*tv_dictionary;
} spui_speech_dictionary;

struct {
    GtkWidget	*w_speech_voice_add_modify;
    GtkWidget	*w_speech_voice;
    GtkWidget	*tv_voice_table;
    GtkWidget	*cb_engine_voice;
    GtkWidget	*et_gnopernicus_voice;
    GtkWidget	*sp_voice_volume;
    GtkWidget	*sp_voice_rate;
    GtkWidget	*sp_voice_pitch;
    GtkWidget	*sp_voice_priority;
    GtkWidget	*hs_voice_volume;
    GtkWidget	*hs_voice_rate;
    GtkWidget	*hs_voice_pitch;
    GtkWidget	*hs_voice_priority;
} spui_speech_voice;


static GtkTreeIter			curr_iter;		
static SpeakerParameterType		*curr_speaker_parameter;
static GnopernicusSpeakerListType	*curr_gnopernicus_speaker;
static SpeakerSettings			old_speaker_settings;
static gboolean				new_item;

extern Speech 				*speech_setting;
static gboolean				speech_changed;
static gboolean				changes_activable;

extern GnopernicusSpeakerListType 	*gnopernicus_speakers;
extern GnopernicusSpeakerListType 	*gnopernicus_speakers_backup;
extern SpeakerParameterType  		*speakers_parameters;
extern SpeakerParameterType  		*speakers_parameters_backup;
extern DictionaryListType		*dictionary_list;

gchar *punct_keys[]=
{
    "IGNORE",
    "SAME",
    "TRANSLATE",
    "BOTH"
};

gchar *common_keys[]=
{
    "NONE",
    "ALL"
};

gchar *dictionary_keys[]=
{
    "NO",
    "YES"
};

gchar *text_echo_keys[]=
{
    "CHARACTER",
    "WORD"
};

#define STR(X) (X == NULL? "" : X)
/*--------------------------------------------------------------------------*/

#if 0
static void
spui_debug (GSList *list, GSList *gs)
{
    GSList *elem = NULL;
    sru_debug  ("\n\n-----------------------");
    
    for (elem = gs ; elem ; elem = elem->next)
	sru_debug  ("\ngnopernicus_speaker:%s", elem->data);
	
    for (elem = list ; elem ; elem = elem->next)
    {
	SpeakerSettings *ss = NULL;
	ss = (SpeakerSettings*)elem->data;
	if (ss)
	{
	    if (ss->gnopernicus_speaker)
		sru_debug  ("\ngn_speker:%s", ss->gnopernicus_speaker);
	    if (ss->gs_speaker)
		sru_debug  ("\ngs_speker:%s", ss->gs_speaker);
	    sru_debug  ("\nvolume:%d", ss->volume);
	    sru_debug  ("\nrate:%d", ss->rate);
	    sru_debug  ("\npitch:%d", ss->pitch);
	}
    }
    
}
#endif

static void
spui_clean_old_speaker_setting (void)
{
    old_speaker_settings.volume = 0;
    old_speaker_settings.rate   = 0;
    old_speaker_settings.pitch  = 0;
    g_free (old_speaker_settings.gs_speaker);
    g_free (old_speaker_settings.gnopernicus_speaker);
    old_speaker_settings.gs_speaker = NULL;
    old_speaker_settings.gnopernicus_speaker = NULL;
}

static gboolean
spui_add_modify_get_properties (void)
{
    gchar *cvalue;
    SpeakerParameterType *elem = NULL;
    SpeakerSettings *curr_setting = NULL;
    GtkTreeModel    *model = NULL;

    if (!spui_speech_voice.w_speech_voice_add_modify ||
	!curr_speaker_parameter    ||
	!curr_gnopernicus_speaker) 
	return FALSE;

    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));    
    
    curr_setting = (SpeakerSettings*)curr_speaker_parameter->data;
    
    curr_setting->volume = 
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_volume));
    
    curr_setting->rate = 
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_rate));
    
    curr_setting->pitch = 
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_pitch));
    
    (const gchar*)cvalue = 
	gtk_entry_get_text (GTK_ENTRY ( GTK_COMBO (spui_speech_voice.cb_engine_voice)->entry));

    if (cvalue)
    {
	g_free (curr_setting->gs_speaker);
	curr_setting->gs_speaker = g_strdup (cvalue);
    }

    
    (const gchar*)cvalue = 
	gtk_entry_get_text (GTK_ENTRY (spui_speech_voice.et_gnopernicus_voice));    
    
    elem = spconf_speaker_parameters_find (speakers_parameters, cvalue);
    
    if ((!elem && new_item && strcmp (NONE_ELEMENT, cvalue) && strcmp (INVALID_VOICE, cvalue)) || 
	(elem && !new_item && strcmp (NONE_ELEMENT, cvalue) && strcmp (INVALID_VOICE, cvalue)))
    {
	GSList *found = NULL;

	if (new_item)
	{
	    g_free (curr_setting->gnopernicus_speaker);
	    curr_setting->gnopernicus_speaker = g_strdup (cvalue);
	    
	    g_free (curr_gnopernicus_speaker->data);
	    
	    found = spconf_gnopernicus_speakers_find (gnopernicus_speakers, cvalue);
	    
	    if (found)
	    {
		gnopernicus_speakers = 
		    g_slist_remove_link (gnopernicus_speakers, curr_gnopernicus_speaker);
		g_slist_free (curr_gnopernicus_speaker);
		curr_gnopernicus_speaker = NULL;
	    }
	    else
		curr_gnopernicus_speaker->data = g_strdup (cvalue);

	}
	    
	gtk_list_store_set ( GTK_LIST_STORE (model), &curr_iter, 
			    VOICE_GNOPERNICUS_SPEAKER,	(gchar*)curr_setting->gnopernicus_speaker,
			    VOICE_GNOME_SPEAK_SPEAKER,  (gchar*)curr_setting->gs_speaker,
			    VOICE_VOLUME,		curr_setting->volume,
			    VOICE_RATE,			curr_setting->rate,
			    VOICE_PITCH,		curr_setting->pitch,
		    	    -1);
	return TRUE;
    }
    else
    {
	speakers_parameters =
	    spconf_speaker_parameters_remove   (speakers_parameters,
						curr_setting->gnopernicus_speaker);
	gtk_list_store_remove (GTK_LIST_STORE (model), &curr_iter);
	defui_send_msg (_("Invalide voice!"));
	return FALSE;
    }        
}

static void
spui_remove_created_item (void)
{
    GtkTreeModel     *model;
    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));
    
    if (new_item)
    {
	gtk_list_store_remove ( GTK_LIST_STORE (model), &curr_iter);
	
	if (curr_speaker_parameter && 
	    curr_speaker_parameter->data)
	{
	    speakers_parameters =
		spconf_speaker_parameters_remove (speakers_parameters,
		((SpeakerSettings*)curr_speaker_parameter->data)->gnopernicus_speaker);
	}
    }
    else
    {
	gtk_list_store_set (GTK_LIST_STORE (model), &curr_iter, 
			    VOICE_GNOPERNICUS_SPEAKER,(gchar*)old_speaker_settings.gnopernicus_speaker,
			    VOICE_GNOME_SPEAK_SPEAKER,(gchar*)old_speaker_settings.gs_speaker,
			    VOICE_VOLUME,		old_speaker_settings.volume,
			    VOICE_RATE,			old_speaker_settings.rate,
			    VOICE_PITCH,		old_speaker_settings.pitch,
		    	    -1);
	curr_speaker_parameter->data =
		spconf_speaker_settings_copy (curr_speaker_parameter->data, 
			    		      &old_speaker_settings);

	spconf_speaker_settings_save ((SpeakerSettings*)curr_speaker_parameter->data);
    }
}

void
spui_engine_voice_list_set (GList *voice_list)
{
    if (!voice_list) 
	return;
    gtk_combo_set_popdown_strings ( GTK_COMBO (spui_speech_voice.cb_engine_voice),
				    voice_list);
}

static void
spui_add_modify_select (const gchar *mode)
{	
    gboolean state = FALSE;
    if (!strcmp (mode, "ADD"))  state = TRUE;
		    else	state = FALSE;
    gtk_widget_set_sensitive (GTK_WIDGET (spui_speech_voice.et_gnopernicus_voice), state);
}

static gboolean
spui_add_modify_set_properties (const gchar 	*gs_speaker,
				const gchar   	*gnopernicus_speaker,
				gint  	volume,
				gint  	pitch,
				gint 	rate)
{        
    if (!spui_speech_voice.w_speech_voice_add_modify) 
	return FALSE;
	
    spui_clean_old_speaker_setting ();
    old_speaker_settings.volume = volume;
    old_speaker_settings.rate   = rate;
    old_speaker_settings.pitch  = pitch;
    old_speaker_settings.gs_speaker = g_strdup (gs_speaker);
    old_speaker_settings.gnopernicus_speaker = g_strdup (gnopernicus_speaker);
    
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_volume), 	(gdouble)volume);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_rate), 	(gdouble)rate);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_pitch), 	(gdouble)pitch);
    gtk_range_set_value (GTK_RANGE (spui_speech_voice.hs_voice_volume), volume);
    gtk_range_set_value (GTK_RANGE (spui_speech_voice.hs_voice_rate), 	rate);
    gtk_range_set_value (GTK_RANGE (spui_speech_voice.hs_voice_pitch), 	pitch);
    gtk_entry_set_text  (GTK_ENTRY (spui_speech_voice.et_gnopernicus_voice), gnopernicus_speaker);
    gtk_entry_set_text  (GTK_ENTRY (GTK_COMBO (spui_speech_voice.cb_engine_voice)->entry), gs_speaker);
    return TRUE;
}

gboolean
spui_add_modify_set_properties_settings (SpeakerSettings *settings)
{
    return
	spui_add_modify_set_properties ((const gchar*)settings->gs_speaker,
					(const gchar*)settings->gnopernicus_speaker,
					settings->volume,
					settings->pitch,
					settings->rate);
}

static void 
spui_hs_voice_property_value_changed (GtkWidget	*widget,
			    	      gpointer	data)
{
    gint value1, value2;
    SpeakerSettings *curr_setting = NULL;
    
    if (!curr_speaker_parameter) 
	return;
	
    value1 = (gint) gtk_range_get_value (GTK_RANGE (widget));
    value2 = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON ((GtkWidget*)data));
    
    if (value1 == value2 || 
	!changes_activable)
	return;
	
    curr_setting = (SpeakerSettings*)curr_speaker_parameter->data;
    
    gtk_spin_button_set_value (GTK_SPIN_BUTTON ((GtkWidget*)data), (gdouble)value1);
    
    curr_setting->volume = 
		    (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_volume));
    curr_setting->rate = 
		    (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_rate));
    curr_setting->pitch = 
		    (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_pitch));
    
    if (!new_item)
        spconf_speaker_settings_save (curr_setting);
}

static void
spui_sp_voice_property_value_changed (GtkWidget	*widget,
				      gpointer	data)
{

    gint value1, value2;
    SpeakerSettings *curr_setting = NULL;
    
    if (!curr_speaker_parameter) 
	return;

    gtk_spin_button_update (GTK_SPIN_BUTTON (widget));
    value1 = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget));
    value2 = (gint) gtk_range_get_value (GTK_RANGE ((GtkWidget*)data));
    
    if (value1 == value2 || 
	!changes_activable)
	return;
	
    curr_setting = (SpeakerSettings*)curr_speaker_parameter->data;

    gtk_range_set_value (GTK_RANGE ((GtkWidget*)data), value1);
    
    curr_setting->volume = 
		    (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_volume));
    curr_setting->rate   = 
		    (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_rate));
    curr_setting->pitch  = 
		    (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spui_speech_voice.sp_voice_pitch));
    
    if (!new_item)
	spconf_speaker_settings_save (curr_setting);
}

static void
spui_combo_changed (GtkWidget *widget,
		    gpointer  user_data)
{
    gchar *cvalue;
    SpeakerSettings *curr_setting = NULL;
    
    if (!curr_speaker_parameter ||
	!changes_activable) 
	return;
    
    curr_setting = 
	(SpeakerSettings*)curr_speaker_parameter->data;
    (const gchar*)cvalue = 
	gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (spui_speech_voice.cb_engine_voice)->entry));
    
    if (strcmp (curr_setting->gs_speaker, cvalue) && 
	strlen (cvalue) > 0 &&
	strcmp (cvalue, NONE_ELEMENT) &&
	strcmp (curr_setting->gnopernicus_speaker, NONE_ELEMENT))
    {
	g_free (curr_setting->gs_speaker);
	curr_setting->gs_speaker = g_strdup (cvalue);
	if (!new_item)
	    spconf_speaker_settings_save (curr_setting);
    }
}

static void
spui_voice_add_modify_settings_response (GtkDialog *dialog,
					gint       response_id,
					gpointer   user_data)
{
    switch (response_id)
    {
     case GTK_RESPONSE_OK: 
        {
	    if (spui_add_modify_get_properties ())
 	    {
    		spconf_speaker_settings_save ((SpeakerSettings*)curr_speaker_parameter->data);
    		if (new_item)
		    spconf_gnopernicus_speakers_save (gnopernicus_speakers);
	    }
	    changes_activable = FALSE;
	    spui_clean_old_speaker_setting ();
	    gtk_widget_hide ((GtkWidget*)dialog);
	}
        break;
    case GTK_RESPONSE_CANCEL:
        {
	    spui_remove_created_item ();
	    changes_activable = FALSE;
	    spui_clean_old_speaker_setting ();
	    gtk_widget_hide ((GtkWidget*)dialog);
	}
        break;
    case GTK_RESPONSE_HELP: 
	gn_load_help ("gnopernicus-speech-settings");
	break;
     default:
         gtk_widget_hide ((GtkWidget*)dialog);
        break;
    }
}


static gint
spui_delete_emit_response_cancel (GtkDialog *dialog,
				    GdkEventAny *event,
				    gpointer data)
{
    gtk_dialog_response (GTK_DIALOG (dialog),
			 GTK_RESPONSE_CANCEL);
    return TRUE; /* Do not destroy */
}


static void
spui_set_voice_add_modify_handlers  (GladeXML *xml)
{
    spui_speech_voice.w_speech_voice_add_modify = glade_xml_get_widget (xml, "w_voice_add_modify");
    
    spui_speech_voice.cb_engine_voice 	   = glade_xml_get_widget (xml, "cb_engine_voice");
    spui_speech_voice.et_gnopernicus_voice = glade_xml_get_widget (xml, "et_gnopernicus_voice");
    
    spui_speech_voice.hs_voice_volume	= glade_xml_get_widget (xml, "hs_voice_volume");
    spui_speech_voice.hs_voice_rate	= glade_xml_get_widget (xml, "hs_voice_rate");
    spui_speech_voice.hs_voice_pitch	= glade_xml_get_widget (xml, "hs_voice_pitch");
    spui_speech_voice.hs_voice_priority	= glade_xml_get_widget (xml, "hs_voice_priority");
    spui_speech_voice.sp_voice_priority	= glade_xml_get_widget (xml, "sp_voice_priority");
    spui_speech_voice.sp_voice_volume	= glade_xml_get_widget (xml, "sp_voice_volume");
    spui_speech_voice.sp_voice_rate	= glade_xml_get_widget (xml, "sp_voice_rate");
    spui_speech_voice.sp_voice_pitch	= glade_xml_get_widget (xml, "sp_voice_pitch");

    g_object_set_data (G_OBJECT (spui_speech_voice.hs_voice_pitch),"param", (gint *)VOICE_PITCH);
    
    g_signal_connect (spui_speech_voice.w_speech_voice_add_modify, "response",
		      G_CALLBACK (spui_voice_add_modify_settings_response), NULL);
    g_signal_connect (spui_speech_voice.w_speech_voice_add_modify, "delete_event",
                      G_CALLBACK (spui_delete_emit_response_cancel), NULL);

    glade_xml_signal_connect (xml,"on_combo-entry3_changed",		
			    GTK_SIGNAL_FUNC (spui_combo_changed));

    glade_xml_signal_connect_data (xml, "on_hs_voice_volume_value_changed",			
			    GTK_SIGNAL_FUNC (spui_hs_voice_property_value_changed), 
			    (gpointer)spui_speech_voice.sp_voice_volume);
    glade_xml_signal_connect_data (xml, "on_hs_voice_rate_value_changed",			
			    GTK_SIGNAL_FUNC (spui_hs_voice_property_value_changed), 
			    (gpointer)spui_speech_voice.sp_voice_rate);
    glade_xml_signal_connect_data (xml, "on_hs_voice_pitch_value_changed",			
			    GTK_SIGNAL_FUNC (spui_hs_voice_property_value_changed),
			    (gpointer)spui_speech_voice.sp_voice_pitch);
    glade_xml_signal_connect_data (xml, "on_hs_voice_priority_value_changed",			
			    GTK_SIGNAL_FUNC (spui_hs_voice_property_value_changed),
			    (gpointer)spui_speech_voice.sp_voice_priority);

    glade_xml_signal_connect_data (xml, "on_sp_voice_volume_changed",			
			    GTK_SIGNAL_FUNC (spui_sp_voice_property_value_changed), 
			    (gpointer)spui_speech_voice.hs_voice_volume);
    glade_xml_signal_connect_data (xml, "on_sp_voice_rate_changed",			
			    GTK_SIGNAL_FUNC (spui_sp_voice_property_value_changed), 
			    (gpointer)spui_speech_voice.hs_voice_rate);
    glade_xml_signal_connect_data (xml, "on_sp_voice_pitch_changed",			
			    GTK_SIGNAL_FUNC (spui_sp_voice_property_value_changed),
			    (gpointer)spui_speech_voice.hs_voice_pitch);
    glade_xml_signal_connect_data (xml, "on_sp_voice_priority_changed",			
			    GTK_SIGNAL_FUNC (spui_sp_voice_property_value_changed),
			    (gpointer)spui_speech_voice.hs_voice_priority);

}

static gboolean 
spui_load_speech_voice_add_modify (GtkWidget *parent_window)
{        
    if (!spui_speech_voice.w_speech_voice_add_modify)
    {
	GladeXML *xml;
	xml = gn_load_interface ("Speech_Settings/speech_settings.glade2", "w_voice_add_modify");
	sru_return_val_if_fail (xml, FALSE);
	spui_set_voice_add_modify_handlers  (xml);
	spconf_load_voices ();    
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for ( GTK_WINDOW (spui_speech_voice.w_speech_voice_add_modify),
				           GTK_WINDOW (parent_window));
				    
	gtk_window_set_destroy_with_parent ( GTK_WINDOW (spui_speech_voice.w_speech_voice_add_modify), 
				         TRUE);
    }
    else
	gtk_widget_show (spui_speech_voice.w_speech_voice_add_modify);
        
    return TRUE;
}

/*-----------------------------------------------------------------------------*/
static gboolean
spui_speaker_parameter_add (void)
{
    GtkTreeModel     *model;
    GtkTreeSelection *selection;

    model 	  = gtk_tree_view_get_model 	( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));
    selection     = gtk_tree_view_get_selection ( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));

    spui_load_speech_voice_add_modify (spui_speech_voice.w_speech_voice);
    spui_add_modify_select ("ADD");

    gtk_list_store_append (GTK_LIST_STORE (model), &curr_iter);
	
    new_item = TRUE;
    gnopernicus_speakers = 
	spconf_gnopernicus_speakers_add (gnopernicus_speakers, NONE_ELEMENT);
    speakers_parameters = 
	spconf_speaker_parameters_add  (speakers_parameters, NONE_ELEMENT,
							     DEFAULT_SPEECH_ENGINE_VOICE,
							     DEFAULT_SPEECH_VOLUME, 
							     DEFAULT_SPEECH_PITCH,
							     DEFAULT_SPEECH_RATE);
    curr_speaker_parameter   = g_slist_last (speakers_parameters);
    curr_gnopernicus_speaker = g_slist_last (gnopernicus_speakers);
    
    if (curr_speaker_parameter)
	spui_add_modify_set_properties_settings ((SpeakerSettings*)curr_speaker_parameter->data);
	    
    changes_activable = TRUE;
    
    return TRUE;
}

static gboolean
spui_speaker_parameter_modify (void)
{
    GtkTreeModel     *model;
    GtkTreeSelection *selection;

    model 	  = gtk_tree_view_get_model 	( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));
    selection     = gtk_tree_view_get_selection ( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));

    if (!gtk_tree_selection_get_selected (selection, NULL, &curr_iter))
	return FALSE;

    spui_load_speech_voice_add_modify (spui_speech_voice.w_speech_voice);
    spui_add_modify_select ("MODIFY");
    new_item = FALSE;
    
    if (GTK_IS_LIST_STORE (model))
    {
	gchar *gnop_speak;
	gchar *gs_speak;
	gint volume;
	gint rate;
	gint pitch;
		
	gtk_tree_model_get (model, 	&curr_iter,
			    VOICE_GNOPERNICUS_SPEAKER,	&gnop_speak,
			    VOICE_GNOME_SPEAK_SPEAKER,  &gs_speak,
			    VOICE_VOLUME,	&volume,
			    VOICE_RATE,		&rate,
			    VOICE_PITCH,	&pitch,
                    	    -1);
				    
	curr_speaker_parameter = 
	    spconf_speaker_parameters_find   (speakers_parameters,  gnop_speak);
	curr_gnopernicus_speaker = 
	    spconf_gnopernicus_speakers_find (gnopernicus_speakers, gnop_speak);
						      
	spui_add_modify_set_properties (gs_speak, gnop_speak, volume,
					pitch,	  rate);

	g_free (gnop_speak);
	g_free (gs_speak);
    }

    changes_activable = TRUE;

    return TRUE;
}

static void
spui_voice_modify ( GtkWidget *widget,
		    gpointer  user_data)
{
    spui_speaker_parameter_modify ();
}

static void
spui_voice_add (GtkWidget *widget,
	        gpointer  user_data)
{
    spui_speaker_parameter_add ();
}

static void
spui_voice_remove (GtkWidget *widget,
		    gpointer user_data)
{
    GtkTreeModel     *model;
    GtkTreeSelection *selection;
    GtkTreeIter	     iter;
    
    model 	  = gtk_tree_view_get_model 	( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));
    selection     = gtk_tree_view_get_selection ( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));

    if (!gtk_tree_selection_get_selected (selection, NULL, &iter))
	return;
    
    if (GTK_IS_LIST_STORE (model))
    {
        gchar *gnoper_speaker;
        gtk_tree_model_get (model, 			&iter,
			    VOICE_GNOPERNICUS_SPEAKER, &gnoper_speaker,
                    	    -1);

	if (!gnoper_speaker)
	    return;
	
	gnopernicus_speakers =
		    spconf_gnopernicus_speakers_remove (gnopernicus_speakers,
							gnoper_speaker);
	    
	speakers_parameters =
		    spconf_speaker_parameters_remove (speakers_parameters,
						      gnoper_speaker);
	gtk_list_store_remove ( GTK_LIST_STORE (model), &iter);
	g_free (gnoper_speaker);
    }
}

static void
spui_free_lists (void)
{
    gnopernicus_speakers_backup =
	    spconf_gnopernicus_speakers_free (gnopernicus_speakers_backup);
    speakers_parameters_backup  =
	    spconf_speaker_parameters_free (speakers_parameters_backup);
    gnopernicus_speakers_backup = 
	    spconf_gnopernicus_speakers_clone (gnopernicus_speakers);			   
    speakers_parameters_backup  =
	    spconf_speaker_parameters_clone (speakers_parameters);
}

static void
spui_row_activated_cb (GtkTreeView       *tree_view,
            	       GtkTreePath       *path,
		       GtkTreeViewColumn *column)
{
    spui_load_speech_voice_add_modify (spui_speech_voice.w_speech_voice);
    spui_add_modify_select ("MODIFY");
    spui_speaker_parameter_modify ();
}


static void
spui_voice_settings_response (GtkDialog *dialog,
			    gint       response_id,
			    gpointer   user_data)
{
    switch (response_id)
    {
	case GTK_RESPONSE_OK: 
        {
	    gtk_widget_hide ((GtkWidget*)dialog);
	    spconf_gnopernicus_speakers_save (gnopernicus_speakers);
	    spconf_speaker_parameters_save (speakers_parameters);
	    spui_free_lists ();
	}
        break;
	case GTK_RESPONSE_CANCEL:
        {
	    gtk_widget_hide ((GtkWidget*)dialog);
	    spconf_gnopernicus_speakers_save (gnopernicus_speakers_backup);
	    spconf_speaker_parameters_save (speakers_parameters_backup);
	    spui_free_lists ();
	}
        break;
	case GTK_RESPONSE_APPLY:
        {
	    spconf_gnopernicus_speakers_save (gnopernicus_speakers);
	    spconf_speaker_parameters_save (speakers_parameters);
	    gnopernicus_speakers_backup =
		    spconf_gnopernicus_speakers_free (gnopernicus_speakers_backup);
	    speakers_parameters_backup  =
		    spconf_speaker_parameters_free (speakers_parameters_backup);
	    gnopernicus_speakers_backup = 
		    spconf_gnopernicus_speakers_clone (gnopernicus_speakers);			   
	    speakers_parameters_backup  =
		    spconf_speaker_parameters_clone (speakers_parameters);
	}
        break;
	case GTK_RESPONSE_HELP: 
	    gn_load_help ("gnopernicus-speech-settings");
	break;
	default:
	    gtk_widget_hide ((GtkWidget*)dialog);
        break;
    }
}


static void
spui_voice_test_clicked (GtkWidget *widget,
			 gpointer  user_data)
{
    GtkTreeModel     *model;
    GtkTreeSelection *selection;
    GtkTreeIter	     iter;
    
    model 	  = gtk_tree_view_get_model 	( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));
    selection     = gtk_tree_view_get_selection ( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));

    if (!gtk_tree_selection_get_selected (selection, NULL, &iter))
	return;
    
    if (GTK_IS_LIST_STORE (model))
    {
        gchar *gnop_speak;
        gtk_tree_model_get (model, 	&iter,
    			    VOICE_GNOPERNICUS_SPEAKER, &gnop_speak,
                    	    -1);
	if (!gnop_speak)
	    return;
	    
	spconf_play_voice (gnop_speak);
	g_free (gnop_speak);
    }
    
}


void
spui_modify_column_value (gchar *key, SpeakerSettings *value)
{
    gboolean valid;
    GtkTreeModel     *model;
    GtkTreeIter	     iter;
    
    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));

    valid = gtk_tree_model_get_iter_first ( model, &iter );
    
    while (valid)
    {
	if (GTK_IS_LIST_STORE (model))
	{
	    gchar *ikey = NULL;
	    gtk_tree_model_get (model, 	&iter,
				VOICE_GNOPERNICUS_SPEAKER, &ikey,
                    		-1);
	    if (!strcmp (ikey, key))
	    {
		g_free (ikey);
		break;
	    }
	    g_free (ikey);
	}
	valid = gtk_tree_model_iter_next (model, &iter);
    }
    
    if (valid)
    {
	gtk_list_store_set ( GTK_LIST_STORE (model), &iter, 
			    VOICE_GNOME_SPEAK_SPEAKER,  value->gs_speaker,
			    VOICE_VOLUME,		value->volume,
			    VOICE_RATE,			value->rate,
			    VOICE_PITCH,		value->pitch,
		    	    -1);
    }
}


static void
spui_add_elem_in_table (GtkListStore *store)
{
    SpeakerParameterType *elem = NULL;
    GtkTreeIter iter;
    
    for (elem = speakers_parameters; elem ; elem = elem->next)
    {
	SpeakerSettings *item = (SpeakerSettings*)elem->data;
	if (!item)
	    continue;
	gtk_list_store_append ( GTK_LIST_STORE (store), &iter);
	gtk_list_store_set ( GTK_LIST_STORE (store), &iter, 
			    VOICE_GNOPERNICUS_SPEAKER,	(gchar*)item->gnopernicus_speaker,
			    VOICE_GNOME_SPEAK_SPEAKER,  (gchar*)item->gs_speaker,
			    VOICE_VOLUME,		item->volume,
			    VOICE_RATE,			item->rate,
			    VOICE_PITCH,		item->pitch,
		    	    -1);
    }    
}

static GtkTreeModel*
spui_create_model (void)
{
    GtkListStore *store;      
    store = gtk_list_store_new (VOICE_NO_COLUMN, 
				G_TYPE_STRING,
				G_TYPE_STRING,
				G_TYPE_INT,
				G_TYPE_INT,
				G_TYPE_INT);
    spui_add_elem_in_table (store);
    return GTK_TREE_MODEL (store) ;
}


static void
spui_set_voice_handlers  (GladeXML *xml)
{
    GtkTreeModel 	*model;
    GtkCellRenderer 	*cell_renderer;
    GtkTreeSelection 	*selection;
    GtkTreeViewColumn 	*column;

    spui_speech_voice.w_speech_voice = glade_xml_get_widget (xml, "w_sp_voice");
    spui_speech_voice.tv_voice_table = glade_xml_get_widget (xml, "tv_voice_table");
    
    g_signal_connect (spui_speech_voice.w_speech_voice, "response",
		      G_CALLBACK (spui_voice_settings_response), NULL);
    g_signal_connect (spui_speech_voice.w_speech_voice, "delete_event",
                      G_CALLBACK (spui_delete_emit_response_cancel), NULL);

    glade_xml_signal_connect_data (xml,"on_bt_voice_add_clicked",	
			    GTK_SIGNAL_FUNC (spui_voice_add),
			    (gpointer)"ADD");

    glade_xml_signal_connect_data (xml,"on_bt_voice_modify_clicked",	
			    GTK_SIGNAL_FUNC (spui_voice_modify),
			    (gpointer)"MODIFY");

    glade_xml_signal_connect (xml,"on_bt_voice_remove_clicked",	
			    GTK_SIGNAL_FUNC (spui_voice_remove));

    glade_xml_signal_connect (xml, "on_bt_add_mod_voice_test_clicked",			
			     GTK_SIGNAL_FUNC (spui_voice_test_clicked));
    
    model = spui_create_model ();
                
    gtk_tree_view_set_model (GTK_TREE_VIEW (spui_speech_voice.tv_voice_table), model);

    
    gtk_tree_sortable_set_sort_column_id ( GTK_TREE_SORTABLE (model), 
					    VOICE_GNOPERNICUS_SPEAKER, 
					    GTK_SORT_ASCENDING);

    g_signal_connect (spui_speech_voice.tv_voice_table, "row_activated", 
		      G_CALLBACK (spui_row_activated_cb), model);					        

    cell_renderer = gtk_cell_renderer_text_new ();
    
    column = gtk_tree_view_column_new_with_attributes   (_("Gnopernicus"),
    							cell_renderer,
							"text", VOICE_GNOPERNICUS_SPEAKER,
							NULL);	
    gtk_tree_view_column_set_sort_column_id (column, VOICE_GNOPERNICUS_SPEAKER);
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (spui_speech_voice.tv_voice_table), column);
    
    column = gtk_tree_view_column_new_with_attributes   (_("Speakers"),
    							cell_renderer,
							"text", VOICE_GNOME_SPEAK_SPEAKER,
							NULL);	
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (spui_speech_voice.tv_voice_table), column);

    column = gtk_tree_view_column_new_with_attributes   (_("Volume"),
    							cell_renderer,
							"text", VOICE_VOLUME,
							NULL);	
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (spui_speech_voice.tv_voice_table), column);

    column = gtk_tree_view_column_new_with_attributes   (_("Rate"),
    							cell_renderer,
							"text", VOICE_RATE,
							NULL);	
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (spui_speech_voice.tv_voice_table), column);

    column = gtk_tree_view_column_new_with_attributes   (_("Pitch"),
    							cell_renderer,
							"text", VOICE_PITCH,
							NULL);	
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (spui_speech_voice.tv_voice_table), column);
    
    g_object_unref (G_OBJECT (model));
    
    selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table));
    gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);    

}

static gboolean 
spui_load_speech_voice_settings (GtkWidget *parent_window)
{    
    gnopernicus_speakers = 
	spconf_gnopernicus_speakers_load (gnopernicus_speakers);			   
    speakers_parameters  =
	spconf_speaker_parameters_get ();
    gnopernicus_speakers_backup = 
	spconf_gnopernicus_speakers_clone (gnopernicus_speakers);			   
    speakers_parameters_backup  =
	spconf_speaker_parameters_clone (speakers_parameters);
    
    if (!spui_speech_voice.w_speech_voice)
    {
	GladeXML *xml;
	xml = gn_load_interface ("Speech_Settings/speech_settings.glade2", "w_sp_voice");
	sru_return_val_if_fail (xml, FALSE);
	spui_set_voice_handlers  (xml);
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for ( GTK_WINDOW (spui_speech_voice.w_speech_voice),
				           GTK_WINDOW (parent_window));
	gtk_window_set_destroy_with_parent ( GTK_WINDOW (spui_speech_voice.w_speech_voice), 
					         TRUE);
    }
    else
    {
	GtkTreeModel *model;
	model = gtk_tree_view_get_model ( GTK_TREE_VIEW (spui_speech_voice.tv_voice_table) );
	gtk_list_store_clear (GTK_LIST_STORE (model));
	spui_add_elem_in_table (GTK_LIST_STORE (model));
	gtk_widget_show (spui_speech_voice.w_speech_voice);
    }
                
    return TRUE;
}


static void
spui_apply_sensitivity (gboolean state)
{
    speech_changed = state;
}
/*******************************DICTIONARY***********************************/

static void
spui_dictionary_add_modify_set_value (void)
{
    gchar *word    = (gchar*) gtk_entry_get_text (GTK_ENTRY (spui_speech_dictionary.et_word));
    gchar *replace = (gchar*) gtk_entry_get_text (GTK_ENTRY (spui_speech_dictionary.et_replace));

    if (word && strlen (word) > 0 &&
        replace && strlen (replace) > 0)
    {
	GtkTreeModel     *model;
	model = gtk_tree_view_get_model ( GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));

	if (new_item)
	{
    	    dictionary_list =	
    		spconf_dictionary_add_word (dictionary_list,
					    word, replace);
	}
	else
	{
	    dictionary_list =	
		spconf_dictionary_modify_word (dictionary_list,
			    			word, replace);
	}			
	gtk_list_store_set (GTK_LIST_STORE (model), 	 &curr_iter, 
			    SPEECH_DICTIONARY_WORD,	 (gchar*)word,
			    SPEECH_DICTIONARY_REPLACER,  (gchar*)replace,
		    	    -1);
    }

}
static void
spui_dictionary_add_modify_response (GtkDialog *dialog,
				    gint       response_id,
				    gpointer   user_data)
{
    switch (response_id)
    { 
	case GTK_RESPONSE_OK:
	    spui_dictionary_add_modify_set_value ();
	    break;
	case GTK_RESPONSE_CANCEL:
	{
    	    GtkTreeModel     *model;
	    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));

	    if (new_item)
		gtk_list_store_remove ( GTK_LIST_STORE (model), &curr_iter);
	}
	break;
	case GTK_RESPONSE_HELP:
    	    gn_load_help ("gnopernicus-speech-settings");
	    return;
	break;
	default:
	break;
    }
    gtk_widget_hide ((GtkWidget*)dialog);
}

static void
spui_set_dictionary_add_modify_handlers (GladeXML *xml)
{
    spui_speech_dictionary.w_dict_add_modify = glade_xml_get_widget (xml, "w_dict_add_modify");
    spui_speech_dictionary.et_word = glade_xml_get_widget (xml, "et_word"); 
    spui_speech_dictionary.et_replace = glade_xml_get_widget (xml, "et_replace"); 
        
    g_signal_connect (spui_speech_dictionary.w_dict_add_modify, "response",
		      G_CALLBACK (spui_dictionary_add_modify_response), NULL);
    g_signal_connect (spui_speech_dictionary.w_dict_add_modify, "delete_event",
                      G_CALLBACK (spui_delete_emit_response_cancel), NULL);

}

static void
spui_dictionary_value_add_to_widgets (void)
{
    GtkTreeModel     *model;
    gchar *word = NULL;
    gchar *replacer = NULL;
    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));
    gtk_tree_model_get (model, 	&curr_iter,
			SPEECH_DICTIONARY_WORD, &word,
			SPEECH_DICTIONARY_REPLACER, &replacer,
                    	-1);

    gtk_entry_set_text (GTK_ENTRY (spui_speech_dictionary.et_word), STR(word));
    gtk_entry_set_text (GTK_ENTRY (spui_speech_dictionary.et_replace), STR(replacer));

    g_free (word);
    g_free (replacer);
}

static gboolean 
spui_load_dictionary_add_modify (GtkWidget *parent_window)
{
    if (!spui_speech_dictionary.w_dict_add_modify)
    {
	GladeXML *xml;
	xml = gn_load_interface ("Speech_Settings/speech_settings.glade2", "w_dict_add_modify");
	sru_return_val_if_fail (xml, FALSE);
	spui_set_dictionary_add_modify_handlers (xml);
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for ( GTK_WINDOW (spui_speech_dictionary.w_dict_add_modify),
				           GTK_WINDOW (parent_window));
				    
	gtk_window_set_destroy_with_parent ( GTK_WINDOW (spui_speech_dictionary.w_dict_add_modify), 
					         TRUE);
    }
    else
	gtk_widget_show (spui_speech_dictionary.w_dict_add_modify);
    
    spui_dictionary_value_add_to_widgets ();
    
    return TRUE;
}


static void
spui_dictionary_response (GtkDialog *dialog,
			  gint       response_id,
			  gpointer   user_data)
{
    switch (response_id)
    {
	case GTK_RESPONSE_OK:
	{
    	    spconf_dictionary_save (dictionary_list);
	    break;
	}
	case GTK_RESPONSE_CANCEL:
	{
	    dictionary_list =	
		spconf_dictionary_free (dictionary_list);
	    break;
	}
	case GTK_RESPONSE_HELP:
	{
	    gn_load_help ("gnopernicus-speech-settings");
	    return;
	}
	default:
	break;
    }
    gtk_widget_hide ((GtkWidget*)dialog);    
}

static void
spui_dict_add (GtkWidget *widget,
		gpointer data)
{
    GtkTreeModel     *model;
    GtkTreeSelection *selection;    
    selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));
    model     = gtk_tree_view_get_model ( GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));
    new_item  = TRUE;
    gtk_list_store_append ( GTK_LIST_STORE (model), &curr_iter);
    gtk_tree_selection_select_iter (selection, &curr_iter);
    spui_load_dictionary_add_modify (spui_speech_dictionary.w_dictionary);
}

static void
spui_dict_modify (GtkWidget *widget,
		gpointer data)
{
    GtkTreeIter	     iter;
    GtkTreeSelection *selection;    
    selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));
    
    if (!gtk_tree_selection_get_selected (selection, NULL, &iter))
	return;
	
    curr_iter = iter;
    new_item = FALSE;
    spui_load_dictionary_add_modify (spui_speech_dictionary.w_dictionary);
}

static void
spui_dict_remove (GtkWidget *widget,
		gpointer data)
{
    GtkTreeModel     *model = NULL;
    GtkTreeIter	     iter;
    GtkTreeSelection *selection = NULL;    
    selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));
    model     = gtk_tree_view_get_model (GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));
    
    if (gtk_tree_selection_get_selected (selection, NULL, &iter))
    {
	gchar *word = NULL;
	gtk_tree_model_get (model, &iter,
			    SPEECH_DICTIONARY_WORD, &word,
                    	    -1);
	dictionary_list =	
	    spconf_dictionary_remove_word (dictionary_list, word);
	gtk_list_store_remove ( GTK_LIST_STORE (model), &iter);
	g_free (word);
    }
}

static void
spui_dictionary_row_activated_cb (GtkTreeView       *tree_view,
            	    		  GtkTreePath       *path,
		    		  GtkTreeViewColumn *column)
{
    GtkTreeIter	     iter;
    GtkTreeSelection *selection;    
    selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW (tree_view));
    
    if (!gtk_tree_selection_get_selected (selection, NULL, &iter))
	return;
	
    curr_iter = iter;
    new_item = FALSE;
    spui_load_dictionary_add_modify (spui_speech_dictionary.w_dictionary);
}

static void
spui_fill_table (GtkListStore *store)
{
    DictionaryListType* elem = NULL;
    GtkTreeIter  iter;
    
    for (elem = dictionary_list; elem ; elem = elem->next)
    {
	gchar *word = NULL;
	gchar *replace = NULL;
	spconf_dictionary_split_entry ((gchar*)elem->data, &word, &replace);

	gtk_list_store_append ( GTK_LIST_STORE (store), &iter);
	gtk_list_store_set ( GTK_LIST_STORE (store), &iter, 
			    SPEECH_DICTIONARY_WORD,	(gchar*)word,
			    SPEECH_DICTIONARY_REPLACER,  (gchar*)replace,
		    	    -1);
	g_free (word);
	g_free (replace);
    }
}

static GtkTreeModel*
spui_create_dictionary_model (void)
{
    GtkListStore *store;
    store = gtk_list_store_new (SPEECH_DICTIONARY_NO_COLUMN, 
				G_TYPE_STRING,
				G_TYPE_STRING);

    spui_fill_table (store);
    return GTK_TREE_MODEL (store) ;
}


static void
spui_set_dictionary_handlers (GladeXML *xml)
{
    GtkTreeModel 	*model;
    GtkCellRenderer 	*cell_renderer;
    GtkTreeSelection 	*selection;
    GtkTreeViewColumn 	*column;

    spui_speech_dictionary.w_dictionary = glade_xml_get_widget (xml, "w_dictionary");
    spui_speech_dictionary.tv_dictionary = glade_xml_get_widget (xml, "tv_dictionary");
    
    g_signal_connect (spui_speech_dictionary.w_dictionary, "response",
		      G_CALLBACK (spui_dictionary_response), NULL);
    g_signal_connect (spui_speech_dictionary.w_dictionary, "delete_event",
                      G_CALLBACK (spui_delete_emit_response_cancel), NULL);

    glade_xml_signal_connect (xml,"on_bt_dict_add_clicked",			
			     GTK_SIGNAL_FUNC (spui_dict_add));

    glade_xml_signal_connect (xml,"on_bt_dict_modify_clicked",			
			     GTK_SIGNAL_FUNC (spui_dict_modify));

    glade_xml_signal_connect (xml,"on_bt_dict_remove_clicked",			
			     GTK_SIGNAL_FUNC (spui_dict_remove));

    glade_xml_signal_connect (xml,"on_et_word_selected_activate",			
			     GTK_SIGNAL_FUNC (spui_dict_modify));


    model = spui_create_dictionary_model ();
                
    gtk_tree_view_set_model (GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary), model);

    
    gtk_tree_sortable_set_sort_column_id ( GTK_TREE_SORTABLE (model), 
					    SPEECH_DICTIONARY_WORD, 
					    GTK_SORT_ASCENDING);

    g_signal_connect (spui_speech_dictionary.tv_dictionary, "row_activated", 
		      G_CALLBACK (spui_dictionary_row_activated_cb), model);					        

    cell_renderer = gtk_cell_renderer_text_new ();
    
    column = gtk_tree_view_column_new_with_attributes   (_("Word"),
    							cell_renderer,
							"text", SPEECH_DICTIONARY_WORD,
							NULL);	
    gtk_tree_view_column_set_sort_column_id (column, SPEECH_DICTIONARY_WORD);
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary), column);
    
    column = gtk_tree_view_column_new_with_attributes   (_("Replacer"),
    							cell_renderer,
							"text", SPEECH_DICTIONARY_REPLACER,
							NULL);	
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary), column);

    g_object_unref (G_OBJECT (model));
    
    selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));
    gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);    

}

gboolean 
spui_load_dictionary (GtkWidget *parent_window)
{
    if (!dictionary_list)
    {
	dictionary_list =
	    spconf_dictionary_load ();
    }
    
    if (!spui_speech_dictionary.w_dictionary)
    {
	GladeXML *xml;
	xml = gn_load_interface ("Speech_Settings/speech_settings.glade2", "w_dictionary");
	sru_return_val_if_fail (xml, FALSE);
	spui_set_dictionary_handlers (xml);
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for ( GTK_WINDOW (spui_speech_dictionary.w_dictionary),
				           GTK_WINDOW (parent_window));
	gtk_window_set_destroy_with_parent ( GTK_WINDOW (spui_speech_dictionary.w_dictionary), 
					         TRUE);
    }
    else
    {
	GtkTreeModel *model;
	model = gtk_tree_view_get_model (GTK_TREE_VIEW (spui_speech_dictionary.tv_dictionary));
	gtk_list_store_clear (GTK_LIST_STORE (model));
	spui_fill_table (GTK_LIST_STORE (model));
	gtk_widget_show (spui_speech_dictionary.w_dictionary);
    }
    
    return TRUE;
}

/*******************************SPEECH SETTINGS******************************/

static void
spui_voices_settings (GtkWidget *widget,
		      gpointer	user_data)
{
    spui_load_speech_voice_settings ((GtkWidget*)spui_speech_settings.w_speech_settings);    
}

static void
spui_dictionary (GtkWidget *widget,
		gpointer	user_data)
{
    spui_load_dictionary ((GtkWidget*)spui_speech_settings.w_speech_settings);    
}

void 
spui_speech_setting_changing ()
{
    gint iter;
    
    if (!speech_setting) 
	return;
	
    for (iter = PUNCTUATION_IGNORE ; iter < PUNCTUATION_NUMBER ; iter++)
    {
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(spui_speech_settings.rb_punctuation[iter])) && 
	    strcmp (speech_setting->punctuation_type, punct_keys[iter]))
	{
	    g_free(speech_setting->punctuation_type);
	    speech_setting->punctuation_type = g_strdup (punct_keys[iter]);
	    spconf_punctuation_set (speech_setting->punctuation_type);
	    break;
	}
    }

    for (iter = TEXT_ECHO_CHARACTER ; iter < TEXT_ECHO_NUMBER ; iter++)
    {
	if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON(spui_speech_settings.rb_text_echo[iter])) && 
	    strcmp (speech_setting->text_echo_type, text_echo_keys[iter]))
	{
	    g_free(speech_setting->text_echo_type);
	    speech_setting->text_echo_type = g_strdup (text_echo_keys[iter]);
	    spconf_text_echo_set (speech_setting->text_echo_type);
	    break;
	}
    }

    g_free (speech_setting->modifiers_type);
    g_free (speech_setting->cursors_type);
    g_free (speech_setting->spaces_type);
    g_free (speech_setting->count_type);
    g_free (speech_setting->dictionary);
    
    speech_setting->modifiers_type = 
	g_strdup (common_keys [gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (spui_speech_settings.ck_modifiers))]);
    spconf_modifiers_set (speech_setting->modifiers_type);		  

    speech_setting->cursors_type = 
	g_strdup (common_keys [gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (spui_speech_settings.ck_cursors))]);
    spconf_cursors_set (speech_setting->cursors_type);		  

    speech_setting->spaces_type = 
	g_strdup (common_keys [gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (spui_speech_settings.ck_spaces))]);
    spconf_spaces_set (speech_setting->spaces_type);		  

    speech_setting->dictionary = 
	g_strdup (dictionary_keys [gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (spui_speech_settings.ck_dictionary))]);
    spconf_dictionary_set (speech_setting->dictionary);		  

    speech_setting->count_type = 
	g_strdup (common_keys [gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (spui_speech_settings.ck_count))]);
    spconf_count_set (speech_setting->count_type);		  
}

static void
spui_state_changed (GtkWidget	*widget,
		    gpointer	data)
{
    spui_apply_sensitivity (TRUE);
}

static void
spui_dictionary_toggled (GtkWidget *widget,
			gpointer data)
{
    spui_apply_sensitivity (TRUE);
    gtk_widget_set_sensitive (spui_speech_settings.bt_dictionary,
    				gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (widget)));
}

void
spui_settings_response (GtkDialog *dialog,
			gint       response_id,
			gpointer   user_data)
{
    switch (response_id)
    {
     case GTK_RESPONSE_OK: 
        {
	    if (speech_changed)
    		spui_speech_setting_changing ();
	    gtk_widget_hide ((GtkWidget*)dialog);
	}
        break;
     case GTK_RESPONSE_APPLY:
    	    spui_speech_setting_changing ();
	    spui_apply_sensitivity (FALSE);
        break;
     case GTK_RESPONSE_HELP:
	    gn_load_help ("gnopernicus-speech-settings");
	break;
     default:
	    gtk_widget_hide ((GtkWidget*)dialog);
        break;
    }
}

/**
 *
 * Set event handlers and get a widgets used in this interface.
 * xml - glade interface XML pointer
 *
**/
void 
spui_set_handlers (GladeXML *xml)
{    
    spui_speech_settings.w_speech_settings 	= glade_xml_get_widget (xml, "w_sp_settings");

    spui_speech_settings.rb_punctuation [PUNCTUATION_IGNORE]	= glade_xml_get_widget (xml, "rb_punct_ignore"); 
    spui_speech_settings.rb_punctuation [PUNCTUATION_SAME]	= glade_xml_get_widget (xml, "rb_punct_same"); 
    spui_speech_settings.rb_punctuation [PUNCTUATION_MOST]	= glade_xml_get_widget (xml, "rb_punct_most"); 
    spui_speech_settings.rb_punctuation [PUNCTUATION_ALL]	= glade_xml_get_widget (xml, "rb_punct_all"); 

    spui_speech_settings.rb_text_echo [TEXT_ECHO_CHARACTER]	= glade_xml_get_widget (xml, "rb_techo_character"); 
    spui_speech_settings.rb_text_echo [TEXT_ECHO_WORD]	= glade_xml_get_widget (xml, "rb_techo_word"); 

    spui_speech_settings.ck_modifiers 	= glade_xml_get_widget (xml, "ck_modifiers"); 
    spui_speech_settings.ck_cursors 		= glade_xml_get_widget (xml, "ck_cursors"); 
    spui_speech_settings.ck_spaces 		= glade_xml_get_widget (xml, "ck_spaces"); 
    spui_speech_settings.ck_count 		= glade_xml_get_widget (xml, "ck_count"); 
    spui_speech_settings.ck_dictionary	= glade_xml_get_widget (xml, "ck_dictionary"); 
    spui_speech_settings.bt_dictionary	= glade_xml_get_widget (xml, "bt_dictionary"); 

    g_signal_connect (spui_speech_settings.w_speech_settings, "response",
		      G_CALLBACK (spui_settings_response), NULL);
    g_signal_connect (spui_speech_settings.w_speech_settings, "delete_event",
                      G_CALLBACK (spui_delete_emit_response_cancel), NULL);

    
    glade_xml_signal_connect_data (xml,"on_ck_count_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed), 
			    (gpointer)FALSE);

    glade_xml_signal_connect_data (xml,"on_bt_voices_clicked",			
			    GTK_SIGNAL_FUNC (spui_voices_settings),
			    (gpointer)spui_speech_settings.w_speech_settings);

    glade_xml_signal_connect_data (xml,"on_bt_dictionary_clicked",			
			    GTK_SIGNAL_FUNC (spui_dictionary),
			    (gpointer)spui_speech_settings.w_speech_settings);
			    
    glade_xml_signal_connect (xml,"on_rb_punct_ignore_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed));
    glade_xml_signal_connect (xml,"on_rb_punct_same_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed));
    glade_xml_signal_connect (xml,"on_rb_punct_most_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed));
    glade_xml_signal_connect (xml,"on_rb_punct_all_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed));

    glade_xml_signal_connect (xml,"on_rb_techo_character_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed));
    glade_xml_signal_connect (xml,"on_rb_techo_word_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed));
    glade_xml_signal_connect (xml,"on_ck_modifiers_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed));
    glade_xml_signal_connect (xml,"on_ck_dictionary_toggled",			
			    GTK_SIGNAL_FUNC (spui_dictionary_toggled));
    glade_xml_signal_connect (xml,"on_ck_cursors_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed));
    glade_xml_signal_connect (xml,"on_ck_spaces_toggled",			
			    GTK_SIGNAL_FUNC (spui_state_changed));

}

/**
 *
 * Speech option user interface loader function
 *
**/
gboolean 
spui_load_speech_settings (GtkWidget *parent_window)
{
    if (!spui_speech_settings.w_speech_settings)
    {
	GladeXML *xml;
	xml = gn_load_interface ("Speech_Settings/speech_settings.glade2", "w_sp_settings");
	sru_return_val_if_fail (xml, FALSE);
	spui_set_handlers  (xml);
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for ( GTK_WINDOW (spui_speech_settings.w_speech_settings),
				           GTK_WINDOW (parent_window));
				    
	gtk_window_set_destroy_with_parent ( GTK_WINDOW (spui_speech_settings.w_speech_settings), 
					         TRUE);
    }
    else
	gtk_widget_show (spui_speech_settings.w_speech_settings);
    
    spui_speech_setting_value_add_to_widgets (speech_setting);    
    
    spui_apply_sensitivity (FALSE);
                
    return TRUE;
}

/**
 *
 * Set the widgets with a current value.
 *
**/
gboolean
spui_speech_setting_value_add_to_widgets (Speech *speech_setting)
{    
    gint iter;
    if (!spui_speech_settings.w_speech_settings ||
	!speech_setting) 
	return FALSE;
            
    for (iter = PUNCTUATION_IGNORE ; iter < PUNCTUATION_NUMBER ; iter++)
    {
	if (!strcmp (punct_keys[iter], speech_setting->punctuation_type))
	{
	    gtk_toggle_button_set_active (  GTK_TOGGLE_BUTTON 
					    (spui_speech_settings.rb_punctuation [iter]), 
					    TRUE);
	    break;
	}
    }

    for (iter = TEXT_ECHO_CHARACTER ; iter < TEXT_ECHO_NUMBER ; iter++)
    {
	if (!strcmp (text_echo_keys[iter], speech_setting->text_echo_type))
	{
	    gtk_toggle_button_set_active (  GTK_TOGGLE_BUTTON 
					    (spui_speech_settings.rb_text_echo [iter]), 
					    TRUE);
	    break;
	}
    }

    gtk_toggle_button_set_active (  GTK_TOGGLE_BUTTON (spui_speech_settings.ck_count), 
				    !strcmp ("ALL", speech_setting->count_type)
				  );
    gtk_toggle_button_set_active (  GTK_TOGGLE_BUTTON (spui_speech_settings.ck_modifiers), 
				    !strcmp ("ALL", speech_setting->modifiers_type)
				  );
    gtk_toggle_button_set_active (  GTK_TOGGLE_BUTTON (spui_speech_settings.ck_cursors), 
				    !strcmp ("ALL", speech_setting->cursors_type)
				  );
    gtk_toggle_button_set_active (  GTK_TOGGLE_BUTTON (spui_speech_settings.ck_spaces), 
				    !strcmp ("ALL", speech_setting->spaces_type)
				  );

    gtk_toggle_button_set_active (  GTK_TOGGLE_BUTTON (spui_speech_settings.ck_dictionary), 
				    !strcmp ("YES", speech_setting->dictionary)
				  );

    gtk_widget_set_sensitive (spui_speech_settings.bt_dictionary,
    			    gtk_toggle_button_get_active ( 
			    GTK_TOGGLE_BUTTON (spui_speech_settings.ck_dictionary)));

    return TRUE;
}
