/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GALEON_TAB_H
#define GALEON_TAB_H

#ifdef __cplusplus
extern "C" {
#endif

#include "galeon-embed.h"

#include <glib-object.h>

typedef struct GaleonTabClass GaleonTabClass;

#define GALEON_TAB_TYPE             (galeon_tab_get_type ())
#define GALEON_TAB(obj)             (GTK_CHECK_CAST ((obj), GALEON_TAB_TYPE, GaleonTab))
#define GALEON_TAB_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), GALEON_TAB, GaleonTabClass))
#define IS_GALEON_TAB(obj)          (GTK_CHECK_TYPE ((obj), GALEON_TAB_TYPE))
#define IS_GALEON_TAB_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), GALEON_TAB))

typedef struct GaleonTab GaleonTab;
typedef struct GaleonTabPrivate GaleonTabPrivate;

typedef enum 
{
	TAB_CONTROL_TITLE
} TabControlID;

typedef enum
{
	TAB_LOAD_NONE,
	TAB_LOAD_STARTED,
	TAB_LOAD_COMPLETED
} TabLoadStatus;

struct GaleonTab 
{
        GObject parent;
        GaleonTabPrivate *priv;
};

struct GaleonTabClass
{
        GObjectClass parent_class;
};

/* Include the header down here to resolve circular dependency */
#include "galeon-window.h"

GType         galeon_tab_get_type     		(void);

GaleonTab    *galeon_tab_new          		(void);

GaleonEmbed  *galeon_tab_get_embed    		(GaleonTab *tab);

void          galeon_tab_set_window   		(GaleonTab *tab, 
						 GaleonWindow *window);

GaleonWindow *galeon_tab_get_window   		(GaleonTab *tab);

void	      galeon_tab_set_is_active 		(GaleonTab *tab, 
						 gboolean is_active);

gboolean      galeon_tab_get_is_active 		(GaleonTab *tab);

gboolean      galeon_tab_get_visibility         (GaleonTab *tab);

TabLoadStatus galeon_tab_get_load_status     	(GaleonTab *tab);

int	      galeon_tab_get_load_percent 	(GaleonTab *tab);

const char   *galeon_tab_get_status_message  	(GaleonTab *tab);

const char   *galeon_tab_get_title		(GaleonTab *tab);

const char   *galeon_tab_get_location           (GaleonTab *tab);

void	      galeon_tab_set_location           (GaleonTab *tab,
						 char *location);

void	      galeon_tab_get_size		(GaleonTab *tab,
						 int *width,
						 int *height);

void	      galeon_tab_update_control		(GaleonTab *tab,
						 TabControlID id);

#ifdef __cplusplus
}
#endif
#endif
