/*
 * GNOME-MAG Magnification service for GNOME
 *
 * Copyright 2006 Carlos Eduardo Rodrigues Digenes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_XFIXES
#include <X11/extensions/Xfixes.h>
#ifdef HAVE_DAMAGE
#include <X11/extensions/Xdamage.h>
#ifdef HAVE_COMPOSITE
#include <X11/extensions/Xrender.h>
#endif /* HAVE_COMPOSITE */
#endif /* HAVE_DAMAGE */
#endif /* HAVE_XFIXES */

#include "magnifier.h"

typedef struct _GmagWin {
	Window            xwin;
#ifdef HAVE_XFIXES
#ifdef HAVE_DAMAGE
	Damage            damage;
	gboolean          damaged;
#ifdef HAVE_COMPOSITE
	Picture           pic;
#endif /* HAVE_COMPOSITE */
#endif /* HAVE_DAMAGE */
	XWindowAttributes attr;
	XserverRegion     clip;
	XserverRegion     win_region;
	XserverRegion     damaged_region;
#endif /* HAVE_XFIXES */
} GmagWin, *GmagWinPtr;

void       gmag_events_client_init (Magnifier *magnifier);
GdkPixbuf *gmag_events_get_source_pixbuf (Magnifier *magnifier);
gboolean   gmag_events_source_has_damage_extension (Magnifier *magnifier);
