# Orca
#
# Copyright 2004-2006 Sun Microsystems Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

"""Provides i18n support for orca using the gettext module.  Tells
gettext where to find localized strings and creates an alias, _, that
maps to the gettext.gettext function.  This function will accept a
string and return a localized string for that string.
"""

import os       # to get localdir path
import gettext  # to get gettext (i18n) support

# Alias gettext.gettext to _
#
_ = gettext.gettext

# Tell gettext where to find localized strings.
#
localedir = os.path.join ("/usr", "share", "locale")
gettext.bindtextdomain ("orca", localedir)
gettext.textdomain("orca")

import debug

try:
    import gtk.glade

    gtk.glade.bindtextdomain ("orca", localedir)
    gtk.glade.textdomain("orca")
except:
    debug.printException(debug.LEVEL_FINEST)
