/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*-
 *
 * mapping-protocol.h - code to talk with the mapping daemon
 *
 * Copyright (C) 2002 Red Hat Inc,
 * Copyright (C) 2005 William Jon McCann <mccann@jhu.edu>
 *
 * The Gnome Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The Gnome Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Alexander Larsson <alexl@redhat.com>
 *          William Jon McCann <mccann@jhu.edu>
*/
#include <glib.h>

typedef struct {
	gint32   operation;
	char    *root;
	char    *path1;
	char    *path2;
	gboolean option;
	void    *userdata;
} MappingProtocolRequest;

typedef struct {
	guint32  result;
	char    *path;
	gboolean option;
	/* FIXME: int too small for this? */
	int      n_strings;
	char   **strings;
} MappingProtocolReply;

typedef struct {
	gint32 type;
	char  *path;
	void  *userdata;
} MappingProtocolMonitorEvent;

typedef enum {
	MAPPING_PROTOCOL_OP_GET_BACKING_FILE,
	MAPPING_PROTOCOL_OP_CREATE_DIR,
	MAPPING_PROTOCOL_OP_REMOVE_DIR,
	MAPPING_PROTOCOL_OP_REMOVE_FILE,
	MAPPING_PROTOCOL_OP_CREATE_FILE,
	MAPPING_PROTOCOL_OP_CREATE_LINK,
	MAPPING_PROTOCOL_OP_MOVE_FILE,
	MAPPING_PROTOCOL_OP_LIST_DIR,
	MAPPING_PROTOCOL_OP_MONITOR_ADD,
	MAPPING_PROTOCOL_OP_MONITOR_CANCEL,
} MappingProtocolOps;

char *mapping_protocol_get_unix_name         (void);

int   mapping_protocol_data_available        (GIOChannel                  *channel);

int   mapping_protocol_monitor_event_encode  (GIOChannel                  *channel,
					      MappingProtocolMonitorEvent *event);
int   mapping_protocol_monitor_event_decode  (GIOChannel                  *channel,
					      MappingProtocolMonitorEvent *event);
void  mapping_protocol_monitor_event_destroy (MappingProtocolMonitorEvent *event);

int   mapping_protocol_request_encode        (GIOChannel                  *channel,
					      gint32                       operation,
					      char                        *root,
					      char                        *path1,
					      char                        *path2,
					      gboolean                     option,
					      void                        *userdata);
int   mapping_protocol_request_decode        (GIOChannel                  *channel,
					      MappingProtocolRequest      *req);
void  mapping_protocol_request_destroy       (MappingProtocolRequest      *req);

int   mapping_protocol_reply_encode          (GIOChannel                  *channel,
					      MappingProtocolReply        *reply);
int   mapping_protocol_reply_decode          (GIOChannel                  *channel,
					      MappingProtocolReply        *reply);
void  mapping_protocol_reply_destroy         (MappingProtocolReply        *reply);

