/* $Id: gdict-about.c,v 1.23 2005/01/06 21:47:24 vnoel Exp $ */

/*
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *  Mike Hughes <mfh@psilord.com>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict About box
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib/gi18n.h>
#include <gtk/gtkaboutdialog.h>

#include "gdict-about.h"


GtkWidget *
gdict_about_new (void)
{
	GtkWidget *about;

	const gchar *authors[] = {
		"Mike Hughes <mfh@psilord.com>",
		"Spiros Papadimitriou <spapadim+@cs.cmu.edu>",
		"Bradford Hovinen <hovinen@udel.edu>",
		NULL
	};

	const gchar *documenters[] = {
		"Sun GNOME Documentation Team <gdocteam@sun.com>",
		"John Fleck <jfleck@inkstain.net>",
		NULL
	};

	const gchar *translator_credits = _("translator-credits");
	const gchar *copyright = "Copyright \xc2\xa9 1999-2003 Mike Hughes";
	const gchar *comments = _("A client for the MIT dictionary server.");

	about = g_object_new (GTK_TYPE_ABOUT_DIALOG,
			      "name", _("Dictionary"),
			      "version", VERSION,
			      "copyright", copyright,
			      "comments", comments,
			      "authors", authors,
			      "translator-credits", translator_credits,
			      "documenters", documenters,
			      "logo-icon-name", "gdict",
			      NULL);

	return GTK_WIDGET (about);
}

void
gdict_about (GtkWindow *parent)
{
	static GtkWidget *about = NULL;

	if (about != NULL) {
		if (parent != NULL)
			gtk_window_set_transient_for (GTK_WINDOW (about), parent);

		gtk_window_present (GTK_WINDOW (about));

		return;
	}

	about = gdict_about_new ();

	if (parent != NULL) {
		gtk_window_set_transient_for (GTK_WINDOW (about), parent);
		gtk_window_set_destroy_with_parent (GTK_WINDOW (about), TRUE);
	}

	g_signal_connect (about, "response",
			  G_CALLBACK (gtk_widget_destroy), NULL);
	g_signal_connect (about, "destroy",
			  G_CALLBACK (gtk_widget_destroyed), &about);

	gtk_window_present (GTK_WINDOW (about));
}

