/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/* 
 * Copyright (C) 2002 Thomas Vander Stichele
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Thomas Vander Stichele <thomas at apestaart dot org>
 */

/* audio-info.h - get information on files using AudioInfo object
 */

#ifndef AUDIO_INFO_H
#define AUDIO_INFO_H

#include <config.h>

typedef struct {
	gboolean have_length;
	int length;			/* in microseconds */
	int bitrate;
	int samplerate;
	int channels;

	char *file;			/* display filename */
	char *type;
	char *comment;
	char *path;			/* full uri path */
} AudioInfo;

AudioInfo *	audio_info_new 		(const char *uri);
void		audio_info_free 	(AudioInfo *info);
char *		audio_info_get_mime_type_playable 	(const char *uri);
void 		audio_info_update 	(AudioInfo *info);

#endif /* AUDIO_INFO_H */
/* struct for audio info */

