Name:		 linc
Summary:	 Network client/server library.
Version:	 0.1.19
Release:	 1
License:	 GPL
Group:		 Development/Libraries
Source:		 linc-%{version}.tar.gz
BuildRoot:	 /var/tmp/%{name}-%{version}-root
URL:		 http://www.gnome.org
Requires:	 glib2 
BuildRequires:   glib2-devel

%description 
linc is a library that eases the task of writing networked servers &
clients. It takes care of connection initiation and maintenance, and the
details of various transports. It is used by ORBit2 to handle message
transmission/receipt.

Currently supported transports:
	IPv4 (tested)
	UNIX domain sockets (tested)
	IPv6
	IrDA

The connections can optionally be encrypted using OpenSSL.

%package devel
Summary:	Network client/server library, development files.
Group:		Development/Libraries
Requires:	%{name} = %{version}

%description devel
Static libraries and header files for the linc library.

%prep
%setup -q 

%build
CFLAGS="$RPM_OPT_FLAGS"
./configure --prefix=%{_prefix} \
    --bindir=%{_bindir} --mandir=%{_mandir} \
    --libdir=%{_libdir} --datadir=%{_datadir} \
    --includedir=%{_includedir} --sysconfdir=%{_sysconfdir}
make

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{_prefix} bindir=$RPM_BUILD_ROOT%{_bindir} \
    mandir=$RPM_BUILD_ROOT%{_mandir} libdir=$RPM_BUILD_ROOT%{_libdir} \
    datadir=$RPM_BUILD_ROOT%{_datadir} \
    includedir=$RPM_BUILD_ROOT%{_includedir} \
    sysconfdir=$RPM_BUILD_ROOT%{_sysconfdir} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files 
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README
%{_libdir}/lib*.so.*

%files devel
%defattr(-, root, root)
%{_libdir}/lib*.so
%{_libdir}/*a
%{_libdir}/pkgconfig/*.pc
%{_includedir}/linc-1.0
%{_datadir}/aclocal/*
%{_bindir}/*

%changelog
* Wed Oct 10 2001 Abel Cheung <maddog@linux.org.hk>
- Move header to subdir

* Mon Sep 24 2001 Mark McLoughlin <mark@skynet.ie>
- use LINC_VERSION instead of VERSION

* Tue Sep 18 2001 Jens Finke <jens@gnome.org>
- Created initial spec file.
