/*
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean & Jochen Friedrich
 * Beholder RMON ethernet network monitor,Copyright (C) 1993 DNPAP group
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef _G_AUTH_H_
#define _G_AUTH_H_

#include "g_sha.h"
#include "g_md5.h"

/* Authentification types */
#define AUTH_COMMUNITY           1
#define AUTH_USEC                2

#define AUTH_COMLEN              255

/* Typedefs */

typedef struct  _SNMP_AUTH       SNMP_AUTH;

/* Authentication */

struct _SNMP_AUTH
{
    guint           type;
    guchar          name[AUTH_COMLEN];
    guint           nlen;
    guchar          ahash[20];
    guint           alen;
    guchar          phash[20];
    guint           plen;
};

void g_password_to_key_md5(guchar *password, guint passwordlen, guchar *key);
void g_password_to_key_sha(guchar *password, guint passwordlen, guchar *key);
void g_localize_key_md5(guchar *key, guchar *engineID, guint enginelen);
void g_localize_key_sha(guchar *key, guchar *engineID, guint enginelen);

#endif
