/*
 * $Id: sql_interface.h,v 1.5 1998/05/25 18:32:04 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330 , Cambridge, MA 02139, USA.
 *
 * Sql interface definitions/declarations.
 */
#ifndef __SQL_IO_H__
#define __SQL_IO_H__

/*
 * Structures and definitions
 */
typedef struct __sql_server__ {
  char      *sql_host;
  char      *sql_user;
  char      *sql_pass;
} sql_server;

/*
 * Global prototypes.
 */
char          *sql_server_status             (sql_server *server);
GList         *sql_db_list                   (sql_server *server);
GList         *sql_table_list                (sql_server *server);
gboolean       sql_check_db                  (sql_server *server,
					      gchar      *db);
gboolean       sql_create_db                 (sql_server *server,
					      gchar      *db);
gboolean       sql_drop_db                   (sql_server *server,
					      gchar      *db);
gboolean       sql_add_host_entry            (sql_server *server,
					      hosts      *host);
gboolean       sql_del_host_entry            (sql_server *server,
					      hosts      *host);
gboolean       sql_update_host_entry         (sql_server *server,
					      hosts      *host);
hosts         *sql_fetch_host_entry          (sql_server *server,
					      char       *hostname);
gboolean       sql_load_host_table           (void);

#endif

/* EOF */













