#include "obgtkMenuItem.h"
#include <obgtk/obgtkMenu.h>

@implementation Gtk_MenuItem
- castGtkMenuItem:(GtkMenuItem *) castitem
{
  gtkmenuitem = castitem;
  return [super castGtkItem:GTK_ITEM(castitem)];
}

- init
{
  return [self castGtkMenuItem:GTK_MENU_ITEM(gtk_menu_item_new())];
}

- initWithLabel:(gchar *) label
{
  return [self castGtkMenuItem:GTK_MENU_ITEM(gtk_menu_item_new_with_label(label))];
}

- set_submenu:(Gtk_Menu *) submenu
{
  gtk_menu_item_set_submenu(gtkmenuitem, submenu->gtkwidget);
  return self;
}

- set_placement:(GtkSubmenuPlacement) placement
{
  gtk_menu_item_set_placement(gtkmenuitem, placement);
  return self;
}

- accelerator_size
{
  gtk_menu_item_accelerator_size(gtkmenuitem);
  return self;
}

- accelerator_text:(gchar *)buffer
{
  gtk_menu_item_accelerator_text(gtkmenuitem, buffer);
  return self;
}

- configure     :(gint)show_toggle_indicator
 indicateSubmenu:(gint)show_submenu_indicator
{
  gtk_menu_item_configure(gtkmenuitem,
			  show_toggle_indicator,
			  show_submenu_indicator);
  return self;
}

- select
{
  gtk_menu_item_select(gtkmenuitem);
  return self;
}

- deselect
{
  gtk_menu_item_deselect(gtkmenuitem);
  return self;
}

- activate
{
  gtk_menu_item_activate(gtkmenuitem);
  return self;
}

- right_justify
{
  gtk_menu_item_right_justify(gtkmenuitem);
  return self;
}

@end
