/*
 * GXSNMP -- An snmp mangament application
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <time.h>
#include <stdio.h>   
#include <getopt.h>
#include <strings.h>
#include <signal.h>
#include <malloc.h>
#include <sys/socket.h>

#include "collector.h"

void read_objid(char *scanbuf, unsigned long *name, int *name_length) {
  int max;
  char *ptr, *ptr2;

  ptr2 = strdup(scanbuf);
  max = *name_length;
  *name_length = 0;
  ptr = strtok(ptr2, ".");
  while (ptr) {
    name[*name_length] = atoi(ptr);
    (*name_length) ++;
    ptr = strtok(NULL,".");
  }
  free(ptr2);
} 

void read_config() {
  FILE *inf;
  struct _host *myhost;
  struct _oid *myoid;
  char buffer[1024];
  char *scanbuf, *sb1;
  int  duration;
  unsigned long name[SNMP_SIZE_OBJECTID];  
  int  name_length;
  int  id;
  struct servent *port;
  struct hostent *hp;

  inf = fopen(cnffile,"r");
  while(fgets(buffer, sizeof(buffer), inf)) {
    switch (buffer[0]) {
      case 'H' :
        myhost = malloc(sizeof(struct _host));
        scanbuf = strtok(buffer+1, " \n");
        myhost->name = strdup(scanbuf);
        scanbuf = strtok(NULL, " \n");
        myhost->community = strdup(scanbuf);

        myhost->address.sin_family = AF_INET;
        hp = gethostbyname(myhost->name);
        bcopy((char *)hp->h_addr, (char *)&myhost->address.sin_addr, hp->h_length);
        port = getservbyname("snmp","udp");
        myhost->address.sin_port = port->s_port;
	if (debug)
          g_print ("host %s, community %s\n", myhost->name, myhost->community);
        break; 
      case 'O' :
        scanbuf = strtok(buffer+1, " ");
        duration = atoi(scanbuf);
        scanbuf = strtok(NULL, " ");
        sb1     = strtok(NULL, " ");
        name_length = SNMP_SIZE_OBJECTID;
        read_objid(scanbuf, name, &name_length);
        scanbuf = sb1;
        sb1 = strtok(scanbuf,",");
        do {
          id = atoi(sb1);
          myoid = malloc(sizeof(struct _oid));
          myoid->host = myhost;
          myoid->duration = duration;
          myoid->time = 0;
          myoid->last = 0;
          myoid->value = 0;
          memcpy(myoid->name, name, name_length*sizeof(glong));
          myoid->name_length = name_length+1;
          myoid->name[name_length] = id;
          w_queue = g_slist_append(w_queue, myoid);
        } while (sb1 = strtok(NULL, ","));
        break;
      case 'C' : 
        break;
    }
  }
}
