#include <config.h>

#include <time.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <glib.h>

#include "g_asn1.h"
#include "g_snmp.h"

#define MAX_DGRAM_SIZE 32768

struct _host {
  char               *name;
  struct sockaddr_in  address;
  char               *community;
};

struct _oid {
  unsigned long       name[SNMP_SIZE_OBJECTID];  
  int                 name_length;
  time_t              time;
  time_t              last;
  int                 type;
  long                value;
  long                duration;
  struct _host       *host;
};

struct _pdu {
  GSList             *oids;
  int                 id;
  int                 retry_count;
  time_t              time;
  char               *buffer;
  int                 length;
  struct _host       *host;
  time_t              now;
};

extern char *cnffile;
extern char *outfile;
extern int debug;
extern int pdusize;
extern int defer;
extern int timeout;
extern int retry;
extern int maxreq;
extern GSList *w_queue, *i_queue, *s_queue;
extern FILE *of;
