/*
 * $Id: snmp_host.c,v 1.21 1998/05/21 20:40:14 gregm Exp $
 * GXSNMP -- An snmp management application.
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Host panel code.  
 */
#ifdef lint
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
static char const rcsid[] =
 "$Id: snmp_host.c,v 1.21 1998/05/21 20:40:14 gregm Exp $";

#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "main.h"

/* 
 * Global Variables refrenced in this module
 */

extern gxsnmp *app_info;
extern GdkPixmap *book_open;
extern GdkPixmap *book_closed;
extern GdkBitmap *book_open_mask;
extern GdkBitmap *book_closed_mask;

/*
 * Local common varibles for all panels in this module
 */

static char *edit_labels[] = {
   N_("Hostname"),
   N_("Display Name"),
   N_("SNMP Port"),
   N_("Read Community"),
   N_("Write Community"),
   N_("Version"),
   N_("Retries"),
   N_("Timeout")
};

static char *serv_labels[] = {
  N_("Poll Rate"),
  N_("Server")
};


/*
 * Editing hosts
 */

/* Forward declarations for this panel */
static void      create_edit_panel            (void);
static void      edit_ok_button_cb            (GtkWidget       *widget,
					       gpointer        data);
static void      edit_cancel_button_cb        (GtkWidget       *widget,
					       gpointer        data);
static void      edit_entry_cb                (GtkWidget       *widget,
					       gpointer        data);
static gint      edit_panel_delete_cb         (GtkWidget       *widget,
					       GdkEvent        *e,
					       gpointer        data);

/*
 * Local variables for the edit panel
 */

static edit_host   *edit_panel = NULL;

static void
create_edit_panel ()
{
  GtkWidget  *button;
  GtkWidget  *frame;
  GtkWidget  *table;
  GtkWidget  *abox;
  GtkWidget  *vbox;
  GtkWidget  *label;
  GtkWidget  *button_box;
  GtkWidget  *bar;
  int        i;

  edit_panel = (edit_host *)g_malloc (sizeof (edit_host));
  edit_panel->window = gnome_app_new ("GXSNMP", _("Edit Host") );
  gtk_signal_connect (GTK_OBJECT (edit_panel->window),
		      "delete_event",
		      GTK_SIGNAL_FUNC (edit_panel_delete_cb),
		      NULL);
  abox = gtk_vbox_new (FALSE, 4);
  label = gtk_label_new (_("Edit a host"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.0);
  gtk_box_pack_start (GTK_BOX (abox), label, TRUE, FALSE, 0);

  frame = gtk_frame_new (NULL);
  gtk_container_border_width (GTK_CONTAINER (frame), 4);
  gtk_box_pack_start (GTK_BOX (abox), frame, TRUE, TRUE, 0);
  vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_border_width (GTK_CONTAINER (vbox), 4);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  table = gtk_table_new (ELEMENTS(edit_labels), 2, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 2);
  for (i = 0; i < ELEMENTS(edit_labels) ; i++)
    {
      label = gtk_label_new (gettext(edit_labels[i]));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_table_attach (GTK_TABLE (table), label, 0, 1, i, (i + 1),
			GTK_SHRINK | GTK_FILL, GTK_SHRINK, 1, 2);
      edit_panel->widget[i] = gtk_entry_new ();
      gtk_object_set_data (GTK_OBJECT (edit_panel->widget[i]),
				 "which_button", (int *)i);
      gtk_signal_connect (GTK_OBJECT (edit_panel->widget[i]),
			  "activate", GTK_SIGNAL_FUNC (edit_entry_cb),
			  NULL); 
      gtk_table_attach (GTK_TABLE (table), edit_panel->widget[i],
			1, 2, i, (i + 1),
			GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND, 1, 2);
    }
  gtk_widget_grab_focus ((edit_panel->widget)[0]);

  bar = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), bar, FALSE, FALSE, 0);
  button_box = gtk_hbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (button_box), 4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (button_box),
			     GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (button_box), 2);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (button_box), 85, 20);
  gtk_container_add (GTK_CONTAINER (vbox), button_box);
  
  button = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (edit_ok_button_cb),
		      NULL);
  gtk_container_add (GTK_CONTAINER (button_box), button);

  button = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (edit_cancel_button_cb),
		      NULL);
  gtk_container_add (GTK_CONTAINER (button_box), button);

  gnome_app_set_contents (GNOME_APP (edit_panel->window), abox);
  gtk_widget_show_all (edit_panel->window);
}

static void
fill_edit_panel (hosts *host)
{
  int     i;
  char    buf[512];        /* should be enough */

  if(host)
    {
      for (i = 0; i < ELEMENTS(edit_labels); i++)
	{
	  switch (i)
	    {
	    case HOST_E_NAME:
	      gtk_entry_set_text (GTK_ENTRY 
				  (edit_panel->widget[HOST_E_NAME]),
				  host->hl_snmp.name);
	      break;
	    case HOST_E_DISP:
	      gtk_entry_set_text (GTK_ENTRY 
				  (edit_panel->widget[HOST_E_DISP]),
				  host->hl_disp);
	      break;
	    case HOST_E_PORT:
	      snprintf (buf, sizeof(buf), "%d", host->hl_snmp.port);
	      gtk_entry_set_text (GTK_ENTRY 
				  (edit_panel->widget[HOST_E_PORT]),
				  buf);
	      break;
	    case HOST_E_RCOM:
	      gtk_entry_set_text (GTK_ENTRY
				  (edit_panel->widget[HOST_E_RCOM]),
				  host->hl_snmp.rcomm);
	      break;
	    case HOST_E_WCOM:
	      if (host->hl_snmp.wcomm)
		gtk_entry_set_text (GTK_ENTRY
				  (edit_panel->widget[HOST_E_WCOM]),
				  host->hl_snmp.wcomm);
	      break;
	    case HOST_E_VERS:
	      snprintf (buf, sizeof(buf), "%d", host->hl_snmp.version);
	      gtk_entry_set_text (GTK_ENTRY
				  (edit_panel->widget[HOST_E_VERS]),
				  buf);
	      break;
	    case HOST_E_RETR:
	      snprintf (buf, sizeof(buf), "%d", host->hl_snmp.retries);
	      gtk_entry_set_text (GTK_ENTRY
				  (edit_panel->widget[HOST_E_RETR]),
				  buf);
	      break;
	    case HOST_E_TIME:
	      snprintf (buf, sizeof(buf), "%d", host->hl_snmp.timeout);
	      gtk_entry_set_text (GTK_ENTRY
				  (edit_panel->widget[HOST_E_TIME]),
				  buf);
	      break;
	    }
	}
    }
}

/*
 * The callback functions
 */


static void 
edit_ok_button_cb (GtkWidget *widget, gpointer data)
{
  int   i;
  char  buf[512];
  hosts *host;

  host = get_current_host();
  if (host)
    {
      for (i = 0; i < ELEMENTS(edit_labels); i++)
	{
	  switch (i)
	    {
	    case HOST_E_NAME:
	      /*
               * What should we do here?
	       */
	      break;
	    case HOST_E_DISP:
	      host->hl_disp = g_strdup (gtk_entry_get_text (GTK_ENTRY
			      (edit_panel->widget[HOST_E_DISP])));
	      
	      gtk_host_set_label (host->widget, gtk_entry_get_text (GTK_ENTRY
				(edit_panel->widget[HOST_E_DISP])));
	      break;
	    case HOST_E_PORT:
	      host->hl_snmp.port = atoi (gtk_entry_get_text (GTK_ENTRY 
			       (edit_panel->widget[HOST_E_PORT])));
	      break;
	    case HOST_E_RCOM:
	      host->hl_snmp.rcomm = g_strdup (gtk_entry_get_text (GTK_ENTRY
                               (edit_panel->widget[HOST_E_RCOM])));
	      break;
	    case HOST_E_WCOM:
	      host->hl_snmp.wcomm = g_strdup (gtk_entry_get_text (GTK_ENTRY
			       (edit_panel->widget[HOST_E_WCOM])));
	      break;
	    case HOST_E_VERS:
	      host->hl_snmp.version = atoi (gtk_entry_get_text (GTK_ENTRY
                               (edit_panel->widget[HOST_E_VERS])));
	      break;
	    case HOST_E_RETR:
	      host->hl_snmp.retries = atoi (gtk_entry_get_text (GTK_ENTRY
			       (edit_panel->widget[HOST_E_RETR])));
	      break;
	    case HOST_E_TIME:
	      host->hl_snmp.timeout = atoi (gtk_entry_get_text (GTK_ENTRY
                               (edit_panel->widget[HOST_E_TIME])));
	      break;
	    default:
	      /* Should never happen */
	      break;
	    }
	}
    }
  hide_edit_panel ();
}

static void
edit_cancel_button_cb (GtkWidget *widget, gpointer data)
{
  hide_edit_panel ();
}

static void 
edit_entry_cb (GtkWidget *widget, gpointer data)
{
  int   which;

  which = (int)gtk_object_get_data (GTK_OBJECT (widget), "which_button");

  if ( (++which) < ELEMENTS (edit_labels))
      gtk_widget_grab_focus (edit_panel->widget[which]);
}


static gint
edit_panel_delete_cb (GtkWidget *widget, GdkEvent *e, gpointer data)
{
  destroy_edit_panel ();
  return TRUE;
}

void
add_host (hosts *entry)
{
  draw_host (NULL, entry);
  return ;
}

/*    
 * Global standard functions for the edit host panel.
 */
void 
open_edit_panel ()
{
  if (!edit_panel)
      create_edit_panel ();
  else if (!GTK_WIDGET_VISIBLE (edit_panel->window))
      gtk_widget_show (edit_panel->window);
  reset_edit_panel ();
}

void 
destroy_edit_panel ()
{
  if (edit_panel)
    {
      gtk_widget_destroy (edit_panel->window);
      g_free (edit_panel);
      edit_panel = NULL;
    }
}

void 
hide_edit_panel ()
{
  if (edit_panel)
    if (GTK_WIDGET_VISIBLE (edit_panel->window))
      gtk_widget_hide (edit_panel->window);
}

void
reset_edit_panel ()
{
  fill_edit_panel (get_current_host());
}

/*
 * Host adding panel.
 */

/*
 * Local functions  (Forward declrations)
 */
static void           create_add_host_panel           (void);
static gint           delete_add_host_panel           (GtkWidget    *widget,
						       GdkEvent     *e,
						       gpointer     data);
static void           add_host_entry_cb               (GtkWidget    *widget,
						       gpointer     data);
static void           add_host_change_cb              (GtkWidget    *widget,
						       gpointer     data);
static void           add_host_ok_cb                  (GtkWidget    *widget,
						       gpointer     data);
static void           add_host_cancel_cb              (GtkWidget    *widget,
						       gpointer     data);

/* Local variables */
static host_panel    *add_panel = NULL;

/* Global variables for this scope */

/*
 * Actual local functions
 */
static void
create_add_host_panel ()
{
  GtkWidget     *w_box;       /* The container for this panel */
  GtkWidget     *frame;
  GtkWidget     *notebook;
  GtkWidget     *table;
  GtkWidget     *label;
  GtkWidget     *bar;
  GtkWidget     *b_box;
  GtkWidget     *hbox;
  GtkWidget     *pixmap;
  GtkWidget     *tab_box;
  GtkAdjustment *adjustment;
  char          buf[20];
  int           i;

  add_panel = (host_panel *)g_malloc (sizeof (host_panel));

  add_panel->window = gnome_app_new ("GXSNMP", _("Add a new host"));
  gtk_signal_connect (GTK_OBJECT (add_panel->window),
		      "delete_event", 
		      GTK_SIGNAL_FUNC (delete_add_host_panel),
		      add_panel->window);
  /*
   * Container for this panel 
   */
  w_box = gtk_vbox_new (FALSE, 4);
  label = gtk_label_new (_("Add a new host"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.0);
  gtk_box_pack_start (GTK_BOX (w_box), label, TRUE, FALSE, 0);

  /* 
   * The notebook
   */
  notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
  gtk_signal_connect (GTK_OBJECT (notebook), "switch_page",
		      GTK_SIGNAL_FUNC (page_switch_cb), NULL);
  gtk_box_pack_start (GTK_BOX (w_box), notebook, TRUE, TRUE, 2);

  frame = gtk_frame_new (NULL);
  gtk_container_border_width (GTK_CONTAINER (frame), 4);
  table = gtk_table_new (ELEMENTS (edit_labels), 2, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), table);

  /*
   * Basic info...
   */
  for (i = 0; i < ELEMENTS(edit_labels); i++)
    {
      label = gtk_label_new (gettext(edit_labels[i]));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_table_attach (GTK_TABLE (table), label, 0, 1, i, (i+1),
			GTK_SHRINK | GTK_FILL, GTK_SHRINK, 2, 1);
      switch (i)
	{
	case HOST_E_NAME:
	case HOST_E_DISP:
	case HOST_E_RCOM:
	case HOST_E_WCOM:
	case HOST_E_PORT:
	  add_panel->entries[i] = gtk_entry_new ();
	  gtk_signal_connect (GTK_OBJECT (add_panel->entries[i]),
			      "activate", GTK_SIGNAL_FUNC (add_host_entry_cb),
			      NULL);
	  gtk_signal_connect (GTK_OBJECT (add_panel->entries[i]),
			      "changed", GTK_SIGNAL_FUNC (add_host_change_cb),
			      NULL);
	  switch (i)
	    {
	    case HOST_E_PORT:
	      snprintf (buf, sizeof(buf), "%d",
			app_info->current_config.def_snmp_port);
	      gtk_entry_set_text (GTK_ENTRY
				  (add_panel->entries[i]), buf);
	      break;
	    }
	  break;
	case HOST_E_VERS:
	  adjustment = GTK_ADJUSTMENT (gtk_adjustment_new
				       (/* FIXME */ SNMP_V1, 
					0.0, 32.0, 1.0, 1.0, 1.0));
	  add_panel->entries[i] = gtk_hscale_new (GTK_ADJUSTMENT
							     (adjustment));
	  gtk_scale_set_digits (GTK_SCALE (add_panel->entries[i]),
				0);
	  break;
	case HOST_E_RETR:
	  adjustment = GTK_ADJUSTMENT (gtk_adjustment_new 
				       (app_info->current_config.def_snmp_retr, 
					0.0, 32.0, 1.0, 1.0, 1.0));
	  add_panel->entries[i] = gtk_hscale_new (GTK_ADJUSTMENT
							     (adjustment));
	  gtk_scale_set_digits (GTK_SCALE (add_panel->entries[i]),
				0);
	  break;
	case HOST_E_TIME:
	  adjustment = GTK_ADJUSTMENT (gtk_adjustment_new 
				       (app_info->current_config.def_snmp_time, 
					0.0, 300.0, 1.0, 1.0, 1.0));
	  add_panel->entries[i] = gtk_hscale_new (GTK_ADJUSTMENT
							     (adjustment));
	  gtk_scale_set_digits (GTK_SCALE (add_panel->entries[i]),
				0);
	  break;
	default:
	  add_panel->entries[i] = gtk_entry_new ();
	  break;
	}
      gtk_object_set_data (GTK_OBJECT (add_panel->entries[i]),
			   "which_button", (int *)i);
      gtk_table_attach (GTK_TABLE (table), add_panel->entries[i],
			1, 2, i, (i + 1),
			GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK, 
			2, 1);
    }
  gtk_widget_grab_focus (add_panel->entries[HOST_E_NAME]);
  
  /*
   * The tab at the top of this page.
   */
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, 
			    notebook_tab (_("Host Information")));

  /*
   * Database info for this host.
   */
  frame = gtk_frame_new (NULL);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame,
			    notebook_tab (_("Database")));

  /*
   * Services provided by this host (dns, nntp, ftp etc..)
   */
  frame = gtk_frame_new (NULL);
  hbox = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  table = gtk_table_new (ELEMENTS (serv_labels), 2, FALSE);
  gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 1);
  for (i = 0; i < ELEMENTS (serv_labels); i++)
    {
      label = gtk_label_new (gettext (serv_labels[i]));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_table_attach (GTK_TABLE (table), label, 0, 1, i, (i + 1),
			GTK_SHRINK | GTK_FILL, GTK_SHRINK, 2, 1);
    }
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame,
			    notebook_tab (_("Host Services")));
  /*
   * Bottom of window
   */
  bar = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (w_box), bar, FALSE, FALSE, 0);
  frame = gtk_frame_new (NULL);
  gtk_container_border_width (GTK_CONTAINER (frame), 4);
  gtk_box_pack_start (GTK_BOX (w_box), frame, FALSE, FALSE, 0);
  b_box = gtk_hbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (b_box), 4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (b_box), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (b_box), 2);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (b_box), 85, 20);
  gtk_container_add (GTK_CONTAINER (frame), b_box);
  
  add_panel->buttons[HOST_OK_BUTTON] = gnome_stock_button 
    (GNOME_STOCK_BUTTON_OK);
  gtk_signal_connect (GTK_OBJECT (add_panel->buttons[HOST_OK_BUTTON]),
		      "clicked", GTK_SIGNAL_FUNC (add_host_ok_cb),
		      add_panel);
  gtk_container_add (GTK_CONTAINER (b_box), 
		     add_panel->buttons[HOST_OK_BUTTON]);
  GTK_WIDGET_SET_FLAGS (add_panel->buttons[HOST_OK_BUTTON], GTK_CAN_DEFAULT);

  add_panel->buttons[HOST_CAN_BUTTON] = gnome_stock_button
    (GNOME_STOCK_BUTTON_CANCEL);
  gtk_signal_connect (GTK_OBJECT (add_panel->buttons[HOST_CAN_BUTTON]),
		      "clicked", GTK_SIGNAL_FUNC (add_host_cancel_cb),
		      add_panel);
  gtk_container_add (GTK_CONTAINER (b_box),
		     add_panel->buttons[HOST_CAN_BUTTON]);
  GTK_WIDGET_SET_FLAGS (add_panel->buttons[HOST_CAN_BUTTON], GTK_CAN_DEFAULT);
  
  gnome_app_set_contents (GNOME_APP (add_panel->window), w_box);
  gtk_widget_show_all (add_panel->window);
}

/*
 * Callback functions for the add host panel
 */
static gint
delete_add_host_panel (GtkWidget *widget, GdkEvent *e, gpointer data)
{
  destroy_add_host_panel ();
  return TRUE;
}

static void
add_host_entry_cb (GtkWidget *widget, gpointer data)
{
  int   which;

  which = (int)gtk_object_get_data (GTK_OBJECT (widget), "which_button");
  gtk_widget_set_sensitive (GTK_WIDGET (add_panel->buttons[HOST_OK_BUTTON]),
			    TRUE);
  if (which == HOST_E_NAME)
    gtk_entry_set_text (GTK_ENTRY (add_panel->entries[HOST_E_DISP]),
			gtk_entry_get_text 
			(GTK_ENTRY (add_panel->entries[which])));
  if (++which < ELEMENTS (edit_labels))
    gtk_widget_grab_focus (add_panel->entries[which]);
}

static void
add_host_change_cb (GtkWidget *widget, gpointer data)
{
  /*  
   * FIXME!
   * Check and see if this widget is sensitive, if it is don't bother.
   */
  if (GTK_WIDGET_VISIBLE (add_panel->window))
    gtk_widget_set_sensitive (GTK_WIDGET (add_panel->buttons[HOST_OK_BUTTON])
			      , TRUE);
}

static void
add_host_ok_cb (GtkWidget *widget, gpointer data)
{
  GtkAdjustment *adjustment;
  hosts         *hentry, *check;
  int           i;
  struct hostent *hp;
  char           *buf;
#ifdef HAVE_SQL
  sql_server    *sql_serv;
#endif

  hentry = (hosts *)g_malloc(sizeof (hosts));

  hide_add_host_panel ();
  buf = g_strdup (gtk_entry_get_text (GTK_ENTRY 
		  (add_panel->entries[HOST_E_NAME])));
  hp = lookuphost (buf);
  if (!hp)
    {
      notice_dlg (_("The host '%s' was not found in the host lookup."),
		  buf);
      g_free (hentry);
      return;
    }
  for (i = 0; i < ELEMENTS(edit_labels); i++)
    {
      switch (i)
	{
	case HOST_E_NAME:
	  if (hp)
	    hentry->hl_snmp.name = g_strdup (hp->h_name);
	  else
	    hentry->hl_snmp.name = g_strdup (gtk_entry_get_text (GTK_ENTRY 
			      (add_panel->entries[HOST_E_NAME])));
	  break;
	case HOST_E_DISP:
	  hentry->hl_disp = g_strdup (gtk_entry_get_text (GTK_ENTRY
			    (add_panel->entries[HOST_E_DISP])));
	  break;
	case HOST_E_WCOM:
	  hentry->hl_snmp.wcomm = g_strdup (gtk_entry_get_text (GTK_ENTRY
                            (add_panel->entries[HOST_E_WCOM])));
	  break;
	case HOST_E_RCOM:
	  hentry->hl_snmp.rcomm = g_strdup (gtk_entry_get_text (GTK_ENTRY
			    (add_panel->entries[HOST_E_RCOM])));
	  break;
	case HOST_E_VERS:
	  adjustment = gtk_range_get_adjustment (GTK_RANGE 
		       (add_panel->entries[HOST_E_VERS]));
	  hentry->hl_snmp.version = abs (adjustment->value);
	  break;
	case HOST_E_PORT:
	  hentry->hl_snmp.port = atoi (gtk_entry_get_text (GTK_ENTRY
			    (add_panel->entries[HOST_E_PORT])));
	  break;
	case HOST_E_RETR:
	  adjustment = gtk_range_get_adjustment (GTK_RANGE 
		       (add_panel->entries[HOST_E_RETR]));
	  hentry->hl_snmp.retries = abs (adjustment->value);
	  break;
	case HOST_E_TIME:
	  adjustment = gtk_range_get_adjustment (GTK_RANGE 
		       (add_panel->entries[HOST_E_TIME]));
	  hentry->hl_snmp.timeout = abs (adjustment->value);
	  break;
	}
    }

  hentry->hl_location.x = 10;
  hentry->hl_location.y = 10;
  hentry->hl_location.width = 80;
  hentry->hl_location.height = 20;
  
  if (!(g_hash_table_lookup (app_info->host_hash, hentry->hl_snmp.name)))
    {
      add_host (hentry);
#ifdef HAVE_SQL
      sql_serv = g_new (sql_server, 1);
      sql_serv->sql_host = g_strdup (app_info->current_config.def_sql_host);
      sql_serv->sql_user = g_strdup (app_info->current_config.def_sql_user);
      sql_serv->sql_pass = g_strdup (app_info->current_config.def_sql_pass);
      sql_add_host_entry (sql_serv, hentry);
      g_free (sql_serv);
#endif
    }
  else
    {
      update_app_stat ("Host '%s' is already in the list", 
		       hentry->hl_snmp.name);
    }
  g_free (hentry);
}


static void
add_host_cancel_cb (GtkWidget *widget, gpointer data)
{
  hide_add_host_panel ();
}

/*
 * Exported standard panel functions (add host panel)
 */
void
open_add_host_panel ()
{
  if (!add_panel)
    create_add_host_panel ();
  else if (!GTK_WIDGET_VISIBLE (add_panel->window))
    gtk_widget_show (add_panel->window);
  reset_add_host_panel ();
}

void
destroy_add_host_panel ()
{
  if (add_panel)
    {
      gtk_widget_destroy (add_panel->window);
      g_free (add_panel);
      add_panel = NULL;
    }
}

void
hide_add_host_panel ()
{
  if (add_panel)
    if(GTK_WIDGET_VISIBLE (add_panel->window))
      gtk_widget_hide (add_panel->window);
}

void
reset_add_host_panel ()
{
  if (add_panel)
    {
      gtk_entry_set_text (GTK_ENTRY (add_panel->entries[HOST_E_NAME]), "");
      gtk_entry_set_text (GTK_ENTRY (add_panel->entries[HOST_E_DISP]), "");
      gtk_entry_set_text (GTK_ENTRY (add_panel->entries[HOST_E_RCOM]),
			  app_info->current_config.def_snmp_com);
      gtk_entry_set_text (GTK_ENTRY (add_panel->entries[HOST_E_WCOM]),
			  app_info->current_config.def_snmp_wcom);
      gtk_widget_grab_focus (add_panel->entries[HOST_E_NAME]);
      gtk_widget_set_sensitive (GTK_WIDGET (add_panel->buttons[HOST_OK_BUTTON])
				, FALSE);
    }
}

/*
 * SNMP Set panel (single mib. without digging around)
 */
/*
 * Local functions to the set panel
 */
static void        create_set_panel                (void);
static gint        set_panel_delete_cb             (GtkWidget   *widget,
						    GdkEvent    *e,
						    gpointer    data);
static void        set_panel_query_button_cb       (GtkWidget   *widget,
						    gpointer    data);
static void        set_panel_close_button_cb       (GtkWidget   *widget,
						    gpointer    data);

/*
 * Local variables
 */
static set_panel   *sset_panel = NULL;

/*
 * Local functions
 */

static void
create_set_panel ()
{
  GtkWidget    *w_box;
  GtkWidget    *w_frame;
  GtkWidget    *b_box;
  GtkWidget    *h_bar;

  sset_panel = (set_panel *)g_malloc (sizeof (set_panel));

  sset_panel->window = gnome_app_new ("GXSNMP", N_("Set A Mib"));
  gtk_window_set_wmclass (GTK_WINDOW (sset_panel->window), "mib_set_panel",
				      "GXSNMP");
			  
  gtk_signal_connect (GTK_OBJECT (sset_panel->window), "delete_event",
		      GTK_SIGNAL_FUNC (set_panel_delete_cb),
		      sset_panel->window);
  w_box = gtk_vbox_new (FALSE, 2);
  w_frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (w_box), w_frame, FALSE, TRUE, 2);
  
  /*
   * do the panel stuff here
   */

  h_bar = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (w_box), h_bar, FALSE, FALSE, 0);
  w_frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (w_box), w_frame, FALSE, FALSE, 0);
  b_box = gtk_hbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (b_box), 4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (b_box), GTK_BUTTONBOX_EDGE);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (b_box), 2);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (b_box), 85, 20);
  gtk_container_add (GTK_CONTAINER (w_frame), b_box);
  sset_panel->buttons[SET_QUERY_BUTTON] = gtk_button_new_with_label 
    (N_("Query"));
  gtk_container_add (GTK_CONTAINER (b_box), 
		     sset_panel->buttons[SET_QUERY_BUTTON]);
  sset_panel->buttons[SET_CLOSE_BUTTON] = gnome_stock_button 
    (GNOME_STOCK_BUTTON_CLOSE);
  gtk_container_add (GTK_CONTAINER (b_box),
		     sset_panel->buttons[SET_CLOSE_BUTTON]);
  gnome_app_set_contents (GNOME_APP (sset_panel->window), w_box);
  gtk_widget_show_all (sset_panel->window);
}

static gint
set_panel_delete_cb (GtkWidget *widget, GdkEvent *e, gpointer data)
{
  if (sset_panel)
    {
      gtk_widget_destroy (sset_panel->window);
      g_free (sset_panel);
      sset_panel = NULL;
    }
  return TRUE;
}

static void
set_panel_close_button_cb (GtkWidget *widget, gpointer data)
{
  hide_set_panel ();
}

static void
set_panel_query_button_cb (GtkWidget *widget, gpointer data)
{
}

/*
 * Global panel functions (set mib panel)
 */
void
open_set_panel ()
{
  if (sset_panel == NULL)
    create_set_panel ();
  else
    if (!GTK_WIDGET_VISIBLE (sset_panel->window))
      gtk_widget_show (sset_panel->window);
  reset_set_panel ();
}

void
destroy_set_panel ()
{
  if (sset_panel != NULL)
    {
       set_panel_delete_cb (NULL, NULL, sset_panel);
    }
}

void
hide_set_panel ()
{
  if (sset_panel->window)
    {
      if (GTK_WIDGET_VISIBLE (sset_panel->window))
	gtk_widget_hide (sset_panel->window);
    }
}

void
reset_set_panel ()
{
}

/*
 * Get mib panel
 */

/*
 * Local functions (Forward declarations)
 */
static void       create_get_panel            (void);
static gint       delete_get_panel            (GtkWidget   *widget,
					       GdkEvent    *e,
					       gpointer    data);
static void       close_get_panel_cb          (GtkWidget   *widget,
					       gpointer    data);

/*
 * Local variables
 */
static set_panel *get_panel = NULL;

/* Global variable for this scope */

/*
 * Actual local functions
 */

static void
create_get_panel ()
{
}

/*
 * Callback functions (get mib panel)
 */
static gint
delete_get_panel (GtkWidget *widget, GdkEvent *e, gpointer data)
{
}

static void
close_get_panel_cb (GtkWidget *widget, gpointer data)
{
  hide_get_panel ();
}


/*
 * Global panel functions ( get mib panel )
 */
void
open_get_panel ()
{
  if (!get_panel)
    create_get_panel ();
  else
    if (!GTK_WIDGET_VISIBLE (get_panel->window))
      gtk_widget_show (get_panel->window);
  reset_get_panel ();
}

void 
destroy_get_panel ()
{
  if (get_panel)
    delete_get_panel (NULL, NULL, get_panel);
}

void 
hide_get_panel ()
{
  if (get_panel->window)
    {
      if (GTK_WIDGET_VISIBLE (get_panel->window))
	gtk_widget_hide (get_panel->window);
    }
}

void
reset_get_panel ()
{
}

/*
 * Monitor mib panel
 */

/*
 * Global panel functions (monitor mib)
 */
void
open_monitor_panel ()
{
}

void 
destroy_monitor_panel ()
{
}

void
hide_monitor_panel ()
{
}

void
reset_monitor_panel ()
{
}

/* EOF */
