/*
 * $Id: queue.c,v 1.7 1998/05/25 18:32:02 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Queue handling functions.
 */
#ifndef lint
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
static char const rcsid[] =
"$Id: queue.c,v 1.7 1998/05/25 18:32:02 gregm Exp $";

#include "main.h"

static GtkWidget *queue_panel = NULL;

/*
 * Local variables
 */
static GList    *w_queue = NULL;  /* pending */
static GList    *d_queue = NULL;  /* done, re-insert to pending on next loop */
static GList    *q_item  = NULL;  /* current queue item */
static int      next_id  = 0;     
/*
 * Forward declarations
 */
static void            create_queue_panel        (void);
static queue_entry     *find_queue_entry         (int         id,
						  GList       *queue);
static gint            queue_panel_delete_cb     (GtkWidget   *widget,
						  GdkEvent    *e,
						  gpointer    data);
static void            queue_panel_close_cb      (GtkWidget   *widget,
						  gpointer    data);

/*
 * Local functions
 */
static queue_entry *
find_queue_entry (int id, GList *queue)
{
  GList        *item;
  queue_entry  *data;

  if (g_list_length (queue) <= 0)
    return NULL;                         /* not found */
  item = g_list_first (queue);
  while (item)
    {
      data = (queue_entry *)item->data;
      item = g_list_next (item);
      if ( (int)data->id == id)
	return data;
    }
  return NULL;                           /* not found */
}

/*
 * Module UI Functions
 */
static void
create_queue_panel ()
{
}

static gint
queue_panel_delete_cb (GtkWidget *widget, GdkEvent *e, gpointer data)
{
}

static void
queue_panel_close_cb (GtkWidget *widget, gpointer data)
{
}

/*
 * Global functions
 */

int
get_next_queue_id ()
{
  next_id++;
  return next_id;
}

int
add_queue_item (queue_entry *entry)
{
  queue_entry      *cp;

  g_return_val_if_fail (entry != NULL, -1);
  
  if (find_queue_entry (entry->id, w_queue))
    {
      g_print ("Queue entry with that id (%d) already exists\n", entry->id);
      return -1;
    }
  cp = (queue_entry *)g_malloc (sizeof (queue_entry));
  memcpy (cp, entry, sizeof (queue_entry));
  w_queue = g_list_append (w_queue, cp);
  return cp->id;
}

int
remove_queue_item (int id)
{
  queue_entry   *rem;

  if ( (rem = find_queue_entry (id, w_queue)))
    {
      /* go ahead and remove it */
    }
  return -1;
}

/*
 * This will walk the queue processing one element
 */
int 
run_queue (gpointer data)
{
  queue_entry   *current;
  GList         *foo;


  if (q_item == NULL)
      q_item = g_list_first (w_queue);

  if (q_item)
    {
      current = (queue_entry *)q_item->data;
#ifdef QUEUE_DEBUG
      g_print ("Proccessing queue item %d\n", current->id);
#endif
      current->time_last = current->time;
      current->time      = time (NULL);
      if (current->queue_callback)
	{
	  current->queue_callback (current, current->data);
	}
      if (q_item->next == NULL)
	{
	  q_item = g_list_first (w_queue);
#ifdef QUEUE_DEBUG
	  g_print ("End of queue reached roll around to the begining..\n");
#endif
	  return TRUE;
	  /* Hit the end, roll back to the begining */
	}
      q_item = q_item->next;
      current = (queue_entry *)q_item->data;
#ifdef QUEUE_DEBUG
      g_print ("next _should_ be %d\n", current->id);
#endif
      return TRUE;
    }
  else 
    q_item = NULL;
  return TRUE;
}

/*
 * Standard queue callback functions
 */
void
test_callback (queue_entry *queue, gpointer data)
{
  hosts     *entry;
  GtkWidget *widget;

  entry = (hosts *)data;
  widget = GTK_WIDGET (entry->widget);

  /*  gtk_host_led_toggle (widget); */
}

/*
 * Standard global panel functions
 */
void 
open_queue_panel ()
{
}

void
hide_queue_panel ()
{
}

void
destroy_queue_panel ()
{
}

void 
reset_queue_panel ()
{
}

/* EOF */

