/*
 * $Id: main.h,v 1.17 1998/06/04 00:15:47 unammx Exp $
 * GXSNMP -- An snmp management application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Header file for the main module
 */
#ifndef __MAIN_H__
#define __MAIN_H__
#include <config.h>
#include <gnome.h>
#include <sys/types.h>
#include <sys/stat.h>             /* For 'struct stat' */
#include <sys/errno.h>            /* For the errno declarations */
#include <pwd.h>                  /* For the passwd struct */
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>

#include <g_snmp.h>
#include <parse.h>
#include <mib.h>

#include "about.h"
#include "gui.h"
#include "menus.h"
#include "gtksbox.h"
#include "snmp_host.h"
#include "snmp_lib.h"
#include "config_panel.h"
#include "host_list.h"
#include "host.h"
#include "network_panel.h"
#include "events.h"
#include "fileops.h"
#include "browser.h"
#include "ping.h"
#include "date.h"
#include "sql_interface.h"
#include "queue.h"
#include "gtkhost.h"
#include "main_panel.h"
#include "rmon_panel.h"

/*
 * User interface variables and structures
 */
typedef struct __GxSnmp {
  /* main interface values */
  GtkWidget            *window;              /* Main window */
  GtkAcceleratorTable  *accel_table;
  GdkPixmap            *pixmap;
  GtkWidget            *mouse_stat;
  GtkWidget            *app_stat;
  GtkWidget            *eventbox;
  GtkWidget            *current_host;
  GdkColorContext      *cc;
  GdkGC                *gc;
  /* application info */
  gxsnmp_config        current_config;
  int                  x, y, app_stat_id;
  int                  mouse_stat_id;
  gint                 ping_tag;
  GHashTable           *host_hash;
  int                  host_count;
  int                  network_count;
  int                  snmp_running;

  /* Panels of the application */
  GtkWidget            *host_popup_right;
  config_panel         *conf_panel;
  hlist_panel          *hlist_pane;
  netwk_panel          *netwk_panel;
  sinfo_panel          *sinf_panel;
  interface_panel      *inter_panel;
  browser_panel        *brows_panel;
} gxsnmp;

void          update_app_stat        (gchar *msg, ...)
                                     __attribute__ ((format (printf, 1, 2)));
gint draw_host                       (GtkWidget *widget, hosts *hentry);
#endif

/* EOF */







