/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/
#include <config.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>
#include <gdk_imlib_private.h>
#include <gnome.h>
#include <gtk/gtk.h>
#include "ee.h"

static error_t parse_an_arg (int key, char *arg, struct argp_state *state);

/* This describes how to parse our command-line arguments.  We don't
   accept any options; we just look for file names.  */
static struct argp parser =
{
   NULL,
   parse_an_arg,
   N_("FILE ..."),
   NULL,
   NULL,
   NULL,
   NULL
};

void thumb_click(GtkWidget *widget, gpointer client_data)
{
   struct thumb *d;
   int i;
   GList *l;
   
   d=(struct thumb *)client_data;
   load_file(d->file);
   l=img_list;
   i=0;
   while(l)
     {
	if (!strcmp(d->file,l->data)) break;
	i++;	
	l=l->next;
     }
   current_sel=i;
   gtk_clist_moveto(GTK_CLIST(list),current_sel,0,0.5,0.5);
   gtk_clist_select_row(GTK_CLIST(list),current_sel,0);
}

void size_thumbs()
{
   GList *gl;
   gint w,h;

   gl=thumb_hboxlist;
   w=0;h=0;
   while(gl)
     {
	if (GTK_WIDGET(gl->data)->allocation.width>w) 
	  w=GTK_WIDGET(gl->data)->allocation.width;
	gl=gl->next;
     }
   if (w<320) w=10*64;
   h=GTK_WIDGET(thumb_scroll_window)->allocation.height;
   if (h<32) h=240;
   gtk_widget_set_usize(thumb_scroll_window,w,h);
   gtk_widget_queue_resize(thumb_scroll_window);
}

void free_thumb(struct thumb *th)
{
   int num;
   GList *l,*ll;
   
   if (!th) return;
   num=g_list_length(GTK_BOX(th->parent)->children);
   gtk_widget_destroy(GTK_WIDGET(th->vbox));
   if (num<=1) 
     {
	l=thumb_hboxlist;
	while(l)
	  {
	     if (th->parent==l->data) break;
	     l=l->next;
	  }
	gtk_widget_destroy(th->parent);
	if (l)
	  {
	     thumb_hboxlist=g_list_remove_link(thumb_hboxlist,l);
	     g_list_free_1(l);
	  }
     }
   free(th->file);
   g_free(th);
}

void add_file_to_list(gchar *file)
{
   GtkWidget *button;
   GtkWidget *button2;
   GtkWidget *box;
   GtkWidget *box2;
   GList *gl;
   GdkPixmap *p;
   int num;
   struct thumb *th;
   char *s;
   gint w,h;
   
   gtk_clist_append(GTK_CLIST(list),&file);
   gl=g_list_last(thumb_hboxlist);
   box=NULL;
   if (gl) box=GTK_WIDGET(gl->data);
   if ((!box)||(g_list_length(GTK_BOX(box)->children)>9))
     {
	box=gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(thumb_vbox),box,TRUE,FALSE,0);
	gtk_widget_show(box);
	thumb_hboxlist=g_list_append(thumb_hboxlist,box);
     }
   th=g_malloc(sizeof(struct thumb));
   thumb_list=g_list_append(thumb_list,th);

   box2=gtk_vbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(box),box2,FALSE,FALSE,0);
   gtk_widget_show(box2);
   
   button=gtk_button_new();
   gtk_box_pack_start(GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(thumb_click),th);
   th->thumb=button;
   th->gtkpmap=NULL;

   if (thumbsup)
     {
	p=getthumb(file);
	button2=gtk_pixmap_new(p,NULL);
	gdk_imlib_free_pixmap(p);
	gtk_container_add(GTK_CONTAINER(button),button2);
	gtk_widget_show(button2);
	th->gtkpmap=button2;
     }
   
   s=fileof(file);
   button=gtk_button_new_with_label(s);
   free(s);
   gtk_box_pack_start(GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(thumb_click),th);
   
   th->parent=box;
   th->vbox=box2;
   th->name=button;
   th->file=strdup(file);
   size_thumbs();
}

GdkPixmap *getthumb(gchar *file)
{
   GdkPixmap *p;
   GdkImlibImage *im;
   GdkImlibImage *im2;
   int w,h,ww,hh,gen;
   unsigned long date1,date2;
   char *home, *s, *ss,*f,*cw;
   
   max_thumb_w=64;max_thumb_h=48;
   
   gen=0;
   cw=cwd();
   if (file[0]!='/')
	   f = g_copy_strings (cw, "/", file, NULL);
   else
	   f = g_strdup (file);
   free(cw);
   home=homedir(getuid());
   s = g_copy_strings (home, "/.ee", NULL);
   
   if (!exists(s)) md(s);
   if (!isdir(s)) 
     {
	ss = g_copy_strings (home, "/.ee_old", NULL);
	mv(s,ss);
	md(s);
	g_free (ss);
     }
   g_free (s);
   s = g_copy_strings (home, "/.ee/icons", NULL);
   if (!exists(s)) md(s);
   g_free (s);
   s = g_copy_strings (home, "/.ee/icons/", f, NULL);
   mkdirs(s);
   
   im=NULL;
   if (exists(s))
     {
	date1=moddate(f);
	date2=moddate(s);

	/* FIXME: this looks like a bug to me: shouldnt the test here be date1 > date2? */
	if (f>s) im=NULL;
	else im=gdk_imlib_load_image(s);
     }
   if (!im) gen=1;
   if (gen)
     {
	im=gdk_imlib_load_image(f);
	ww=im->rgb_width;hh=im->rgb_height;
	w=max_thumb_w;h=(max_thumb_w*hh)/ww;
	if (h>max_thumb_h)
	  {
	     h=max_thumb_h;w=(max_thumb_h*ww)/hh;
	  }
	im2=gdk_imlib_clone_scaled_image(im,w,h);
	gdk_imlib_render(im2,w,h);
	p=gdk_imlib_move_image(im2);
	gdk_imlib_save_image_to_ppm(im2,s);
	gdk_imlib_kill_image(im2);
	gdk_imlib_destroy_image(im);
     }
   else
     {
	w=im->rgb_width;h=im->rgb_height;
	gdk_imlib_render(im,w,h);
	p=gdk_imlib_move_image(im);
	gdk_imlib_destroy_image(im);
     }
   g_free (s);
   g_free (f);
   free(home);
   return p;
}

void next_img(GtkWidget *widget, gpointer client_data)
{
   GList *l;
   gint num;
   
   num=g_list_length(img_list);
   current_sel++;
   if (current_sel>=num) 
     {
	current_sel--;
	return;
     }
   gtk_clist_freeze(GTK_CLIST(list));
   gtk_clist_moveto(GTK_CLIST(list),current_sel,0,0.5,0.5);
   gtk_clist_select_row(GTK_CLIST(list),current_sel,0);
   gtk_clist_thaw(GTK_CLIST(list));
   l=g_list_nth(img_list,current_sel);
   load_file(l->data);
}

void prev_img(GtkWidget *widget, gpointer client_data)
{
   GList *l;
   gint num;
   
   num=g_list_length(img_list);
   current_sel--;
   if (current_sel<0) 
     {
	current_sel++;
	return;
     }
   gtk_clist_freeze(GTK_CLIST(list));
   gtk_clist_moveto(GTK_CLIST(list),current_sel,0,0.5,0.5);
   gtk_clist_select_row(GTK_CLIST(list),current_sel,0);
   gtk_clist_thaw(GTK_CLIST(list));
   l=g_list_nth(img_list,current_sel);
   load_file(l->data);
}

void add_new_file_to_list(gchar *file)
{
   gtk_clist_freeze(GTK_CLIST(list));
   img_list=g_list_append(img_list,strdup(file));
   add_file_to_list(file);
   gtk_clist_thaw(GTK_CLIST(list));
}

void click_list(GtkWidget *widget, gint row)
{
   GList *l;

   if (row==current_sel) return;
   current_sel=row;
   gtk_clist_freeze(GTK_CLIST(list));
   gtk_clist_thaw(GTK_CLIST(list));
   l=g_list_nth(img_list,current_sel);
   load_file(l->data);
}

void clear_list(GtkWidget *widget, gpointer *data)
{
   GList *l,*ll;
   
   l=img_list;
   while(l)
     {
	ll=l;
	l=l->next;
	img_list=g_list_remove(img_list,ll->data);
	g_free(ll->data);
     }
   g_list_free(img_list);
   img_list=NULL;
   
   l=thumb_list;
   while(l)
     {
	ll=l;
	l=l->next;
	free_thumb((struct thumb *)ll->data);
	thumb_list=g_list_remove_link(thumb_list,ll);
	g_list_free_1(ll);
     }
   g_list_free(thumb_list);
   thumb_list=NULL;
   
   gtk_clist_freeze(GTK_CLIST(list));
   gtk_clist_clear(GTK_CLIST(list));
   img_list=g_list_append(img_list,strdup(image->filename));
   add_file_to_list(image->filename);
   gtk_clist_thaw(GTK_CLIST(list));
   size_thumbs();
}

void save_list(GtkWidget *widget, gpointer *data)
{
}

void del_list_item(GtkWidget *widget, gpointer *data)
{
   gint entry;
   GList *l,*ll;
   char *s;
   
   s = strdup (image->filename);
   entry=current_sel;
   next_img(NULL,NULL);
   if (entry==current_sel) prev_img(NULL,NULL);
   if (entry==current_sel) return;

   l=img_list;
   while(l)
     {
	ll=l;
	l=l->next;
	if (!strcmp(s,ll->data))
	  {
	     g_free(ll->data);
	     img_list=g_list_remove_link(img_list,ll);
	     g_list_free_1(ll);
	     l=NULL;
	  }
     }
   
   l=thumb_list;
   while(l)
     {
	if (!strcmp(s,((struct thumb *)l->data)->file))
	  {
	     free_thumb((struct thumb *)l->data);
	     thumb_list=g_list_remove_link(thumb_list,l);
	     g_list_free_1(l);
	     break;
	  }
	l=l->next;
     }

   gtk_clist_freeze(GTK_CLIST(list));
   gtk_clist_remove(GTK_CLIST(list),entry);
   gtk_clist_thaw(GTK_CLIST(list));
   size_thumbs();
   g_free (s);
}

void close_progress(GtkWidget *widget, gpointer *data)
{
   show_widget(NULL,(gpointer *)&progress_window);
}

void close_control(GtkWidget *widget, gpointer *data)
{
   show_widget(NULL,(gpointer *)&control_window);
}

void close_edit(GtkWidget *widget, gpointer *data)
{
   show_widget(NULL,(gpointer *)&edwin.window);
}

void close_list(GtkWidget *widget, gpointer *data)
{
   show_widget(NULL,(gpointer *)&list_window);
}

void close_thumbnails(GtkWidget *widget, gpointer *data)
{
   show_widget(NULL,(gpointer *)&thumb_window);
}

void close_image(GtkWidget *widget, gpointer *data)
{
   gtk_main_quit();
}


void show_widget(GtkWidget *widget, gpointer *data)
{
   GtkWidget *w;
   GtkWidget *button;
   GdkPixmap *p;
   GList     *gl;
   struct thumb *th;
   gint       num,i;
   gfloat     prog;
   GdkRectangle rect;
   
   w=GTK_WIDGET(*data);
   if (!data) return;
   if (!w) w=widget;
   if (!w) return;
   if (!GTK_WIDGET_VISIBLE(w)) 
     {
	gtk_window_position(GTK_WINDOW(w),GTK_WIN_POS_MOUSE);
	gtk_widget_show(w);
	if (w==thumb_window) 
	  {
	     if (!thumbsup)
	       {
		  gl=thumb_list;
		  i=0;
		  
		  num=g_list_length(gl);
		  show_widget(NULL,(gpointer *)&progress_window);
		  gtk_progress_bar_update(GTK_PROGRESS_BAR(progress_bar),0.0);
		  while(gl)
		    {
		       th=(struct thumb *)(gl->data);
		       if (!th->gtkpmap)
			 {
			    p=getthumb(th->file);
			    button=gtk_pixmap_new(p,NULL);
			    gdk_imlib_free_pixmap(p);
			    gtk_container_add(GTK_CONTAINER(th->thumb),button);
			    gtk_widget_show(button);
			    th->gtkpmap=button;
			 }
		       prog=((gfloat)i)/((gfloat)num);
		       gtk_progress_bar_update(GTK_PROGRESS_BAR(progress_bar),prog);
		       rect.x=0;rect.y=0;rect.width=32767;rect.height=32767;
/*		       gtk_widget_queue_draw(progress_bar);*/
		       gtk_widget_draw(progress_bar,&rect);
		       gdk_flush();
		       gl=gl->next;
		       i++;
		    }
		  show_widget(NULL,(gpointer *)&progress_window);
	       }
	     thumbsup=1;
	     size_thumbs();
	  }
     }
   else gtk_widget_hide(w);
}

/* This is simple, as we only accept url:ALL for now.  If we supported more drop
 * types we should test the drop data type
 */
void filenames_dropped (GtkWidget *widget, GdkEventDropDataAvailable *event)
{
	int count = event->data_numbytes;
	char *p = event->data;
	int len;

	do {
		len = 1 + strlen (event->data);
		count -= len;
		new_file (p);
		p += len;
	} while (count > 0);
}

void configure_drop_on_widget (GtkWidget *widget, GdkWindow *window)
{
   static char *drop_types [] = { "url:ALL" };

   gdk_window_dnd_drop_set (window, TRUE, drop_types, 1 /* Number of drop types */, FALSE);
   gtk_signal_connect (GTK_OBJECT (widget), "drop_data_available_event",
		       GTK_SIGNAL_FUNC (filenames_dropped), NULL);
}

void configure_drop_clist_target (GtkCList *clist)
{
   gtk_widget_realize (GTK_WIDGET (clist));
   configure_drop_on_widget (GTK_WIDGET (clist), clist->clist_window);
}

void configure_drop_regular_widget (GtkWidget *widget)
{
   gtk_widget_realize (widget);
   configure_drop_on_widget (widget, widget->window);
}

void create_list()
{
   GtkWidget *box1;
   GtkWidget *box2;
   GtkWidget *box3;
   GtkWidget *button;
   GtkWidget *button2;
   char *s[1];

   s [0] = _("Image List");
   
   list_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_signal_connect(GTK_OBJECT(list_window),"delete_event",GTK_SIGNAL_FUNC(close_list),NULL);
   gtk_container_border_width(GTK_CONTAINER(list_window),4);
   gtk_window_set_policy(GTK_WINDOW(list_window),0,0,1);
   gtk_window_set_title(GTK_WINDOW(list_window),"Electric Eyes");
   gtk_window_set_wmclass(GTK_WINDOW(list_window),"Electic Eyes","Image Viewer");

   box1=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(list_window),box1);
   gtk_widget_show(box1);

   button=gtk_pixmap_new(logo_pmap,NULL);
   gtk_box_pack_start(GTK_BOX(box1),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   box2=gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
   gtk_widget_show(box2);
   
   button=gtk_button_new_with_label(_("Add Entry"));
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(open_file),NULL);

   button=gtk_button_new_with_label(_("Delete Entry"));
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(del_list_item),NULL);

   button=gtk_button_new_with_label(_("Clear List"));
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(clear_list),NULL);

   button=gtk_button_new_with_label(_("Save List"));
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(save_list),NULL);
   
   button=gtk_frame_new(NULL);
   gtk_container_border_width(GTK_CONTAINER(button),4);
   gtk_box_pack_start (GTK_BOX(box1),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   box2=gtk_hbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(button),box2);
   gtk_widget_show(box2);
   
   list=gtk_clist_new(1);
   gtk_box_pack_start (GTK_BOX(box2),list,TRUE,TRUE,0);
   gtk_widget_set_usize(list,200,240);
   gtk_clist_set_selection_mode(GTK_CLIST(list),GTK_SELECTION_SINGLE);
   gtk_clist_set_policy(GTK_CLIST(list),GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
   gtk_signal_connect(GTK_OBJECT(list),"select_row",GTK_SIGNAL_FUNC(click_list),NULL);
   gtk_widget_show(list);
   configure_drop_clist_target (GTK_CLIST (list));
	   
   box3=gtk_vbox_new(FALSE,0);
   gtk_box_pack_start (GTK_BOX(box2),box3,FALSE,TRUE,0);
   gtk_widget_show(box3);
   
   button=gtk_button_new();
   button2=gtk_arrow_new(GTK_ARROW_UP,GTK_SHADOW_IN);
   gtk_widget_show(button2);
   gtk_container_add(GTK_CONTAINER(button),button2);
   gtk_box_pack_start (GTK_BOX(box3),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(prev_img),NULL);

   button=gtk_button_new();
   button2=gtk_arrow_new(GTK_ARROW_DOWN,GTK_SHADOW_IN);
   gtk_widget_show(button2);
   gtk_container_add(GTK_CONTAINER(button),button2);
   gtk_box_pack_start (GTK_BOX(box3),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(next_img),NULL);
}


void make_logo()
{
   GdkImlibImage *im;

   im=gdk_imlib_create_image_from_data(logo,NULL,160,28);
   gdk_imlib_render(im,im->rgb_width,im->rgb_height);
   logo_pmap=gdk_imlib_move_image(im);
   gdk_imlib_kill_image(im);
}

void make_icons()
{
   GdkImlibImage *im;
   GdkImlibColor icl;
   
   icl.r=255;icl.g=0;icl.b=255;
   im=gdk_imlib_create_image_from_data(brightness_icon,NULL,12,12);
   gdk_imlib_set_image_shape(im,&icl);
   gdk_imlib_render(im,im->rgb_width,im->rgb_height);
   brightness_pmap=gdk_imlib_move_image(im);
   brightness_mask=gdk_imlib_move_mask(im);
   gdk_imlib_kill_image(im);
   im=gdk_imlib_create_image_from_data(contrast_icon,NULL,12,12);
   gdk_imlib_set_image_shape(im,&icl);
   gdk_imlib_render(im,im->rgb_width,im->rgb_height);
   contrast_pmap=gdk_imlib_move_image(im);
   contrast_mask=gdk_imlib_move_mask(im);
   gdk_imlib_kill_image(im);
   im=gdk_imlib_create_image_from_data(gamma_icon,NULL,12,12);
   gdk_imlib_set_image_shape(im,&icl);
   gdk_imlib_render(im,im->rgb_width,im->rgb_height);
   gamma_pmap=gdk_imlib_move_image(im);
   gamma_mask=gdk_imlib_move_mask(im);
   gdk_imlib_kill_image(im);
}

GtkWidget *make_mods(gchar *name, gint width, 
		     GtkSignalFunc f11, GtkSignalFunc f12,
		     GtkSignalFunc f21, GtkSignalFunc f22,
		     GtkSignalFunc f31, GtkSignalFunc f32,
		     struct _mods *m)
{
   GtkWidget *bb;
   GtkWidget *button;
   GtkWidget *button2;
   GtkObject *obj;
   GtkWidget *box1;
   GtkWidget *box2;
   GtkWidget *box3;
   GdkImlibColorModifier mod,rmod,gmod,bmod;
   
   bb=button=gtk_aspect_frame_new(name,0.5,0.5,0.0,TRUE);

   box2=gtk_vbox_new(TRUE,0);
   gtk_container_add(GTK_CONTAINER(button),box2);
   gtk_widget_show(box2);
   
   box3=gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(box2),box3,TRUE,TRUE,0);
   gtk_widget_show(box3);
   gdk_imlib_get_image_modifier(image,&mod);
   obj=gtk_adjustment_new((gfloat)mod.gamma,0.0,1024.0,1.0,8.0,0.0);
   button=gtk_hscale_new(GTK_ADJUSTMENT(obj));
   gtk_widget_set_usize(button,width,12);
   gtk_box_pack_start(GTK_BOX(box3),button,TRUE,TRUE,0);
   gtk_range_set_update_policy(GTK_RANGE(button),GTK_UPDATE_CONTINUOUS);
   gtk_scale_set_draw_value(GTK_SCALE(button),FALSE);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",GTK_SIGNAL_FUNC(f11),obj);
   gtk_widget_show(button);
   m->adj1=obj;m->range1=button;
   button=gtk_pixmap_new(gamma_pmap,gamma_mask);
   gtk_widget_show(button);
   button2=gtk_button_new();
   gtk_signal_connect(GTK_OBJECT(button2),"clicked",GTK_SIGNAL_FUNC(f12),obj);
   gtk_container_add(GTK_CONTAINER(button2),button);
   gtk_box_pack_start (GTK_BOX(box3),button2,TRUE,TRUE,0);
   gtk_widget_show(button2);
   m->button1=button2;

   box3=gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(box2),box3,TRUE,TRUE,0);
   gtk_widget_show(box3);
   obj=gtk_adjustment_new((gfloat)mod.brightness,0.0,512.0,1.0,8.0,0.0);
   button=gtk_hscale_new(GTK_ADJUSTMENT(obj));
   gtk_widget_set_usize(button,width,12);
   gtk_box_pack_start(GTK_BOX(box3),button,TRUE,TRUE,0);
   gtk_range_set_update_policy(GTK_RANGE(button),GTK_UPDATE_CONTINUOUS);
   gtk_scale_set_draw_value(GTK_SCALE(button),FALSE);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",GTK_SIGNAL_FUNC(f21),obj);
   gtk_widget_show(button);
   m->adj2=obj;m->range2=button;
   button=gtk_pixmap_new(brightness_pmap,brightness_mask);
   gtk_widget_show(button);
   button2=gtk_button_new();
   gtk_signal_connect(GTK_OBJECT(button2),"clicked",GTK_SIGNAL_FUNC(f22),obj);
   gtk_container_add(GTK_CONTAINER(button2),button);
   gtk_box_pack_start (GTK_BOX(box3),button2,TRUE,TRUE,0);
   gtk_widget_show(button2);
   m->button2=button2;

   box3=gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(box2),box3,TRUE,TRUE,0);
   gtk_widget_show(box3);
   obj=gtk_adjustment_new((gfloat)mod.contrast,0.0,2048.0,1.0,8.0,0.0);
   button=gtk_hscale_new(GTK_ADJUSTMENT(obj));
   gtk_widget_set_usize(button,width,12);
   gtk_box_pack_start (GTK_BOX(box3),button,TRUE,TRUE,0);
   gtk_range_set_update_policy(GTK_RANGE(button),GTK_UPDATE_CONTINUOUS);
   gtk_scale_set_draw_value(GTK_SCALE(button),FALSE);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",GTK_SIGNAL_FUNC(f31),obj);
   gtk_widget_show(button);
   m->adj3=obj;m->range3=button;
   button=gtk_pixmap_new(contrast_pmap,contrast_mask);
   gtk_widget_show(button);
   button2=gtk_button_new();
   gtk_signal_connect(GTK_OBJECT(button2),"clicked",GTK_SIGNAL_FUNC(f32),obj);
   gtk_container_add(GTK_CONTAINER(button2),button);
   gtk_box_pack_start (GTK_BOX(box3),button2,TRUE,TRUE,0);
   gtk_widget_show(button2);
   m->button3=button2;
   return bb;
}

void create_edit()
{
   GtkWidget *button;
   GtkWidget *button2;
   GtkWidget *button3;
   GtkObject *obj;
   GtkWidget *box1;
   GtkWidget *box2;
   GtkWidget *box3;
   GdkImlibColorModifier mod,rmod,gmod,bmod;
   gchar s[10];
   
   edwin.window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_signal_connect(GTK_OBJECT(edwin.window),"delete_event",GTK_SIGNAL_FUNC(close_edit),NULL);
   gtk_container_border_width(GTK_CONTAINER(edwin.window),0);
   gtk_window_set_policy(GTK_WINDOW(edwin.window),0,0,1);
   gtk_window_set_title(GTK_WINDOW(edwin.window),"Electric Eyes");
   gtk_window_set_wmclass(GTK_WINDOW(edwin.window),"Electic Eyes","Image Viewer");

   make_icons();
   box1=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(edwin.window),box1);
   gtk_widget_show(box1);

   button=gtk_pixmap_new(logo_pmap,NULL);
   gtk_box_pack_start(GTK_BOX(box1),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   edwin.mainbox=box2=gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
   gtk_widget_show(box2);

   edwin.leftbox=box1=gtk_vbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(edwin.mainbox),box1,TRUE,TRUE,0);
   gtk_container_border_width(GTK_CONTAINER(box1),4);
   gtk_widget_show(box1);
   
   gtk_widget_show(box1);
   button=make_mods(_("Image Modifiers"),150,
		    GTK_SIGNAL_FUNC(modify_gamma),GTK_SIGNAL_FUNC(reset_gamma),
		    GTK_SIGNAL_FUNC(modify_brightness),GTK_SIGNAL_FUNC(reset_brightness),
		    GTK_SIGNAL_FUNC(modify_contrast),GTK_SIGNAL_FUNC(reset_contrast),
		    &edwin.image);
   gtk_box_pack_start(GTK_BOX(box1),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   button=make_mods(_("Red Modifiers"),150,
		    GTK_SIGNAL_FUNC(modify_rgamma),GTK_SIGNAL_FUNC(reset_rgamma),
		    GTK_SIGNAL_FUNC(modify_rbrightness),GTK_SIGNAL_FUNC(reset_rbrightness),
		    GTK_SIGNAL_FUNC(modify_rcontrast),GTK_SIGNAL_FUNC(reset_rcontrast),
		    &edwin.red);
   gtk_box_pack_start(GTK_BOX(box1),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   button=make_mods(_("Green Modifiers"),150,
		    GTK_SIGNAL_FUNC(modify_ggamma),GTK_SIGNAL_FUNC(reset_ggamma),
		    GTK_SIGNAL_FUNC(modify_gbrightness),GTK_SIGNAL_FUNC(reset_gbrightness),
		    GTK_SIGNAL_FUNC(modify_gcontrast),GTK_SIGNAL_FUNC(reset_gcontrast),
		    &edwin.green);
   gtk_box_pack_start(GTK_BOX(box1),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   button=make_mods(_("Blue Modifiers"),150,
		    GTK_SIGNAL_FUNC(modify_bgamma),GTK_SIGNAL_FUNC(reset_bgamma),
		    GTK_SIGNAL_FUNC(modify_bbrightness),GTK_SIGNAL_FUNC(reset_bbrightness),
		    GTK_SIGNAL_FUNC(modify_bcontrast),GTK_SIGNAL_FUNC(reset_bcontrast),
		    &edwin.blue);
   gtk_box_pack_start(GTK_BOX(box1),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   button=gtk_button_new_with_label(_("Reset All"));
   gtk_box_pack_start (GTK_BOX(box1),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(reset_all),NULL);
   
   edwin.midbox=box1=gtk_vbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(edwin.mainbox),box1,TRUE,TRUE,0);
   gtk_container_border_width(GTK_CONTAINER(box1),4);
   gtk_widget_show(box1);
   
   edwin.mini_container=button=gtk_viewport_new(NULL,NULL);
   gtk_widget_set_usize(button,mini_w,mini_h);
   gtk_box_pack_start(GTK_BOX(box1),button,FALSE,FALSE,0);
   gtk_widget_show(button);

   edwin.mini_image=gtk_drawing_area_new();
   gtk_signal_connect(GTK_OBJECT(edwin.mini_image),"configure_event",GTK_SIGNAL_FUNC(draw_mini_img),NULL);
   gtk_drawing_area_size(GTK_DRAWING_AREA(edwin.mini_image),mini_w,mini_h);
   gtk_container_add(GTK_CONTAINER(button),edwin.mini_image);
   gtk_widget_show(edwin.mini_image);
   
   button=gtk_button_new_with_label(_("Apply"));
   gtk_box_pack_start (GTK_BOX(box1),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(draw_img),image_drawing);
   
   button=gtk_check_button_new_with_label(_("Auto Apply"));
   gtk_box_pack_start (GTK_BOX(box1),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(toggle_autoapply),button);
   
   button=gtk_button_new_with_label(_("Keep Changes"));
   gtk_box_pack_start (GTK_BOX(box1),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(freeze_image),image_drawing);
   
   edwin.rightbox=box1=gtk_vbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(edwin.mainbox),box1,TRUE,TRUE,0);
   gtk_container_border_width(GTK_CONTAINER(box1),4);
   gtk_widget_show(box1);
   
   button2=gtk_aspect_frame_new(_("Size Controls"),0.5,0.5,0.0,TRUE);

   box1=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(button2),box1);
   gtk_widget_show(box1);
   
   box2=gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,FALSE,0);
   gtk_container_border_width(GTK_CONTAINER(box2),2);
   gtk_widget_show(box2);
   
   button=gtk_button_new();
   box3=gtk_hbox_new(FALSE,0);
   gtk_widget_show(box3);
   gtk_container_add(GTK_CONTAINER(button),box3);
   button3=gtk_arrow_new(GTK_ARROW_LEFT,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_box_pack_start (GTK_BOX(box3),button3,FALSE,FALSE,0);
   button3=gtk_arrow_new(GTK_ARROW_LEFT,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_box_pack_start (GTK_BOX(box3),button3,FALSE,FALSE,0);
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(size_half),NULL);

   button=gtk_button_new();
   button3=gtk_arrow_new(GTK_ARROW_LEFT,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_container_add(GTK_CONTAINER(button),button3);
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(size_minus),NULL);

   button=gtk_button_new_with_label(_("Normal"));
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(size_normal),NULL);
   
   button=gtk_button_new();
   button3=gtk_arrow_new(GTK_ARROW_RIGHT,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_container_add(GTK_CONTAINER(button),button3);
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(size_plus),NULL);

   button=gtk_button_new();
   box3=gtk_hbox_new(FALSE,0);
   gtk_widget_show(box3);
   gtk_container_add(GTK_CONTAINER(button),box3);
   button3=gtk_arrow_new(GTK_ARROW_RIGHT,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_box_pack_start (GTK_BOX(box3),button3,FALSE,FALSE,0);
   button3=gtk_arrow_new(GTK_ARROW_RIGHT,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_box_pack_start (GTK_BOX(box3),button3,FALSE,FALSE,0);
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(size_double),NULL);

   button=gtk_check_button_new_with_label(_("Keep Aspect"));
   gtk_box_pack_start (GTK_BOX(box1),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(toggle_aspect),button);
   
   box2=gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,FALSE,0);
   gtk_container_border_width(GTK_CONTAINER(box2),2);
   gtk_widget_show(box2);
   
   edwin.x_size=button=gtk_entry_new_with_max_length(4);
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_set_usize(button,40,20);
   gtk_widget_show(button);
   sprintf(s,"%i",image_drawing->allocation.width);
   gtk_entry_set_text(GTK_ENTRY(button),s);
   gtk_signal_connect(GTK_OBJECT(button),"changed",GTK_SIGNAL_FUNC(size_set),NULL);

   button=gtk_label_new("X");
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);

   edwin.y_size=button=gtk_entry_new_with_max_length(4);
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   sprintf(s,"%i",image_drawing->allocation.height);
   gtk_entry_set_text(GTK_ENTRY(button),s);
   gtk_widget_set_usize(button,40,20);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"changed",GTK_SIGNAL_FUNC(size_set),NULL);
   
   button=gtk_button_new_with_label(_("Keep Changes"));
   gtk_box_pack_start (GTK_BOX(box1),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(freeze_size_image),NULL);
   
   gtk_box_pack_start(GTK_BOX(edwin.rightbox),button2,FALSE,FALSE,0);
   gtk_widget_show(button2);

   box2=gtk_hbox_new(FALSE,0);
   gtk_box_pack_start(GTK_BOX(edwin.rightbox),box2,FALSE,FALSE,0);
   button=gtk_button_new();
   box3=gtk_hbox_new(FALSE,0);
   gtk_widget_show(box3);
   gtk_container_add(GTK_CONTAINER(button),box3);
   button3=gtk_arrow_new(GTK_ARROW_LEFT,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_box_pack_start (GTK_BOX(box3),button3,FALSE,FALSE,1);
   button3=gtk_arrow_new(GTK_ARROW_RIGHT,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_box_pack_start (GTK_BOX(box3),button3,FALSE,FALSE,1);
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(flip_image_h),NULL);

   button=gtk_button_new();
   box3=gtk_vbox_new(FALSE,0);
   gtk_widget_show(box3);
   gtk_container_add(GTK_CONTAINER(button),box3);
   button3=gtk_arrow_new(GTK_ARROW_UP,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_box_pack_start (GTK_BOX(box3),button3,FALSE,FALSE,1);
   button3=gtk_arrow_new(GTK_ARROW_DOWN,GTK_SHADOW_IN);
   gtk_widget_show(button3);
   gtk_box_pack_start (GTK_BOX(box3),button3,FALSE,FALSE,1);
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(flip_image_v),NULL);

   button=gtk_button_new_with_label(_("Rotate"));
   gtk_box_pack_start (GTK_BOX(box2),button,FALSE,FALSE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(rotate_image),NULL);
   gtk_widget_show(box2);

}

void size_set(GtkWidget *widget, gpointer *data)
{
   int w,h;
   char *s;
   
   if (didsize)
     {
	didsize--;
	return;
     }
   if (!GTK_WIDGET_VISIBLE(edwin.window)) return;
   s=gtk_entry_get_text(GTK_ENTRY(edwin.x_size));
   w=atoi(s);
   s=gtk_entry_get_text(GTK_ENTRY(edwin.y_size));
   h=atoi(s);
   if ((w==0)||(h==0)) return;
   if ((w==image_drawing->allocation.width)&&(h==image_drawing->allocation.height)) return;
   if (keep_aspect)
     {
	if (widget==edwin.x_size) h=(w*image->rgb_height)/image->rgb_width;
	else if (widget==edwin.y_size) w=(h*image->rgb_width)/image->rgb_height;
     }
   gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),w,h);
   gtk_widget_queue_resize(image_drawing);
}

void size_half(GtkWidget *widget, gpointer *data)
{
   int w,h;
   
   w=image_drawing->allocation.width;h=image_drawing->allocation.height;
   w/=2;h/=2;
   gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),w,h);
   gtk_widget_queue_resize(image_drawing);
   new_image=1;
}

void size_minus(GtkWidget *widget, gpointer *data)
{
   int w,h;
   
   w=image_drawing->allocation.width;h=image_drawing->allocation.height;
   w=(w*9)/10;h=(h*9)/10;
   gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),w,h);
   gtk_widget_queue_resize(image_drawing);
   new_image=1;
}

void size_normal(GtkWidget *widget, gpointer *data)
{
   int w,h;
   
   w=image->rgb_width;h=image->rgb_height;
   gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),w,h);
   gtk_widget_queue_resize(image_drawing);
   new_image=1;
}

void size_plus(GtkWidget *widget, gpointer *data)
{
   int w,h;
   
   w=image_drawing->allocation.width;h=image_drawing->allocation.height;
   w=(w*11)/10;h=(h*11)/10;
   gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),w,h);
   gtk_widget_queue_resize(image_drawing);
   new_image=1;
}

void size_double(GtkWidget *widget, gpointer *data)
{
   int w,h;
   
   w=image_drawing->allocation.width;h=image_drawing->allocation.height;
   w*=2;h*=2;
   gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),w,h);
   gtk_widget_queue_resize(image_drawing);
   new_image=1;
}

void create_control()
{
   GtkWidget *button;
   GtkWidget *box1;
   GtkWidget *box2;
   
   control_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);

   gtk_signal_connect(GTK_OBJECT(control_window),"delete_event",GTK_SIGNAL_FUNC(close_control),NULL);
   gtk_container_border_width(GTK_CONTAINER(control_window),0);
   gtk_window_set_policy(GTK_WINDOW(control_window),0,0,0);
   gtk_window_set_title(GTK_WINDOW(control_window),"Electric Eyes");
   gtk_window_set_wmclass(GTK_WINDOW(control_window),"Electic Eyes","Image Viewer");

   box1=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(control_window),box1);
   gtk_widget_show(box1);

   box2=gtk_hbox_new(TRUE,0);
   gtk_container_add(GTK_CONTAINER(box1),box2);
   gtk_widget_show(box2);

   button=gtk_pixmap_new(logo_pmap,NULL);
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   box2=gtk_hbox_new(TRUE,0);
   gtk_container_add(GTK_CONTAINER(box1),box2);
   gtk_widget_show(box2);

   button=gtk_button_new_with_label(_("Image List"));
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(show_widget),&list_window);

   button=gtk_button_new_with_label(_("Thumbnails"));
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(show_widget),&thumb_window);
   
   button=gtk_button_new_with_label(_("Edit"));
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(show_widget),&edwin.window);

   button=gtk_button_new_with_label(_("Save"));
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(save_file),NULL);
   
   button=gtk_button_new_with_label(_("Quit"));
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(quit_app),NULL);
}

void create_thumbnails()
{
   GtkWidget *button;
   GtkWidget *box1;
   GtkWidget *box2;
   int i,j;
   
   thumb_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);

   gtk_signal_connect(GTK_OBJECT(thumb_window),"delete_event",GTK_SIGNAL_FUNC(close_thumbnails),NULL);
   gtk_container_border_width(GTK_CONTAINER(thumb_window),0);
   gtk_window_set_policy(GTK_WINDOW(thumb_window),1,1,1);
   gtk_window_set_title(GTK_WINDOW(thumb_window),"Electric Eyes");
   gtk_window_set_wmclass(GTK_WINDOW(thumb_window),"Electic Eyes","Image Viewer");

   box1=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(thumb_window),box1);
   gtk_widget_show(box1);

   box2=gtk_hbox_new(TRUE,0);
   gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,0);
   gtk_widget_show(box2);

   button=gtk_pixmap_new(logo_pmap,NULL);
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   box2=gtk_hbox_new(TRUE,0);
   gtk_container_add(GTK_CONTAINER(box1),box2);
   gtk_widget_show(box2);

   thumb_scroll_window=button=gtk_scrolled_window_new(NULL,NULL);
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   
   thumb_vbox=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(button),thumb_vbox);
   gtk_widget_show(thumb_vbox);
   configure_drop_regular_widget (thumb_scroll_window);
   configure_drop_regular_widget (thumb_vbox);   
   configure_drop_regular_widget (box2);   
   configure_drop_regular_widget (thumb_window);   
}


void create_drawing()
{
   GdkVisual *gdk_visual;
   GdkColormap *gdk_colormap;
   
   gdk_visual = gdkx_visual_get (id->x.visual->visualid);
   gdk_colormap = gdk_colormap_new (gdk_visual, FALSE);
   gtk_widget_push_visual (gdk_visual);
   gtk_widget_push_colormap (gdk_colormap);
   image_drawing=gtk_drawing_area_new();
   gtk_signal_connect(GTK_OBJECT(image_drawing),"configure_event",GTK_SIGNAL_FUNC(draw_img),NULL);
   gtk_signal_connect(GTK_OBJECT(image_drawing),"button_press_event",GTK_SIGNAL_FUNC(button_win),NULL);
   gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),image->rgb_width,image->rgb_height);
   gtk_widget_set_events(image_drawing,GDK_BUTTON_PRESS_MASK);
   gtk_container_add(GTK_CONTAINER(image_window),image_drawing);
   gtk_widget_show(image_drawing);
}

void create_image()
{
   image_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_signal_connect(GTK_OBJECT(image_window),"delete_event",GTK_SIGNAL_FUNC(close_image),NULL);
   gtk_container_border_width(GTK_CONTAINER(image_window),0);
   gtk_window_set_policy(GTK_WINDOW(image_window),1,1,1);
   gtk_window_set_title(GTK_WINDOW(image_window),image->filename);
   gtk_window_set_wmclass(GTK_WINDOW(image_window),"Electic Eyes","Image Viewer");
   create_drawing();
   gtk_widget_show(image_window);
}

void modify_gamma(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_modifier(image,&mod);
   mod.gamma=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_brightness(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_modifier(image,&mod);
   mod.brightness=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_contrast(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_modifier(image,&mod);
   mod.contrast=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_rgamma(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_red_modifier(image,&mod);
   mod.gamma=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_red_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_rbrightness(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_red_modifier(image,&mod);
   mod.brightness=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_red_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_rcontrast(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_red_modifier(image,&mod);
   mod.contrast=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_red_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_ggamma(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_green_modifier(image,&mod);
   mod.gamma=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_green_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_gbrightness(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_green_modifier(image,&mod);
   mod.brightness=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_green_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_gcontrast(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_green_modifier(image,&mod);
   mod.contrast=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_green_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_bgamma(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_blue_modifier(image,&mod);
   mod.gamma=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_blue_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_bbrightness(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_blue_modifier(image,&mod);
   mod.brightness=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_blue_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void modify_bcontrast(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_get_image_blue_modifier(image,&mod);
   mod.contrast=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_blue_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void edit(GtkWidget *widget, gpointer *data)
{
   if (!edwin.window) create_edit();
}

void reset_gamma(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.image.range1),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.image.range1));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.gamma=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_brightness(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.image.range2),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.image.range2));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.brightness=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_contrast(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.image.range3),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.image.range3));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.contrast=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_rgamma(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.red.range1),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.red.range1));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.gamma=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_red_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_rbrightness(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.red.range2),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.red.range2));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.brightness=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_red_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_rcontrast(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.red.range3),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.red.range3));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.contrast=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_red_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_ggamma(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.green.range1),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.green.range1));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.gamma=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_green_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_gbrightness(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.green.range2),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.green.range2));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.brightness=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_green_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_gcontrast(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.green.range3),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.green.range3));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.contrast=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_green_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_bgamma(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.blue.range1),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.blue.range1));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.gamma=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_blue_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_bbrightness(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.blue.range2),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.blue.range2));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.brightness=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_blue_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_bcontrast(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   
   GTK_ADJUSTMENT(data)->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(edwin.blue.range3),GTK_ADJUSTMENT(data));
   gtk_range_slider_update(GTK_RANGE(edwin.blue.range3));
   gdk_imlib_get_image_modifier(image,&mod);
   mod.contrast=(int)GTK_ADJUSTMENT(data)->value;
   gdk_imlib_set_image_blue_modifier(image,&mod);
   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void reset_all(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   mod.gamma=256;mod.brightness=256;mod.contrast=256;
   gdk_imlib_set_image_modifier(image,&mod);
   gdk_imlib_set_image_red_modifier(image,&mod);
   gdk_imlib_set_image_green_modifier(image,&mod);
   gdk_imlib_set_image_blue_modifier(image,&mod);
   
   GTK_ADJUSTMENT(edwin.image.adj1)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.image.adj2)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.image.adj3)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.red.adj1)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.red.adj2)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.red.adj3)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.green.adj1)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.green.adj2)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.green.adj3)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.blue.adj1)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.blue.adj2)->value=(gfloat)(256);
   GTK_ADJUSTMENT(edwin.blue.adj3)->value=(gfloat)(256);

   gtk_range_set_adjustment(GTK_RANGE(edwin.image.range1),GTK_ADJUSTMENT(edwin.image.adj1));
   gtk_range_set_adjustment(GTK_RANGE(edwin.image.range2),GTK_ADJUSTMENT(edwin.image.adj2));
   gtk_range_set_adjustment(GTK_RANGE(edwin.image.range3),GTK_ADJUSTMENT(edwin.image.adj3));
   gtk_range_set_adjustment(GTK_RANGE(edwin.red.range1),GTK_ADJUSTMENT(edwin.red.adj1));
   gtk_range_set_adjustment(GTK_RANGE(edwin.red.range2),GTK_ADJUSTMENT(edwin.red.adj2));
   gtk_range_set_adjustment(GTK_RANGE(edwin.red.range3),GTK_ADJUSTMENT(edwin.red.adj3));
   gtk_range_set_adjustment(GTK_RANGE(edwin.green.range1),GTK_ADJUSTMENT(edwin.green.adj1));
   gtk_range_set_adjustment(GTK_RANGE(edwin.green.range2),GTK_ADJUSTMENT(edwin.green.adj2));
   gtk_range_set_adjustment(GTK_RANGE(edwin.green.range3),GTK_ADJUSTMENT(edwin.green.adj3));
   gtk_range_set_adjustment(GTK_RANGE(edwin.blue.range1),GTK_ADJUSTMENT(edwin.blue.adj1));
   gtk_range_set_adjustment(GTK_RANGE(edwin.blue.range2),GTK_ADJUSTMENT(edwin.blue.adj2));
   gtk_range_set_adjustment(GTK_RANGE(edwin.blue.range3),GTK_ADJUSTMENT(edwin.blue.adj3));

   gtk_range_slider_update(GTK_RANGE(edwin.image.range1));
   gtk_range_slider_update(GTK_RANGE(edwin.image.range2));
   gtk_range_slider_update(GTK_RANGE(edwin.image.range3));
   gtk_range_slider_update(GTK_RANGE(edwin.red.range1));
   gtk_range_slider_update(GTK_RANGE(edwin.red.range2));
   gtk_range_slider_update(GTK_RANGE(edwin.red.range3));
   gtk_range_slider_update(GTK_RANGE(edwin.green.range1));
   gtk_range_slider_update(GTK_RANGE(edwin.green.range2));
   gtk_range_slider_update(GTK_RANGE(edwin.green.range3));
   gtk_range_slider_update(GTK_RANGE(edwin.blue.range1));
   gtk_range_slider_update(GTK_RANGE(edwin.blue.range2));
   gtk_range_slider_update(GTK_RANGE(edwin.blue.range3));

   draw_mini_img(edwin.mini_image,NULL);
   if (autoapply) draw_img(image_drawing,NULL);
}

void freeze_image(GtkWidget *widget, gpointer *data)
{
   gdk_imlib_apply_modifiers_to_rgb(image);
   reset_all(NULL,NULL);
   if (!autoapply) draw_img(image_drawing,NULL);
}

void freeze_size_image(GtkWidget *widget, gpointer *data)
{
   GdkImlibImage *im;
   
   im=gdk_imlib_clone_scaled_image(image,
				   image_drawing->allocation.width,
				   image_drawing->allocation.height);
   gdk_imlib_destroy_image(image);
   image=im;
}

void rotate_image(GtkWidget *widget, gpointer *data)
{
   int a,b;
   
   new_image=1;
   new_draw=1;
   gdk_imlib_rotate_image(image,1);
   a=image->rgb_width;b=image->rgb_height;
   gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),a,b);
   gtk_widget_queue_resize(image_drawing);
   calc_mini();
   draw_mini_img(edwin.mini_image,NULL);
   draw_img(image_drawing,NULL);
}

void flip_image_h(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_flip_image_horizontal(image);
   draw_mini_img(edwin.mini_image,NULL);
   draw_img(image_drawing,NULL);
}

void flip_image_v(GtkWidget *widget, gpointer *data)
{
   GdkImlibColorModifier mod;
   
   gdk_imlib_flip_image_vertical(image);
   draw_mini_img(edwin.mini_image,NULL);
   draw_img(image_drawing,NULL);
}

void open_file(GtkWidget *widget, gpointer *data)
{
   dosave=0;
   if (!filesel)
     {
	filesel=gtk_file_selection_new(_("Electric Eyes: Select File"));
	gtk_signal_connect (GTK_OBJECT(filesel),"destroy",GTK_SIGNAL_FUNC(no_file),&filesel);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),"clicked",GTK_SIGNAL_FUNC(no_file),GTK_OBJECT(filesel));
	gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),"clicked",GTK_SIGNAL_FUNC(read_file),GTK_OBJECT(filesel));
	gtk_window_position(GTK_WINDOW(filesel),GTK_WIN_POS_MOUSE);
	gtk_widget_show(filesel);
     }
   else
     {
	gtk_window_position(GTK_WINDOW(filesel),GTK_WIN_POS_MOUSE);
	gtk_widget_show(filesel);
     }
}

void save_file(GtkWidget *widget, gpointer *data)
{
   char *f,*s;
   
   dosave=1;
   if (!filesel)
     {
	filesel=gtk_file_selection_new(_("Electric Eyes: Select File"));
	gtk_signal_connect (GTK_OBJECT(filesel),"destroy",GTK_SIGNAL_FUNC(no_file),&filesel);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),"clicked",GTK_SIGNAL_FUNC(no_file),GTK_OBJECT(filesel));
	gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),"clicked",GTK_SIGNAL_FUNC(read_file),GTK_OBJECT(filesel));
	f=fileof(image->filename);
	s = g_copy_strings (f, ".ppm", NULL);
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filesel),s);
	free(f);
	g_free (s);
	gtk_window_position(GTK_WINDOW(filesel),GTK_WIN_POS_MOUSE);
	gtk_widget_show(filesel);
     }
   else
     {
	f=fileof(image->filename);
	s = g_copy_strings (f, ".ppm", NULL);
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filesel),s);
	free(f);
	g_free (s);
	gtk_window_position(GTK_WINDOW(filesel),GTK_WIN_POS_MOUSE);
	gtk_widget_show(filesel);
     }
}

void calc_mini()
{
   gint a,b;

   a=image->rgb_width;b=image->rgb_height;
   if ((a*3)>(b*4)) 
     {
	mini_w=128;mini_h=(128*b)/a;
     }
   else
     {
	mini_w=(96*a)/b;mini_h=96;
     }
   if (edwin.mini_image) 
     {
	gtk_widget_set_usize(edwin.mini_container,mini_w,mini_h);
	gtk_drawing_area_size(GTK_DRAWING_AREA(edwin.mini_image),mini_w,mini_h);
	gtk_widget_queue_resize(edwin.mini_container);
	gtk_widget_queue_resize(edwin.mini_image);
     }
}

void read_file(GtkWidget *widget, GtkFileSelection *fs)
{
   gchar *file;
   GList *l;
   
   if (!dosave)
     {
	file=gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
	if (!new_file(file)) return;
	no_file(filesel,NULL);
     }
   else
     {
	file=gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
	gdk_imlib_save_image_to_ppm(image,file);
	no_file(filesel,NULL);
     }
}

gint load_file(char *file)
{
   GdkImlibImage *im;
   gint a,b,i;
   int num;
   char **dir;
   
   im=gdk_imlib_load_image(file);
   if (!im) return 0;
   if (image) gdk_imlib_destroy_image(image);
   new_image=1;
   new_draw=1;
   image=im;
   gtk_window_set_title(GTK_WINDOW(image_window),image->filename);
   a=image->rgb_width;b=image->rgb_height;
   gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),a,b);
   gtk_widget_queue_resize(image_drawing);
   calc_mini();
   if (edwin.window) reset_all(NULL,NULL);
   return 1;
}

gint new_file(gchar *file)
{
   GdkImlibImage *im;
   gint a,b,i;
   int num;
   gfloat prog;
   char **dir,*s;
   
   if (isfile(file))
     {
	im=gdk_imlib_load_image(file);
	if (!im) return 0;
	if (image) gdk_imlib_destroy_image(image);
	new_image=1;
	new_draw=1;
	image=im;
	gtk_window_set_title(GTK_WINDOW(image_window),image->filename);
	a=image->rgb_width;b=image->rgb_height;
	gtk_drawing_area_size(GTK_DRAWING_AREA(image_drawing),a,b);
	gtk_widget_queue_resize(image_drawing);
	calc_mini();
	if (edwin.window) reset_all(NULL,NULL);
	add_new_file_to_list(file);
	return 1;
     }
   else if (isdir(file))
     {
	dir=ls(file,&num);
	gtk_progress_bar_update(GTK_PROGRESS_BAR(progress_bar),0.0);
	show_widget(NULL,(gpointer *)&progress_window);
	for(i=2;i<num;i++)
	  {
		  /* FIXME: s is not initialized here, find out what was
		   * intended here
		   */
	     if (isdir(s)) s = g_copy_strings (file, dir [i], "/", NULL);
	     else s = g_copy_strings (file, dir [i], NULL);
	     if (isdir(s)) new_file(s);
	     else if (isfile(s)) add_new_file_to_list(s);
	     prog=((gfloat)(i-2))/((gfloat)(num-1));
	     gtk_progress_bar_update(GTK_PROGRESS_BAR(progress_bar),prog);
             gtk_widget_queue_draw(progress_bar);
	     gdk_flush();
	     g_free(s);
	  }
	freestrlist(dir,num);
	show_widget(NULL,(gpointer *)&progress_window);
	return 1;
     }
   return 0;
}

void create_progress()
{
   GtkWidget *box1;
   GtkWidget *box2;
   GtkWidget *button;
   
   progress_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);

   gtk_signal_connect(GTK_OBJECT(progress_window),"delete_event",GTK_SIGNAL_FUNC(close_progress),NULL);
   gtk_container_border_width(GTK_CONTAINER(progress_window),0);
   gtk_window_set_policy(GTK_WINDOW(progress_window),0,0,0);
   gtk_window_set_title(GTK_WINDOW(progress_window),"Electric Eyes");
   gtk_window_set_wmclass(GTK_WINDOW(progress_window),"Electic Eyes","Image Viewer");

   box1=gtk_vbox_new(FALSE,0);
   gtk_container_add(GTK_CONTAINER(progress_window),box1);
   gtk_widget_show(box1);

   box2=gtk_hbox_new(TRUE,0);
   gtk_container_add(GTK_CONTAINER(box1),box2);
   gtk_widget_show(box2);

   button=gtk_pixmap_new(logo_pmap,NULL);
   gtk_box_pack_start (GTK_BOX(box2),button,TRUE,TRUE,0);
   gtk_widget_show(button);

   button=gtk_progress_bar_new();
   gtk_box_pack_start (GTK_BOX(box1),button,TRUE,TRUE,0);
   gtk_widget_show(button);
   progress_bar=button;
   
   gtk_window_position(GTK_WINDOW(progress_window),GTK_WIN_POS_MOUSE);
}

void no_file(GtkWidget *widget, gpointer *data)
{
   gtk_widget_hide(filesel);
}

void draw_img(GtkWidget *widget, GdkEventConfigure *event) 
{
   int w,h;
   char *s;
   char ss[10];
   
   if (didsize>0)
     {
	didsize--;
	return;
     }
   if ((image_drawing->allocation.width==image->rgb_width)&&
       (image_drawing->allocation.height!=image->rgb_height)) return;
   new_draw=0;
   if (image_pixmap) gdk_imlib_free_pixmap(image_pixmap);
   image_pixmap=NULL;
   gdk_imlib_render(image,image_drawing->allocation.width,image_drawing->allocation.height);
   image_pixmap=gdk_imlib_move_image(image);
   gdk_window_set_back_pixmap(image_drawing->window,image_pixmap,FALSE);
   gdk_window_clear(image_drawing->window);
   gdk_flush();
   if (edwin.window)
     {
	s=gtk_entry_get_text(GTK_ENTRY(edwin.x_size));
	w=atoi(s);
	s=gtk_entry_get_text(GTK_ENTRY(edwin.y_size));
	h=atoi(s);
	if ((w!=image_drawing->allocation.width)||(h!=image_drawing->allocation.height))
	  {
	     didsize=1;
	     sprintf(ss,"%i",image_drawing->allocation.width);
	     gtk_entry_set_text(GTK_ENTRY(edwin.x_size),ss);
	     gtk_widget_queue_draw(edwin.x_size);
	     sprintf(ss,"%i",image_drawing->allocation.height);
	     gtk_entry_set_text(GTK_ENTRY(edwin.y_size),ss);
	     gtk_widget_queue_draw(edwin.y_size);
	  }
     }
}

void draw_mini_img(GtkWidget *widget, GdkEventConfigure *event) 
{
   if (!edwin.mini_image) return;
   if (edwin.mini_pmap) gdk_imlib_free_pixmap(edwin.mini_pmap);
   edwin.mini_pmap=NULL;
   gdk_imlib_render(image,edwin.mini_image->allocation.width,edwin.mini_image->allocation.height);
   edwin.mini_pmap=gdk_imlib_move_image(image);
   if (edwin.mini_image->window)
     {
	gdk_window_set_back_pixmap(edwin.mini_image->window,edwin.mini_pmap,FALSE);
	gdk_window_clear(edwin.mini_image->window);
	gdk_flush();
     }
}

void toggle_autoapply(GtkWidget *widget, GdkEventButton *event) 
{
   if (autoapply==1) autoapply=0;
   else autoapply=1;
   if (autoapply) draw_img(image_drawing,NULL);
}

void toggle_aspect(GtkWidget *widget, GdkEventButton *event) 
{
   if (keep_aspect==1) keep_aspect=0;
   else keep_aspect=1;
}

void button_win(GtkWidget *widget, GdkEventButton *event) 
{
   if (event->button==3) show_widget(NULL,(gpointer *)&control_window);
   else if (event->button==2) prev_img(NULL,NULL);
   else if (event->button==1) next_img(NULL,NULL);
}

void quit_app(GtkWidget *widget, gpointer *data)
{
   gtk_main_quit();
}

void changestyle()
{
   GtkStyle *style;
   
   style=gtk_style_new();
   if (style->font) gdk_font_unref(style->font);
   style->font=gdk_font_load("-*-helvetica-medium-r-*-*-8-*-*-*-p-*-*-*");
   gtk_widget_set_default_style(style);
}


/* Some state variables used only when parsing command-line
   arguments.  */
static char *cw;

static error_t parse_an_arg (int key, char *arg, struct argp_state *state)
{
   char *s;

   /* If we reached the end and didn't find a file, give an error.  */
   if (key == ARGP_KEY_SUCCESS && ! img_list)
      argp_usage (state);
   /* Otherwise, we only recognize files, not options.  */
   if (key != ARGP_KEY_ARG)
      return ARGP_ERR_UNKNOWN;
   if (*arg!='/')
      s = g_copy_strings (cw, "/", arg, NULL);
   else
      s = strdup (arg);
   img_list=g_list_append(img_list,s);
   return 0;
}

int main(int argc, char **argv)
{
   bindtextdomain (PACKAGE, GNOMELOCALEDIR);
   textdomain (PACKAGE);

   cw=cwd();

   img_list=NULL;
   gnome_init("ElectricEyes", &parser, argc, argv, 0, NULL);
   gdk_imlib_init();
   changestyle();

   free (cw);

   control_window=NULL;
   image_window=NULL;
   list_window=NULL;
   thumb_window=NULL;
   image=NULL;
   image_pixmap=NULL;
   image_drawing=NULL;
   logo_pmap=NULL;
   filesel=NULL;
   edwin.window=NULL;
   edwin.mini_pmap=NULL;
   edwin.mini_image=NULL;
   thumb_hboxlist=NULL;
   thumb_list=NULL;
   autoapply=0;
   keep_aspect=0;
   new_image=0;
   current_sel=0;
   new_draw=0;
   thumbsup=0;
   didsize=0;

     {
	GList *gl;

	gl=g_list_first(img_list);
	if (!gl){
		fprintf (stderr, _("No file was specified on the command line"));
		exit(0);
	}
	image=gdk_imlib_load_image(gl->data);
     }
   if (!image) gtk_main_quit();
   calc_mini();
   make_logo();
   create_image();
   create_progress();
   create_control();
   create_list();
   create_thumbnails();
   create_edit();
   configure_drop_regular_widget (image_drawing);
     {
        GList *gl;

	for(gl=img_list; gl!=NULL; gl=gl->next)
	   add_file_to_list(gl->data);
     }
   gtk_main();
}
