(dynamic-call 'scm_gtk_init (dynamic-link "./guile-gtk.so"))

(define (make-dialog-creator inner-creator)
  (let ((window #f))
    (lambda ()
      (if (or (not window) (gtk-destroyed? window))
	  (set! window (inner-creator)))
      (if (gtk-widget-visible? window)
	  (gtk-widget-destroy window)
	  (gtk-widget-show window)))))

(define (make-creator title inner-creator)
  (define (outer-creator)
    (let ((window (gtk-window-new GTK-WINDOW-TOPLEVEL))
	  (box1 (gtk-vbox-new 0 0))
	  (box2 (gtk-hbox-new 0 10))
	  (box3 (gtk-vbox-new 0 10))
	  (separator (gtk-hseparator-new))
	  (close (gtk-button-new-with-label "close"))
	  (buttons '()))
      (gtk-window-set-title window title)
      (gtk-container-border-width window 0)
      (gtk-container-add window box1)
      (gtk-widget-show box1)

      (gtk-box-pack-start box1 box3 1 1 0)
      (gtk-container-border-width box3 10)
      (gtk-widget-show box3)
      (set! buttons (inner-creator box3))
	       
      (gtk-box-pack-start box1 separator 0 1 0)
      (gtk-widget-show separator)
      (gtk-container-border-width box2 10)
      (gtk-box-pack-start box1 box2 0 1 0)
      (gtk-widget-show box2)
      (gtk-signal-connect close "clicked" 
			  (lambda () (gtk-widget-destroy window)))
      (gtk-box-pack-start box2 close 1 1 0)
      (gtk-widget-set-flags close GTK-CAN-DEFAULT)
      (gtk-widget-grab-default close)
      (gtk-widget-show close)
      (for-each (lambda (bt)
		  (let ((b (gtk-button-new-with-label (car bt))))
		    (gtk-box-pack-start box2 b 1 1 0)
		    (gtk-signal-connect b "clicked" (cadr bt))
		    (gtk-widget-show b)))
		buttons)
      window))
  (make-dialog-creator outer-creator))

(define-macro (define-test sym title . forms)
  `(define ,sym (make-creator ,title 
			      (lambda (outer-box) ,@forms))))

(define-macro (define-dialog-test sym . forms)
  `(define ,sym (make-dialog-creator (lambda () ,@forms))))

(define-test create-buttons "buttons"
  (let*                  ; name      x y clicked
      ((button-template '(("button1" 0 0 1)
			  ("button2" 1 1 2)
			  ("button3" 2 2 3)
			  ("button4" 0 2 4)
			  ("button5" 2 0 5)
			  ("button6" 1 2 6)
			  ("button7" 1 0 7)
			  ("button8" 2 1 8)
			  ("button9" 0 1 0)))
	(toggle-button (lambda (b)
			 (if (gtk-widget-visible? b)
			     (gtk-widget-hide b)
			     (gtk-widget-show b))))

	(table (gtk-table-new 3 3 0))
	(buttons (map (lambda (bt)
			(gtk-button-new-with-label (car bt)))
		      button-template)))

    (gtk-table-set-row-spacings table 5)
    (gtk-table-set-col-spacings table 5)
    (gtk-container-border-width table 0)
    (gtk-box-pack-start outer-box table 1 1 0)
    (gtk-widget-show table)
    
    (for-each 
     (lambda (b bt)
       (let ((x (cadr bt))
	     (y (caddr bt))
	     (clicked (list-ref buttons (cadddr bt))))
	 (gtk-signal-connect b "clicked" 
			     (lambda () (toggle-button clicked)))
	 (gtk-table-attach table b x (+ 1 x) y (+ 1 y)
			   (flags GTK-EXPAND GTK-FILL)
			   (flags GTK-EXPAND GTK-FILL)
			   0 0)
	 (gtk-widget-show b)))
     buttons button-template)

    '()))

(define (make-three-buttons outer-box maker)
  (map (lambda (l)
	 (let ((b (maker l)))
	   (gtk-box-pack-start outer-box b 1 1 0)
	   (gtk-widget-show b)
	   b))
       '("button1" "button2" "button3")))
  
(define-test create-toggle-buttons "toggle buttons"
  (make-three-buttons outer-box gtk-toggle-button-new-with-label)
  '())

(define-test create-check-buttons "check buttons"
  (make-three-buttons outer-box gtk-check-button-new-with-label)
  '())

(define-test create-radio-buttons "radio buttons"
  (let ((group #f))
    (define (radio-maker label)
      (let ((b (gtk-radio-button-new-with-label group label)))
	(set! group (gtk-radio-button-group b))
	b))
    (make-three-buttons outer-box radio-maker))
  '())

(define-test create-reparent "reparent"
  (let ((hbox (gtk-hbox-new 0 5))
	(label (gtk-label-new "Hello World")))
    (define (make-frame title init-label)
      (let ((frame (gtk-frame-new "Frame 1"))
	    (box (gtk-vbox-new 0 5))
	    (button (gtk-button-new-with-label "switch")))
	(gtk-box-pack-start hbox frame 1 1 0)
	(gtk-widget-show frame)
	(gtk-container-border-width box 5)
	(gtk-container-add frame box)
	(gtk-widget-show box)
	(gtk-signal-connect button "clicked" 
			    (lambda () (gtk-widget-reparent label box)))
	(gtk-box-pack-start box button 0 1 0)
	(gtk-widget-show button)
	(if init-label
	    (gtk-box-pack-start box label 0 1 0)
	    (gtk-widget-show label))))

    (gtk-box-pack-start outer-box hbox 1 1 0)
    (gtk-widget-show hbox)
    (make-frame "Frame 1" #t)
    (make-frame "Frame 2" #f)
    '()))

(define-test create-pixmap "pixmap"
  (let* ((button (gtk-button-new))
	 (mask (make-NULL-GdkBitmap*))
	 (bg-color (make-GdkColor*))
	 (dummy (gdk-color-parse "#FF00FF" bg-color))
	 (pixmap (gdk-pixmap-create-from-xpm #f mask bg-color "test.xpm"))
	 (pixmapwid (gtk-pixmap-new pixmap mask))
	 (label (gtk-label-new "Pixmap test\n"))
	 (hbox (gtk-hbox-new 0 0)))
    (gtk-box-pack-start outer-box button 0 0 0)
    (gtk-widget-show button)
    (gtk-container-border-width hbox 2)
    (gtk-container-add hbox pixmapwid)
    (gtk-container-add hbox label)
    (gtk-container-add button hbox)
    (gtk-widget-show pixmapwid)
    (gtk-widget-show label)
    (gtk-widget-show hbox)
    '()))

(define-test create-tooltips "tooltips"
  (let ((tooltips (gtk-tooltips-new))
	(buttons  (make-three-buttons outer-box
				      gtk-toggle-button-new-with-label)))
    (for-each (lambda (b tip)
		(gtk-tooltips-set-tips tooltips b tip))
	      buttons
	      '("This is button 1"
		"This is button 2"
		"This is button 3. This is also a really long tooltip which probably won't fit on a single line and will therefore need to be wrapped. Hopefully the wrapping will work correctly."))
    '()))
	
(define (make-menu depth)
  (if (< depth 1)
      #f
      (let ((menu (gtk-menu-new))
	    (submenu (make-menu (1- depth)))
	    (group #f))
	(do ((i 0 (1+ i))
	     (j 1 (1+ j)))
	    ((= i 6))
	  (let ((menuitem (gtk-radio-menu-item-new-with-label group
			   (string-append "item " (number->string depth)
					  " - " (number->string j)))))
	    (set! group (gtk-radio-menu-item-group menuitem))
	    (gtk-menu-append menu menuitem)
	    (gtk-widget-show menuitem)
	    (if submenu
		(gtk-menu-item-set-submenu menuitem submenu))))
	menu)))
      
(define-test create-menus "menus"
  (let ((menubar (gtk-menu-bar-new))
	(menu (make-menu 2))
	(optionmenu (gtk-option-menu-new)))
    (gtk-box-pack-start outer-box menubar 0 1 0)
    (gtk-widget-show menubar)
    (for-each (lambda (label)
		(let ((menuitem (gtk-menu-item-new-with-label label)))
		  (gtk-menu-item-set-submenu menuitem menu)
		  (gtk-menu-bar-append menubar menuitem)
		  (gtk-widget-show menuitem)))
	      '("test" "foo" "bar"))
    (gtk-option-menu-set-menu optionmenu (make-menu 1))
    (gtk-option-menu-set-history optionmenu 4)
    (gtk-box-pack-start outer-box optionmenu 1 1 0)
    (gtk-widget-show optionmenu)
    '()))

(define create-scrolled-windows #f)
(define create-entry #f)

(define-test create-list "list"
  (let ((list-items '("hello" 
		      "world"
		      "blah"
		      "foo"
		      "bar"
		      "argh"
		      "spencer"
		      "is a"
		      "wussy"
		      "programmer"))
	(scrolled-win (gtk-scrolled-window-new #f #f))
	(lyst (gtk-list-new))
	(add (gtk-button-new-with-label "add"))
	(remove (gtk-button-new-with-label "remove")))
	     
    (gtk-scrolled-window-set-policy scrolled-win
				    GTK-POLICY-AUTOMATIC GTK-POLICY-AUTOMATIC)
    (gtk-box-pack-start outer-box scrolled-win 1 1 0)
    (gtk-widget-show scrolled-win)

    (gtk-list-set-selection-mode lyst GTK-SELECTION-MULTIPLE)
    ; (gtk-list-set-selection-mode lyst GTK-SELECTION-BROWSE)
    (gtk-container-add scrolled-win lyst)
    (gtk-widget-show lyst)

    (for-each (lambda (i)
		(let ((list-item (gtk-list-item-new-with-label i)))
		  (gtk-container-add lyst list-item)
		  (gtk-widget-show list-item)))
	      list-items)
    
    (gtk-signal-connect add "clicked" (lambda () (pk 'add)))
    (gtk-box-pack-start outer-box add 0 1 0)
    (gtk-widget-show add)

    (gtk-signal-connect remove "clicked" (lambda () (pk 'remove)))
    (gtk-box-pack-start outer-box remove 0 1 0)
    (gtk-widget-show remove)

    '()))

(define-dialog-test create-color-selection
  (let ((window #f))
    (gtk-preview-set-install-cmap 1)
    (gtk-widget-push-visual (gtk-preview-get-visual))
    (gtk-widget-push-colormap (gtk-preview-get-cmap))
    
    (set! window (gtk-color-selection-dialog-new
		  "color selection dialog"))
    (let ((colorsel (gtk-color-selection-dialog-colorsel window)))
      (gtk-signal-connect colorsel "color_changed" 
			  (lambda () (pk 'changed))))
    (gtk-signal-connect
     (gtk-color-selection-dialog-ok-button window)
     "clicked" (lambda () (pk 'ok)))
    (gtk-signal-connect 
     (gtk-color-selection-dialog-cancel-button window)
     "clicked" (lambda () (gtk-widget-destroy window)))
    
    (gtk-widget-pop-colormap)
    (gtk-widget-pop-visual)
    window))

(define create-file-selection #f)
(define create-dialog #f)

(define-test create-range-controls "range controls"
  (let* ((adjustment (gtk-adjustment-new 0.0 0.0 101.0 0.1 1.0 1.0))
	 (scale (gtk-hscale-new adjustment))
	 (scrollbar (gtk-hscrollbar-new adjustment)))

    (gtk-widget-set-usize scale 150 30)
    (gtk-range-set-update-policy scale GTK-UPDATE-DELAYED);
    (gtk-scale-set-digits scale 1)
    (gtk-scale-set-draw-value scale 1)
    (gtk-box-pack-start outer-box scale 1 1 0)
    (gtk-widget-show scale)

    (gtk-range-set-update-policy scrollbar GTK-UPDATE-CONTINUOUS)
    (gtk-box-pack-start outer-box scrollbar 1 1 0)
    (gtk-widget-show scrollbar)

    '()))

(define create-rulers #f)
(define create-text #f)

(define-test create-notebook "notebook" 
  (let ((notebook (gtk-notebook-new)))
    (gtk-notebook-set-tab-pos notebook GTK-POS-TOP)
    (gtk-box-pack-start outer-box notebook 1 1 0)
    (gtk-widget-show notebook)

    (do ((i 1 (1+ i)))
	((= i 20))
      (let* ((text (string-append "Page " (number->string i)))
	     (frame (gtk-frame-new text))
	     (label1 (gtk-label-new text))
	     (label2 (gtk-label-new text)))
	(gtk-container-border-width frame 10)
	(gtk-widget-set-usize frame 200 150)
	(gtk-widget-show frame)
	(gtk-container-add frame label1)
	(gtk-widget-show label1)
	(gtk-notebook-append-page notebook frame label2)))

    `(("next" ,(lambda () 
		 (gtk-notebook-next-page notebook)))
      ("prev" ,(lambda ()
		 (gtk-notebook-prev-page notebook)))
      ("rotate" ,(lambda ()
		   (gtk-notebook-set-tab-pos 
		    notebook
		    (remainder (+ (gtk-notebook-tab-pos notebook) 1) 4)))))))

(define-dialog-test create-progress-bar
  (let* ((timer 0)
	 (window (gtk-dialog-new))
	 (vbox (gtk-vbox-new 0 5))
	 (label (gtk-label-new "progress..."))
	 (pbar (gtk-progress-bar-new))
	 (button (gtk-button-new-with-label "close")))
    
    (define (timeout)
      (let ((new-val (gtk-progress-bar-percentage pbar)))
	(if (>= new-val 1)
	    (set! new-val 0))
	(set! new-val (+ new-val 0.02))
	(gtk-progress-bar-update pbar new-val)))

    (gtk-signal-connect window "destroy" (lambda () 
					   (gtk-timeout-remove timer)
					   (set! timer 0)))
    (gtk-container-border-width vbox 10)
    (gtk-box-pack-start (gtk-dialog-vbox window) vbox 1 1 0)
    (gtk-widget-show vbox)
    (gtk-misc-set-alignment label 0.0 0.5)
    (gtk-box-pack-start vbox label 0 1 0)
    (gtk-widget-show label)
    (gtk-widget-set-usize pbar 200 20)
    (gtk-box-pack-start vbox pbar 1 1 0)
    (gtk-widget-show pbar)

    (set! timer (gtk-timeout-add 100 timeout))

    (gtk-signal-connect button "clicked" 
			(lambda () (gtk-widget-destroy window)))
    (gtk-widget-set-flags button GTK-CAN-DEFAULT)
    (gtk-box-pack-start (gtk-dialog-action-area window) button 1 1 0)
    (gtk-widget-grab-default button)
    (gtk-widget-show button)

    window))

(define create-color-preview #f)
(define create-gray-preview #f)
(define create-curve #f)
(define create-timeout-test #f)
(define create-idle-test #f)
(define create-test #f)

(define (create-main-window)
  (define buttons
    `(("buttons" ,create-buttons)
      ("toggle buttons" ,create-toggle-buttons)
      ("check buttons" ,create-check-buttons)
      ("radio buttons" ,create-radio-buttons)
      ("reparent" ,create-reparent)
      ("pixmap" ,create-pixmap)
      ("tooltips" ,create-tooltips)
      ("menus" ,create-menus)
      ("scrolled windows" ,create-scrolled-windows)
      ("drawing areas" #f)
      ("entry" ,create-entry)
      ("list" ,create-list)
      ("color selection" ,create-color-selection)
      ("file selection" ,create-file-selection)
      ("dialog" ,create-dialog)
      ("miscellaneous" #f)
      ("range controls" ,create-range-controls)
      ("rulers" ,create-rulers)
      ("text" ,create-text)
      ("notebook" ,create-notebook)
      ("progress bar" ,create-progress-bar)
      ("preview color" ,create-color-preview)
      ("preview gray" ,create-gray-preview)
      ("curve" ,create-curve)
      ("test timeout" ,create-timeout-test)
      ("test idle" ,create-idle-test)
      ("test" ,create-test)))

  (let ((window (gtk-window-new GTK-WINDOW-TOPLEVEL))
	(box1   (gtk-vbox-new 0 0))
	(box2   (gtk-vbox-new 0 0))
	(separator (gtk-hseparator-new))
	(box3   (gtk-vbox-new 0 10))
	(button (gtk-button-new-with-label "close")))

    (gtk-widget-set-name window "main window")
    (gtk-widget-set-uposition window 20 20)
    (gtk-container-add window box1)
    (gtk-widget-show box1)
    (gtk-container-border-width box2 10)
    (gtk-box-pack-start box1 box2 1 1 0)
    (gtk-widget-show box2)
    
    (for-each (lambda (b)
		(let ((button (gtk-button-new-with-label (car b))))
		  (if (cadr b)
		      (gtk-signal-connect button "clicked" (cadr b))
		      (gtk-widget-set-sensitive button 0))
		  (gtk-box-pack-start box2 button 1 1 0)
		  (gtk-widget-show button)))
	      buttons)

    (gtk-box-pack-start box1 separator 0 1 0)
    (gtk-widget-show separator)
    (gtk-container-border-width box3 10)
    (gtk-box-pack-start box1 box3 0 1 0)
    (gtk-widget-show box3)
    (gtk-signal-connect button "clicked" (lambda () (gtk-exit 0)))
    (gtk-box-pack-start box3 button 1 1 0)
    (gtk-widget-set-flags button GTK-CAN-DEFAULT)
    (gtk-widget-grab-default button)
    (gtk-widget-show button)

    (gtk-widget-show window)))
    
(gtk-init '())
(gtk-rc-parse "testgtkrc")
(create-main-window)
(gtk-main)
