(defvar gtk-types ())

(defun gtk-add-type (type)
  (if (and (not (memq type gtk-types))
	   (gtk-sane-type-p type))
      (setq gtk-types (cons type gtk-types))))

(defun gtk-get-funcs ()
  (let ((f ()))
    (while (re-search-forward 
	    "^\\([a-zA-Z_* ]*\\)\\(g[td]k_[a-z_]*\\)[ \t\n]*(\\([^;]*\\));$"
	    nil t)
      (let ((rettype (match-string 1))
	    (name (match-string 2))
	    (args (match-string 3)))
	(setq f (cons (gtk-make-func rettype name args) f))))
    (reverse f)))

(defun gtk-make-func (ret name args)
  (let ((args (gtk-split-args args)))
    (list (gtk-hack-type ret)
	  (gtk-hack-func-name name)
	  (mapcar 'gtk-hack-type args))))

(defun gtk-remove-matches (regex str)
  (while (string-match regex str)
    (setq str (replace-match "" t t str nil)))
  str)

(defun gtk-hack-type (type)
  (setq type (gtk-remove-matches "const" type))
  (let ((type (intern (if (string-match "Gtk\\([a-zA-Z]*\\).*\\*" type)
			  (gtk-hack-gtk-type (match-string 1 type))
			(if (string-match "\\([a-z]* *\\**\\)" type)
			    (gtk-remove-blanks (match-string 1 type))
			  (error "unrecognized type %S" type))))))
    (if (equal (symbol-name type) "")
	'dots
      type)))

(defun gtk-hack-gtk-type (type)
  (let ((case-fold-search nil))
    (while (string-match "\\([a-z]\\)\\([A-Z]\\)" type)
      (setq type (replace-match (format "%s-%s" 
					(match-string 1 type) 
					(match-string 2 type))
				t t type nil))))
  (setq type (downcase type))
  (if (equal "list" type)
      (setq type "list-widget"))
  (gtk-add-type (intern type))
  type)
			     
(defun gtk-hack-func-name (n)
  (intern (char-list-to-string
	   (mapcar #'(lambda (ch) (if (eq ch ?_) ?- ch)) n))))

(defun gtk-split-args1 (args)
  (message "splitting %S" args)
  (let ((res (gtk-split-args1 args)))
    (message "result %S" res)
    res))

(defun gtk-split-args (args)
  (let ((argl ()))
    (while (string-match "\\([^,]*\\),[ \t\n]*" args)
      (setq argl (cons (match-string 1 args) argl))
      (setq args (substring args (match-end 0))))
    (reverse (cons args argl))))

(defun gtk-remove-blanks (str)
  (delete-if #'(lambda (ch) (eq (char-syntax ch) ?\ )) str))

(setq gtk-sane-pointer-types '(char* gchar*))
(setq gtk-invalid-types 
      '(dots arg GtkArgType GtkSignalFunc GtkCallback
	     GtkSignalMarshal GtkSignalDestroy
	     GtkMenuPositionFunc gpointer
	     int* gint* gpointer* gulong* gdouble*))

(defun gtk-sane-type-p1 (type)
  (let ((str (symbol-name type)))
    (not (or (string-match "gdk" str)
	     (string-match "\\*\\*" str)
	     (and (string-match "\\*" str)
		  (not (memq type gtk-sane-pointer-types)))
	     (memq type gtk-invalid-types)
	     (equal "" (symbol-name type))))))

(defun gtk-sane-type-p (type)
  (not (or (string-match "\\*\\*" (symbol-name type))
	   (memq type gtk-invalid-types))))

(defun gtk-sane-func-p (func)
  (and (gtk-sane-type-p (car func))
       (every 'gtk-sane-type-p (caddr func))))

(defun gtk-insert-types ()
  (interactive)
  (insert (format "%S\n" gtk-types)))

(defun gtk-insert-funcs ()
  (interactive)
  (mapc #'(lambda (f)
	    (if (not (gtk-sane-func-p f))
		(insert "; "))
	    (insert (format "%S" f))
	    (indent-for-tab-command)
	    (insert "\n"))
	gtk-funcs))

(defun gtk-hack-file ()
  (interactive)
  (goto-char (point-min))
  (setq gtk-types '())
  (setq gtk-funcs (gtk-get-funcs)))

(defvar gtk-enums '())

(defun gtk-insert-enums ()
  (interactive)
  (insert (format "%S" (reverse gtk-enums))))

(defun gtk-hack-enum ()
  (goto-char (point-min))
  (while (search-forward-regexp "G[TD]K_[A-Z0-9_]*" nil t)
    (setq gtk-enums (cons (intern (match-string 0)) gtk-enums))))

(defun gtk-hack-enums ()
  (interactive)
  (setq gtk-enums '())
  (goto-char (point-min))
  (while (search-forward "enum" nil t)
    (let ((min (point)))
      (forward-sexp)
      (save-excursion
	(save-restriction
	  (narrow-to-region min (point))
	  (gtk-hack-enum))))))
