(define-module (gtk-wrap)
  :use-module (g-wrap))

(define-public (make-gtk-type struct cast type-getter)
  (make-c-type (string-append struct "*")
	       (lambda (x) (list "wrap_gtkobj (GTK_OBJECT (" x "))"))
	       (lambda (x) (list cast " (get_gtkobj (" x "))"))
	       (lambda (x) (list "is_a_gtkobj (" type-getter" (), " x ")"))))

(define-public (make-simple-gtk-type tag)
  (let* ((gtk-tag (string-append "gtk-" tag))
	 (gtk_tag (dash->underline gtk-tag))
	 (type (make-gtk-type (capsify gtk-tag)
			      (string-upcase gtk_tag)
			      (string-append gtk_tag "_get_type"))))
    (new-predicate (string-append gtk_tag "_p")
		   (string-append gtk-tag "?")
		   type)
    type))

(define-public (make-typed-ptr-type name)
  (let ((tptr-type (string-append "tptr_typeid_" (nonid->underline name))))
    (output-c 'type-headers "SCM " tptr-type ";\n")
    (output-c 'type-inits "  " tptr-type " = new_tptr (\"" name "\");\n")
    (make-c-type name
		 (lambda (x) (list "wrap_tptr ((void *)" x ", " tptr-type ")"))
		 (lambda (x) (list "((" name ")get_tptr_ptr(" x "))"))
		 (lambda (x) (list "is_tptr_type(" x ", " tptr-type ")")))))

(define-public (make-ptr-ptr-type type)
  (let* ((name (c-type-name type))
	 (tptr-type (string-append "tptr_typeid_" (nonid->underline name)))
	 (null-maker (string-append "make-NULL-" name))
	 (c-name (string-append "tptr_" (nonid->underline null-maker))))
    (new-c-code c-name null-maker
		type
		(list "  ret = 0;\n")
		'()
		"")
    (make-c-type (string-append name "*")
		 (lambda (x) (error "can't return ptrptrs" name))
		 (lambda (x) (list "(" x " == SCM_BOOL_F)? 0 : ((" name "*)&SCM_CDR(" x "))"))
		 (lambda (x) (list "is_tptr_type(" x ", " tptr-type ")")))))
		
(define (map-string thunk str)
  (list->string (map thunk (string->list str))))

(define (dash->underline str)
  (map-string (lambda (ch) (if (char=? ch #\-) #\_ ch)) str))

(define (underline->dash str)
  (map-string (lambda (ch) (if (char=? ch #\_) #\- ch)) str))

(define (string-upcase str)
  (map-string char-upcase str))

(define (nonid->underline str)
  (map-string (lambda (ch) 
		(if (or (char-alphabetic? ch) (char-numeric? ch))
		    ch
		    #\_))
	      str))

(define (capsify str)
  (define (list-capsify lst upcase)
    (cond ((null? lst)
	   '())
	  (upcase
	   (cons (char-upcase (car lst))
		 (list-capsify (cdr lst) #f)))
	  ((char=? (car lst) #\-)
	   (list-capsify (cdr lst) #t))
	  (else
	   (cons (car lst) (list-capsify (cdr lst) #f)))))
  (list->string (list-capsify (string->list str) #t)))

(defmacro-public wrap-gtk-types types
  `(begin ,@(map (lambda (t)
		   (if (symbol? t)
		       `(define ,t (make-simple-gtk-type ',t))
		       `(define ,(car t)
			  (make-gtk-type ,@(cdr t)))))
		 types)))

(defmacro-public wrap-gtk-funcs funcs
  `(begin ,@(map (lambda (f)
		   `(new-function ,(dash->underline (cadr f))
				  ,(symbol->string (cadr f))
				  ,(car f)
				  (list ,@(caddr f))
				  ""))
		 funcs)))

(defmacro-public wrap-gtk-consts consts
  `(begin ,@(map (lambda (c)
		   (let ((dashed (string->symbol (underline->dash (symbol->string c)))))
		     `(define-constant ',dashed ',c int)))
		 consts)))

(defmacro-public wrap-gtk-accessors (type . elements)
  `(begin ,@(map (lambda (el)
		   (let* ((el-type (car el))
			  (el-name (cadr el))
			  (scm-name (string-append "gtk-" type "-" el-name))
			  (c-name (dash->underline scm-name)))
		     `(new-c-code ,c-name ,scm-name
				  ,el-type
				  (list "  ret = param0->" 
					,(dash->underline el-name)
					";\n")
				  (list ,type)
				  "")))
		 elements)))

(defmacro-public wrap-gtk-typed-ptrs names
  `(begin ,@(map (lambda (name)
		   `(define ,name (make-typed-ptr-type ',name)))
		 names)))

(define-public char* 
  (make-c-type "char*"
	       (lambda (x) (list "scm_makfrom0str (" x ")"))
	       (lambda (x) (list "SCM_CHARS (" x ")"))
	       (lambda (x) (list "SCM_NIMP (" x ") && SCM_STRINGP (" x ")"))))

(define-public bool
  (make-c-type "int"
	       (lambda (x) (list "((" x ")? SCM_BOOL_T : SCM_BOOL_F)"))
	       (lambda (x) (list "((" x ") == SCM_BOOL_T)"))
	       (lambda (x) (list "SCM_BOOLP (" x ")"))))

(define-public void*
  (make-c-type "void*"
	       (lambda (x) (list "scm_ulong2num ((unsigned long)" x ")"))
	       (lambda (x) (list "(void *)scm_num2ulong (" x ", (char *)SCM_ARG1, \"void*\")"))
	       (lambda (x) (list "TRUE"))))
