// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{DBusInterface, DBusObject};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GDBusObjectManager")]
    pub struct DBusObjectManager(Interface<ffi::GDBusObjectManager, ffi::GDBusObjectManagerIface>);

    match fn {
        type_ => || ffi::g_dbus_object_manager_get_type(),
    }
}

impl DBusObjectManager {
    pub const NONE: Option<&'static DBusObjectManager> = None;
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::DBusObjectManager>> Sealed for T {}
}

pub trait DBusObjectManagerExt: IsA<DBusObjectManager> + sealed::Sealed + 'static {
    #[doc(alias = "g_dbus_object_manager_get_interface")]
    #[doc(alias = "get_interface")]
    fn interface(&self, object_path: &str, interface_name: &str) -> Option<DBusInterface> {
        unsafe {
            from_glib_full(ffi::g_dbus_object_manager_get_interface(
                self.as_ref().to_glib_none().0,
                object_path.to_glib_none().0,
                interface_name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_object_manager_get_object")]
    #[doc(alias = "get_object")]
    fn object(&self, object_path: &str) -> Option<DBusObject> {
        unsafe {
            from_glib_full(ffi::g_dbus_object_manager_get_object(
                self.as_ref().to_glib_none().0,
                object_path.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_object_manager_get_object_path")]
    #[doc(alias = "get_object_path")]
    fn object_path(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::g_dbus_object_manager_get_object_path(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_object_manager_get_objects")]
    #[doc(alias = "get_objects")]
    fn objects(&self) -> Vec<DBusObject> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::g_dbus_object_manager_get_objects(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "interface-added")]
    fn connect_interface_added<F: Fn(&Self, &DBusObject, &DBusInterface) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn interface_added_trampoline<
            P: IsA<DBusObjectManager>,
            F: Fn(&P, &DBusObject, &DBusInterface) + 'static,
        >(
            this: *mut ffi::GDBusObjectManager,
            object: *mut ffi::GDBusObject,
            interface: *mut ffi::GDBusInterface,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                DBusObjectManager::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(object),
                &from_glib_borrow(interface),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"interface-added\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    interface_added_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "interface-removed")]
    fn connect_interface_removed<F: Fn(&Self, &DBusObject, &DBusInterface) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn interface_removed_trampoline<
            P: IsA<DBusObjectManager>,
            F: Fn(&P, &DBusObject, &DBusInterface) + 'static,
        >(
            this: *mut ffi::GDBusObjectManager,
            object: *mut ffi::GDBusObject,
            interface: *mut ffi::GDBusInterface,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                DBusObjectManager::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(object),
                &from_glib_borrow(interface),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"interface-removed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    interface_removed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "object-added")]
    fn connect_object_added<F: Fn(&Self, &DBusObject) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn object_added_trampoline<
            P: IsA<DBusObjectManager>,
            F: Fn(&P, &DBusObject) + 'static,
        >(
            this: *mut ffi::GDBusObjectManager,
            object: *mut ffi::GDBusObject,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                DBusObjectManager::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(object),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"object-added\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    object_added_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "object-removed")]
    fn connect_object_removed<F: Fn(&Self, &DBusObject) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn object_removed_trampoline<
            P: IsA<DBusObjectManager>,
            F: Fn(&P, &DBusObject) + 'static,
        >(
            this: *mut ffi::GDBusObjectManager,
            object: *mut ffi::GDBusObject,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                DBusObjectManager::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(object),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"object-removed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    object_removed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<DBusObjectManager>> DBusObjectManagerExt for O {}
