// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Rect, Vec3};
use glib::translate::*;

glib::wrapper! {
    pub struct Point3D(BoxedInline<ffi::graphene_point3d_t>);

    match fn {
        copy => |ptr| glib::gobject_ffi::g_boxed_copy(ffi::graphene_point3d_get_type(), ptr as *mut _) as *mut ffi::graphene_point3d_t,
        free => |ptr| glib::gobject_ffi::g_boxed_free(ffi::graphene_point3d_get_type(), ptr as *mut _),
        type_ => || ffi::graphene_point3d_get_type(),
    }
}

impl Point3D {
    #[doc(alias = "graphene_point3d_cross")]
    #[must_use]
    pub fn cross(&self, b: &Point3D) -> Point3D {
        unsafe {
            let mut res = Point3D::uninitialized();
            ffi::graphene_point3d_cross(
                self.to_glib_none().0,
                b.to_glib_none().0,
                res.to_glib_none_mut().0,
            );
            res
        }
    }

    #[doc(alias = "graphene_point3d_distance")]
    pub fn distance(&self, b: &Point3D) -> (f32, Vec3) {
        unsafe {
            let mut delta = Vec3::uninitialized();
            let ret = ffi::graphene_point3d_distance(
                self.to_glib_none().0,
                b.to_glib_none().0,
                delta.to_glib_none_mut().0,
            );
            (ret, delta)
        }
    }

    #[doc(alias = "graphene_point3d_dot")]
    pub fn dot(&self, b: &Point3D) -> f32 {
        unsafe { ffi::graphene_point3d_dot(self.to_glib_none().0, b.to_glib_none().0) }
    }

    #[doc(alias = "graphene_point3d_equal")]
    fn equal(&self, b: &Point3D) -> bool {
        unsafe { ffi::graphene_point3d_equal(self.to_glib_none().0, b.to_glib_none().0) }
    }

    #[doc(alias = "graphene_point3d_interpolate")]
    #[must_use]
    pub fn interpolate(&self, b: &Point3D, factor: f64) -> Point3D {
        unsafe {
            let mut res = Point3D::uninitialized();
            ffi::graphene_point3d_interpolate(
                self.to_glib_none().0,
                b.to_glib_none().0,
                factor,
                res.to_glib_none_mut().0,
            );
            res
        }
    }

    #[doc(alias = "graphene_point3d_length")]
    pub fn length(&self) -> f32 {
        unsafe { ffi::graphene_point3d_length(self.to_glib_none().0) }
    }

    #[doc(alias = "graphene_point3d_near")]
    pub fn near(&self, b: &Point3D, epsilon: f32) -> bool {
        unsafe { ffi::graphene_point3d_near(self.to_glib_none().0, b.to_glib_none().0, epsilon) }
    }

    #[doc(alias = "graphene_point3d_normalize")]
    #[must_use]
    pub fn normalize(&self) -> Point3D {
        unsafe {
            let mut res = Point3D::uninitialized();
            ffi::graphene_point3d_normalize(self.to_glib_none().0, res.to_glib_none_mut().0);
            res
        }
    }

    #[doc(alias = "graphene_point3d_normalize_viewport")]
    #[must_use]
    pub fn normalize_viewport(&self, viewport: &Rect, z_near: f32, z_far: f32) -> Point3D {
        unsafe {
            let mut res = Point3D::uninitialized();
            ffi::graphene_point3d_normalize_viewport(
                self.to_glib_none().0,
                viewport.to_glib_none().0,
                z_near,
                z_far,
                res.to_glib_none_mut().0,
            );
            res
        }
    }

    #[doc(alias = "graphene_point3d_scale")]
    #[must_use]
    pub fn scale(&self, factor: f32) -> Point3D {
        unsafe {
            let mut res = Point3D::uninitialized();
            ffi::graphene_point3d_scale(self.to_glib_none().0, factor, res.to_glib_none_mut().0);
            res
        }
    }

    #[doc(alias = "graphene_point3d_to_vec3")]
    pub fn to_vec3(&self) -> Vec3 {
        unsafe {
            let mut v = Vec3::uninitialized();
            ffi::graphene_point3d_to_vec3(self.to_glib_none().0, v.to_glib_none_mut().0);
            v
        }
    }

    #[doc(alias = "graphene_point3d_zero")]
    pub fn zero() -> Point3D {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::graphene_point3d_zero()) }
    }
}

impl PartialEq for Point3D {
    #[inline]
    fn eq(&self, other: &Self) -> bool {
        self.equal(other)
    }
}

impl Eq for Point3D {}
