// Generated by gmmproc 2.78.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/subprocess.h>
#include <giomm/private/subprocess_p.h>


/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <giomm/slot_async.h>
#include <gio/gio.h>

namespace Gio
{
Subprocess::Subprocess(const std::vector<std::string>& argv, Flags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(subprocess_class_.init(), "argv",Glib::ArrayHandler<std::string>::vector_to_array(argv).data(),"flags",(GSubprocessFlags)flags, nullptr))
{
  init();
}

std::pair<Glib::RefPtr<Glib::Bytes>, Glib::RefPtr<Glib::Bytes>>
Subprocess::communicate(const Glib::RefPtr<const Glib::Bytes>& stdin_buf,
  const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  GBytes* gstdout_buf = nullptr;
  GBytes* gstderr_buf = nullptr;
  (void)g_subprocess_communicate(gobj(),
    const_cast<GBytes*>(Glib::unwrap(stdin_buf)),
    Glib::unwrap(cancellable), &gstdout_buf, &gstderr_buf, &gerror);
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return {Glib::wrap(gstdout_buf), Glib::wrap(gstderr_buf)};
}

std::pair<Glib::RefPtr<Glib::Bytes>, Glib::RefPtr<Glib::Bytes>>
Subprocess::communicate_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  GBytes* gstdout_buf = nullptr;
  GBytes* gstderr_buf = nullptr;
  (void)g_subprocess_communicate_finish(gobj(), Glib::unwrap(result),
    &gstdout_buf, &gstderr_buf, &gerror);
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return {Glib::wrap(gstdout_buf), Glib::wrap(gstderr_buf)};
}

std::pair<Glib::ustring, Glib::ustring>
Subprocess::communicate_utf8(const Glib::ustring& stdin_buf,
  const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  char* gstdout_buf = nullptr;
  char* gstderr_buf = nullptr;
  (void)g_subprocess_communicate_utf8(gobj(), Glib::c_str_or_nullptr(stdin_buf),
    Glib::unwrap(cancellable), &gstdout_buf, &gstderr_buf, &gerror);
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return {Glib::convert_return_gchar_ptr_to_ustring(gstdout_buf),
          Glib::convert_return_gchar_ptr_to_ustring(gstderr_buf)};
}

std::pair<Glib::ustring, Glib::ustring>
Subprocess::communicate_utf8_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  char* gstdout_buf = nullptr;
  char* gstderr_buf = nullptr;
  (void)g_subprocess_communicate_utf8_finish(gobj(), Glib::unwrap(result),
    &gstdout_buf, &gstderr_buf, &gerror);
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return {Glib::convert_return_gchar_ptr_to_ustring(gstdout_buf),
          Glib::convert_return_gchar_ptr_to_ustring(gstderr_buf)};
}

} // namespace Gio

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gio::Subprocess::Flags>::value_type()
{
  return g_subprocess_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Gio::Subprocess> wrap(GSubprocess* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gio::Subprocess>( dynamic_cast<Gio::Subprocess*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& Subprocess_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Subprocess_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_subprocess_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Initable::add_interface(get_type());

  }

  return *this;
}


void Subprocess_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Subprocess_Class::wrap_new(GObject* object)
{
  return new Subprocess((GSubprocess*)object);
}


/* The implementation: */

GSubprocess* Subprocess::gobj_copy()
{
  reference();
  return gobj();
}

Subprocess::Subprocess(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Subprocess::Subprocess(GSubprocess* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Subprocess::Subprocess(Subprocess&& src) noexcept
: Glib::Object(std::move(src))
  , Initable(std::move(src))
{}

Subprocess& Subprocess::operator=(Subprocess&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  Initable::operator=(std::move(src));
  return *this;
}


Subprocess::~Subprocess() noexcept
{}


Subprocess::CppClassType Subprocess::subprocess_class_; // initialize static member

GType Subprocess::get_type()
{
  return subprocess_class_.init().get_type();
}


GType Subprocess::get_base_type()
{
  return g_subprocess_get_type();
}


Glib::RefPtr<Subprocess> Subprocess::create(const std::vector<std::string>& argv, Flags flags)
{
  return Glib::make_refptr_for_instance<Subprocess>( new Subprocess(argv, flags) );
}

Glib::RefPtr<OutputStream> Subprocess::get_stdin_pipe()
{
  auto retvalue = Glib::wrap(g_subprocess_get_stdin_pipe(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const OutputStream> Subprocess::get_stdin_pipe() const
{
  return const_cast<Subprocess*>(this)->get_stdin_pipe();
}

Glib::RefPtr<InputStream> Subprocess::get_stdout_pipe()
{
  auto retvalue = Glib::wrap(g_subprocess_get_stdout_pipe(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const InputStream> Subprocess::get_stdout_pipe() const
{
  return const_cast<Subprocess*>(this)->get_stdout_pipe();
}

Glib::RefPtr<InputStream> Subprocess::get_stderr_pipe()
{
  auto retvalue = Glib::wrap(g_subprocess_get_stderr_pipe(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const InputStream> Subprocess::get_stderr_pipe() const
{
  return const_cast<Subprocess*>(this)->get_stderr_pipe();
}

Glib::ustring Subprocess::get_identifier() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(g_subprocess_get_identifier(const_cast<GSubprocess*>(gobj())));
}

#ifdef G_OS_UNIX
void Subprocess::send_signal(int signal_num)
{
  g_subprocess_send_signal(gobj(), signal_num);
}
#endif // G_OS_UNIX

void Subprocess::force_exit()
{
  g_subprocess_force_exit(gobj());
}

void Subprocess::wait(const Glib::RefPtr<Cancellable>& cancellable) const
{
  GError* gerror = nullptr;
  g_subprocess_wait(const_cast<GSubprocess*>(gobj()), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Subprocess::wait_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable) const
{
  // Create a copy of the slot.
  auto slot_copy = new SlotAsyncReady(slot); 

  g_subprocess_wait_async(const_cast<GSubprocess*>(gobj()), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &giomm_SignalProxy_async_callback, slot_copy);
}

void Subprocess::wait_finish(const Glib::RefPtr<AsyncResult>& result) const
{
  GError* gerror = nullptr;
  g_subprocess_wait_finish(const_cast<GSubprocess*>(gobj()), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Subprocess::wait_check(const Glib::RefPtr<Cancellable>& cancellable) const
{
  GError* gerror = nullptr;
  g_subprocess_wait_check(const_cast<GSubprocess*>(gobj()), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Subprocess::wait_check_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable) const
{
  // Create a copy of the slot.
  auto slot_copy = new SlotAsyncReady(slot); 

  g_subprocess_wait_check_async(const_cast<GSubprocess*>(gobj()), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &giomm_SignalProxy_async_callback, slot_copy);
}

void Subprocess::wait_check_finish(const Glib::RefPtr<AsyncResult>& result) const
{
  GError* gerror = nullptr;
  g_subprocess_wait_check_finish(const_cast<GSubprocess*>(gobj()), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

int Subprocess::get_status() const
{
  return g_subprocess_get_status(const_cast<GSubprocess*>(gobj()));
}

bool Subprocess::get_successful() const
{
  return g_subprocess_get_successful(const_cast<GSubprocess*>(gobj()));
}

bool Subprocess::get_if_exited() const
{
  return g_subprocess_get_if_exited(const_cast<GSubprocess*>(gobj()));
}

int Subprocess::get_exit_status() const
{
  return g_subprocess_get_exit_status(const_cast<GSubprocess*>(gobj()));
}

bool Subprocess::get_if_signaled() const
{
  return g_subprocess_get_if_signaled(const_cast<GSubprocess*>(gobj()));
}

int Subprocess::get_term_sig() const
{
  return g_subprocess_get_term_sig(const_cast<GSubprocess*>(gobj()));
}

void Subprocess::communicate_async(const Glib::RefPtr<const Glib::Bytes>& stdin_buf, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  // Create a copy of the slot.
  auto slot_copy = new SlotAsyncReady(slot); 

  g_subprocess_communicate_async(gobj(), const_cast<GBytes*>(Glib::unwrap<Glib::Bytes>(stdin_buf)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &giomm_SignalProxy_async_callback, slot_copy);
}

void Subprocess::communicate_utf8_async(const Glib::ustring& stdin_buf, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  // Create a copy of the slot.
  auto slot_copy = new SlotAsyncReady(slot); 

  g_subprocess_communicate_utf8_async(gobj(), stdin_buf.empty() ? nullptr : stdin_buf.c_str(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &giomm_SignalProxy_async_callback, slot_copy);
}


} // namespace Gio


