/* valaobjecttypesymbol.c generated by valac, the Vala compiler
 * generated from valaobjecttypesymbol.vala, do not modify */

/* valaobjecttypesymbol.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 * Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaObjectTypeSymbolPrivate {
	ValaList* type_parameters;
	ValaList* members;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaList* signals;
	ValaList* classes;
	ValaList* interfaces;
	ValaList* structs;
	ValaList* enums;
	ValaList* delegates;
	ValaList* constants;
};

static gint ValaObjectTypeSymbol_private_offset;
static gpointer vala_object_type_symbol_parent_class = NULL;

static void vala_object_type_symbol_real_add_field (ValaSymbol* base,
                                             ValaField* f);
static void vala_object_type_symbol_real_add_method (ValaSymbol* base,
                                              ValaMethod* m);
static void vala_object_type_symbol_real_add_property (ValaSymbol* base,
                                                ValaProperty* prop);
static void vala_object_type_symbol_real_add_signal (ValaSymbol* base,
                                              ValaSignal* sig);
static void vala_object_type_symbol_real_add_class (ValaSymbol* base,
                                             ValaClass* cl);
static void vala_object_type_symbol_real_add_interface (ValaSymbol* base,
                                                 ValaInterface* iface);
static void vala_object_type_symbol_real_add_struct (ValaSymbol* base,
                                              ValaStruct* st);
static void vala_object_type_symbol_real_add_enum (ValaSymbol* base,
                                            ValaEnum* en);
static void vala_object_type_symbol_real_add_delegate (ValaSymbol* base,
                                                ValaDelegate* d);
static void vala_object_type_symbol_real_add_constant (ValaSymbol* base,
                                                ValaConstant* c);
static gint vala_object_type_symbol_real_get_type_parameter_index (ValaTypeSymbol* base,
                                                            const gchar* name);
static void vala_object_type_symbol_real_accept_children (ValaCodeNode* base,
                                                   ValaCodeVisitor* visitor);
static gboolean vala_object_type_symbol_real_check (ValaCodeNode* base,
                                             ValaCodeContext* context);
static void vala_object_type_symbol_finalize (ValaCodeNode * obj);
static GType vala_object_type_symbol_get_type_once (void);

static inline gpointer
vala_object_type_symbol_get_instance_private (ValaObjectTypeSymbol* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectTypeSymbol_private_offset);
}

ValaObjectTypeSymbol*
vala_object_type_symbol_construct (GType object_type,
                                   const gchar* name,
                                   ValaSourceReference* source_reference,
                                   ValaComment* comment)
{
	ValaObjectTypeSymbol* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaObjectTypeSymbol*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	return self;
}

/**
 * Returns the list of members.
 *
 * @return list of members
 */
ValaList*
vala_object_type_symbol_get_members (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->members;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of fields.
 *
 * @return list of fields
 */
ValaList*
vala_object_type_symbol_get_fields (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of methods.
 *
 * @return list of methods
 */
ValaList*
vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of properties.
 *
 * @return list of properties
 */
ValaList*
vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->properties;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of signals.
 *
 * @return list of signals
 */
ValaList*
vala_object_type_symbol_get_signals (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->signals;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this object-symbol.
 *
 * @param f a field
 */
static void
vala_object_type_symbol_real_add_field (ValaSymbol* base,
                                        ValaField* f)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = self->priv->fields;
	vala_collection_add ((ValaCollection*) _tmp0_, f);
	_tmp1_ = self->priv->members;
	vala_collection_add ((ValaCollection*) _tmp1_, (ValaSymbol*) f);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp5_ = _tmp4_;
	vala_scope_add (_tmp3_, _tmp5_, (ValaSymbol*) f);
}

/**
 * Adds the specified method as a member to this object-symbol.
 *
 * @param m a method
 */
static void
vala_object_type_symbol_real_add_method (ValaSymbol* base,
                                         ValaMethod* m)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp0_, m);
	_tmp1_ = self->priv->members;
	vala_collection_add ((ValaCollection*) _tmp1_, (ValaSymbol*) m);
	if (VALA_IS_CLASS (self)) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp4_ = vala_method_get_base_interface_type (m);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = vala_method_get_is_abstract (m);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			_tmp6_ = TRUE;
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = vala_method_get_is_virtual (m);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_;
		}
		_tmp2_ = !_tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaScope* _tmp11_;
		ValaScope* _tmp12_;
		_tmp11_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		vala_scope_add (_tmp12_, NULL, (ValaSymbol*) m);
	} else {
		ValaScope* _tmp13_;
		ValaScope* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		vala_scope_add (_tmp14_, _tmp16_, (ValaSymbol*) m);
	}
}

/**
 * Adds the specified property as a member to this object-symbol.
 *
 * @param prop a property
 */
static void
vala_object_type_symbol_real_add_property (ValaSymbol* base,
                                           ValaProperty* prop)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->properties;
	vala_collection_add ((ValaCollection*) _tmp0_, prop);
	_tmp1_ = self->priv->members;
	vala_collection_add ((ValaCollection*) _tmp1_, (ValaSymbol*) prop);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp5_ = _tmp4_;
	vala_scope_add (_tmp3_, _tmp5_, (ValaSymbol*) prop);
}

/**
 * Adds the specified signal as a member to this object-symbol.
 *
 * @param sig a signal
 */
static void
vala_object_type_symbol_real_add_signal (ValaSymbol* base,
                                         ValaSignal* sig)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = self->priv->signals;
	vala_collection_add ((ValaCollection*) _tmp0_, sig);
	_tmp1_ = self->priv->members;
	vala_collection_add ((ValaCollection*) _tmp1_, (ValaSymbol*) sig);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) sig);
	_tmp5_ = _tmp4_;
	vala_scope_add (_tmp3_, _tmp5_, (ValaSymbol*) sig);
}

/**
 * Returns the list of classes.
 *
 * @return list of classes
 */
ValaList*
vala_object_type_symbol_get_classes (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->classes;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of interfaces.
 *
 * @return list of interfaces
 */
ValaList*
vala_object_type_symbol_get_interfaces (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->interfaces;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of structs.
 *
 * @return list of structs
 */
ValaList*
vala_object_type_symbol_get_structs (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->structs;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of enums.
 *
 * @return list of enums
 */
ValaList*
vala_object_type_symbol_get_enums (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->enums;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of delegates.
 *
 * @return list of delegates
 */
ValaList*
vala_object_type_symbol_get_delegates (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->delegates;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified class as an inner class.
 *
 * @param cl a class
 */
static void
vala_object_type_symbol_real_add_class (ValaSymbol* base,
                                        ValaClass* cl)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = self->priv->classes;
	vala_collection_add ((ValaCollection*) _tmp0_, cl);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) cl);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) cl);
}

/**
 * Adds the specified interface as an inner interface.
 *
 * @param iface an interface
 */
static void
vala_object_type_symbol_real_add_interface (ValaSymbol* base,
                                            ValaInterface* iface)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->interfaces;
	vala_collection_add ((ValaCollection*) _tmp0_, iface);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) iface);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) iface);
}

/**
 * Adds the specified struct as an inner struct.
 *
 * @param st a struct
 */
static void
vala_object_type_symbol_real_add_struct (ValaSymbol* base,
                                         ValaStruct* st)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = self->priv->structs;
	vala_collection_add ((ValaCollection*) _tmp0_, st);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) st);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) st);
}

/**
 * Adds the specified enum as an inner enum.
 *
 * @param en an enum
 */
static void
vala_object_type_symbol_real_add_enum (ValaSymbol* base,
                                       ValaEnum* en)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = self->priv->enums;
	vala_collection_add ((ValaCollection*) _tmp0_, en);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) en);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) en);
}

/**
 * Adds the specified delegate as an inner delegate.
 *
 * @param d a delegate
 */
static void
vala_object_type_symbol_real_add_delegate (ValaSymbol* base,
                                           ValaDelegate* d)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = self->priv->delegates;
	vala_collection_add ((ValaCollection*) _tmp0_, d);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) d);
}

/**
 * Adds the specified constant as a member to this interface.
 *
 * @param c a constant
 */
static void
vala_object_type_symbol_real_add_constant (ValaSymbol* base,
                                           ValaConstant* c)
{
	ValaObjectTypeSymbol * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	vala_collection_add ((ValaCollection*) _tmp0_, c);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) c);
}

/**
 * Returns the list of constants.
 *
 * @return list of constants
 */
ValaList*
vala_object_type_symbol_get_constants (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_object_type_symbol_add_type_parameter (ValaObjectTypeSymbol* self,
                                            ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, p);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) p);
}

/**
 * Returns the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	result = _tmp0_;
	return result;
}

gboolean
vala_object_type_symbol_has_type_parameters (ValaObjectTypeSymbol* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gint
vala_object_type_symbol_real_get_type_parameter_index (ValaTypeSymbol* base,
                                                       const gchar* name)
{
	ValaObjectTypeSymbol * self;
	gint i = 0;
	gint result;
	self = (ValaObjectTypeSymbol*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp0_;
		gint _parameter_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _parameter_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_parameter_list = _tmp0_;
		_tmp1_ = _parameter_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_parameter_size = _tmp3_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_parameter_index = _parameter_index + 1;
			_tmp4_ = _parameter_index;
			_tmp5_ = _parameter_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _parameter_list;
			_tmp7_ = vala_list_get (_tmp6_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = parameter;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (parameter);
		}
	}
	result = -1;
	return result;
}

/**
 * Adds the specified method as a hidden member to this class,
 * primarily used for default signal handlers.
 *
 * The hidden methods are not part of the `methods` collection.
 *
 * There may also be other use cases, eg, convert array.resize() to
 * this type of method?
 *
 * @param m a method
 */
void
vala_object_type_symbol_add_hidden_method (ValaObjectTypeSymbol* self,
                                           ValaMethod* m)
{
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	gboolean _tmp24_ = FALSE;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaScope* _tmp48_;
	ValaScope* _tmp49_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		ValaScope* _tmp16_;
		ValaScope* _tmp17_;
		ValaParameter* _tmp18_;
		ValaParameter* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		_tmp2_ = vala_method_get_this_parameter (m);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaScope* _tmp4_;
			ValaScope* _tmp5_;
			ValaParameter* _tmp6_;
			ValaParameter* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_method_get_this_parameter (m);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
			_tmp9_ = _tmp8_;
			vala_scope_remove (_tmp5_, _tmp9_);
		}
		_tmp10_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_parameter_new ("this", _tmp11_, _tmp13_);
		_tmp15_ = _tmp14_;
		vala_method_set_this_parameter (m, _tmp15_);
		_vala_code_node_unref0 (_tmp15_);
		_vala_code_node_unref0 (_tmp11_);
		_tmp16_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_method_get_this_parameter (m);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_method_get_this_parameter (m);
		_tmp23_ = _tmp22_;
		vala_scope_add (_tmp17_, _tmp21_, (ValaSymbol*) _tmp23_);
	}
	_tmp25_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp26_ = _tmp25_;
	if (!VALA_IS_VOID_TYPE (_tmp26_)) {
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp27_ = vala_method_get_postconditions (m);
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp24_ = _tmp29_ > 0;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaScope* _tmp32_;
			ValaScope* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp32_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			vala_scope_remove (_tmp33_, _tmp37_);
		}
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_local_variable_new (_tmp41_, "result", NULL, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_vala_code_node_unref0 (_tmp41_);
		_tmp46_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp47_ = _tmp46_;
		vala_local_variable_set_is_result (_tmp47_, TRUE);
	}
	_tmp48_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp49_ = _tmp48_;
	vala_scope_add (_tmp49_, NULL, (ValaSymbol*) m);
}

static void
vala_object_type_symbol_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor)
{
	ValaObjectTypeSymbol * self;
	ValaCodeContext* _tmp27_;
	ValaCodeContext* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	self = (ValaObjectTypeSymbol*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_object_type_symbol_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = vala_list_get (_tmp6_, _p_index);
			p = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (p);
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp9_;
		gint _en_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _en_index = 0;
		_tmp9_ = vala_object_type_symbol_get_enums (self);
		_en_list = _tmp9_;
		_tmp10_ = _en_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_en_size = _tmp12_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaEnum* en = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaEnum* _tmp17_;
			_en_index = _en_index + 1;
			_tmp13_ = _en_index;
			_tmp14_ = _en_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _en_list;
			_tmp16_ = vala_list_get (_tmp15_, _en_index);
			en = (ValaEnum*) _tmp16_;
			_tmp17_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp18_;
		gint _c_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _c_index = 0;
		_tmp18_ = vala_object_type_symbol_get_constants (self);
		_c_list = _tmp18_;
		_tmp19_ = _c_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_c_size = _tmp21_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			ValaConstant* c = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaConstant* _tmp26_;
			_c_index = _c_index + 1;
			_tmp22_ = _c_index;
			_tmp23_ = _c_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _c_list;
			_tmp25_ = vala_list_get (_tmp24_, _c_index);
			c = (ValaConstant*) _tmp25_;
			_tmp26_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp26_, visitor);
			_vala_code_node_unref0 (c);
		}
	}
	_tmp27_ = vala_code_context_get ();
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_code_context_get_abi_stability (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _tmp30_;
	_vala_code_context_unref0 (_tmp28_);
	if (_tmp31_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp32_;
			gint _s_size = 0;
			ValaList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _s_index = 0;
			_tmp32_ = vala_object_type_symbol_get_members (self);
			_s_list = _tmp32_;
			_tmp33_ = _s_list;
			_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			_s_size = _tmp35_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp36_;
				gint _tmp37_;
				ValaSymbol* s = NULL;
				ValaList* _tmp38_;
				gpointer _tmp39_;
				ValaSymbol* _tmp40_;
				_s_index = _s_index + 1;
				_tmp36_ = _s_index;
				_tmp37_ = _s_size;
				if (!(_tmp36_ < _tmp37_)) {
					break;
				}
				_tmp38_ = _s_list;
				_tmp39_ = vala_list_get (_tmp38_, _s_index);
				s = (ValaSymbol*) _tmp39_;
				_tmp40_ = s;
				vala_code_node_accept ((ValaCodeNode*) _tmp40_, visitor);
				_vala_code_node_unref0 (s);
			}
		}
	} else {
		{
			ValaList* _f_list = NULL;
			ValaList* _tmp41_;
			gint _f_size = 0;
			ValaList* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _f_index = 0;
			_tmp41_ = vala_object_type_symbol_get_fields (self);
			_f_list = _tmp41_;
			_tmp42_ = _f_list;
			_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
			_tmp44_ = _tmp43_;
			_f_size = _tmp44_;
			_f_index = -1;
			while (TRUE) {
				gint _tmp45_;
				gint _tmp46_;
				ValaField* f = NULL;
				ValaList* _tmp47_;
				gpointer _tmp48_;
				ValaField* _tmp49_;
				_f_index = _f_index + 1;
				_tmp45_ = _f_index;
				_tmp46_ = _f_size;
				if (!(_tmp45_ < _tmp46_)) {
					break;
				}
				_tmp47_ = _f_list;
				_tmp48_ = vala_list_get (_tmp47_, _f_index);
				f = (ValaField*) _tmp48_;
				_tmp49_ = f;
				vala_code_node_accept ((ValaCodeNode*) _tmp49_, visitor);
				_vala_code_node_unref0 (f);
			}
		}
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp50_;
			gint _m_size = 0;
			ValaList* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			gint _m_index = 0;
			_tmp50_ = vala_object_type_symbol_get_methods (self);
			_m_list = _tmp50_;
			_tmp51_ = _m_list;
			_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
			_tmp53_ = _tmp52_;
			_m_size = _tmp53_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp54_;
				gint _tmp55_;
				ValaMethod* m = NULL;
				ValaList* _tmp56_;
				gpointer _tmp57_;
				ValaMethod* _tmp58_;
				_m_index = _m_index + 1;
				_tmp54_ = _m_index;
				_tmp55_ = _m_size;
				if (!(_tmp54_ < _tmp55_)) {
					break;
				}
				_tmp56_ = _m_list;
				_tmp57_ = vala_list_get (_tmp56_, _m_index);
				m = (ValaMethod*) _tmp57_;
				_tmp58_ = m;
				vala_code_node_accept ((ValaCodeNode*) _tmp58_, visitor);
				_vala_code_node_unref0 (m);
			}
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp59_;
			gint _prop_size = 0;
			ValaList* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint _prop_index = 0;
			_tmp59_ = vala_object_type_symbol_get_properties (self);
			_prop_list = _tmp59_;
			_tmp60_ = _prop_list;
			_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
			_tmp62_ = _tmp61_;
			_prop_size = _tmp62_;
			_prop_index = -1;
			while (TRUE) {
				gint _tmp63_;
				gint _tmp64_;
				ValaProperty* prop = NULL;
				ValaList* _tmp65_;
				gpointer _tmp66_;
				ValaProperty* _tmp67_;
				_prop_index = _prop_index + 1;
				_tmp63_ = _prop_index;
				_tmp64_ = _prop_size;
				if (!(_tmp63_ < _tmp64_)) {
					break;
				}
				_tmp65_ = _prop_list;
				_tmp66_ = vala_list_get (_tmp65_, _prop_index);
				prop = (ValaProperty*) _tmp66_;
				_tmp67_ = prop;
				vala_code_node_accept ((ValaCodeNode*) _tmp67_, visitor);
				_vala_code_node_unref0 (prop);
			}
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp68_;
			gint _sig_size = 0;
			ValaList* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gint _sig_index = 0;
			_tmp68_ = vala_object_type_symbol_get_signals (self);
			_sig_list = _tmp68_;
			_tmp69_ = _sig_list;
			_tmp70_ = vala_collection_get_size ((ValaCollection*) _tmp69_);
			_tmp71_ = _tmp70_;
			_sig_size = _tmp71_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp72_;
				gint _tmp73_;
				ValaSignal* sig = NULL;
				ValaList* _tmp74_;
				gpointer _tmp75_;
				ValaSignal* _tmp76_;
				_sig_index = _sig_index + 1;
				_tmp72_ = _sig_index;
				_tmp73_ = _sig_size;
				if (!(_tmp72_ < _tmp73_)) {
					break;
				}
				_tmp74_ = _sig_list;
				_tmp75_ = vala_list_get (_tmp74_, _sig_index);
				sig = (ValaSignal*) _tmp75_;
				_tmp76_ = sig;
				vala_code_node_accept ((ValaCodeNode*) _tmp76_, visitor);
				_vala_code_node_unref0 (sig);
			}
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp77_;
		gint _cl_size = 0;
		ValaList* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		gint _cl_index = 0;
		_tmp77_ = vala_object_type_symbol_get_classes (self);
		_cl_list = _tmp77_;
		_tmp78_ = _cl_list;
		_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
		_tmp80_ = _tmp79_;
		_cl_size = _tmp80_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp81_;
			gint _tmp82_;
			ValaClass* cl = NULL;
			ValaList* _tmp83_;
			gpointer _tmp84_;
			ValaClass* _tmp85_;
			_cl_index = _cl_index + 1;
			_tmp81_ = _cl_index;
			_tmp82_ = _cl_size;
			if (!(_tmp81_ < _tmp82_)) {
				break;
			}
			_tmp83_ = _cl_list;
			_tmp84_ = vala_list_get (_tmp83_, _cl_index);
			cl = (ValaClass*) _tmp84_;
			_tmp85_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp85_, visitor);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp86_;
		gint _iface_size = 0;
		ValaList* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _iface_index = 0;
		_tmp86_ = vala_object_type_symbol_get_interfaces (self);
		_iface_list = _tmp86_;
		_tmp87_ = _iface_list;
		_tmp88_ = vala_collection_get_size ((ValaCollection*) _tmp87_);
		_tmp89_ = _tmp88_;
		_iface_size = _tmp89_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp90_;
			gint _tmp91_;
			ValaInterface* iface = NULL;
			ValaList* _tmp92_;
			gpointer _tmp93_;
			ValaInterface* _tmp94_;
			_iface_index = _iface_index + 1;
			_tmp90_ = _iface_index;
			_tmp91_ = _iface_size;
			if (!(_tmp90_ < _tmp91_)) {
				break;
			}
			_tmp92_ = _iface_list;
			_tmp93_ = vala_list_get (_tmp92_, _iface_index);
			iface = (ValaInterface*) _tmp93_;
			_tmp94_ = iface;
			vala_code_node_accept ((ValaCodeNode*) _tmp94_, visitor);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp95_;
		gint _st_size = 0;
		ValaList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _st_index = 0;
		_tmp95_ = vala_object_type_symbol_get_structs (self);
		_st_list = _tmp95_;
		_tmp96_ = _st_list;
		_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_st_size = _tmp98_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp99_;
			gint _tmp100_;
			ValaStruct* st = NULL;
			ValaList* _tmp101_;
			gpointer _tmp102_;
			ValaStruct* _tmp103_;
			_st_index = _st_index + 1;
			_tmp99_ = _st_index;
			_tmp100_ = _st_size;
			if (!(_tmp99_ < _tmp100_)) {
				break;
			}
			_tmp101_ = _st_list;
			_tmp102_ = vala_list_get (_tmp101_, _st_index);
			st = (ValaStruct*) _tmp102_;
			_tmp103_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp103_, visitor);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp104_;
		gint _d_size = 0;
		ValaList* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gint _d_index = 0;
		_tmp104_ = vala_object_type_symbol_get_delegates (self);
		_d_list = _tmp104_;
		_tmp105_ = _d_list;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
		_tmp107_ = _tmp106_;
		_d_size = _tmp107_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp108_;
			gint _tmp109_;
			ValaDelegate* d = NULL;
			ValaList* _tmp110_;
			gpointer _tmp111_;
			ValaDelegate* _tmp112_;
			_d_index = _d_index + 1;
			_tmp108_ = _d_index;
			_tmp109_ = _d_size;
			if (!(_tmp108_ < _tmp109_)) {
				break;
			}
			_tmp110_ = _d_list;
			_tmp111_ = vala_list_get (_tmp110_, _d_index);
			d = (ValaDelegate*) _tmp111_;
			_tmp112_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp112_, visitor);
			_vala_code_node_unref0 (d);
		}
	}
}

static gboolean
vala_object_type_symbol_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context)
{
	ValaObjectTypeSymbol * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean result;
	self = (ValaObjectTypeSymbol*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	_tmp6_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		_tmp5_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "DBus");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "gio-2.0 package required for DBus support");
	}
	_tmp10_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp11_ = _tmp10_;
	result = !_tmp11_;
	return result;
}

static void
vala_object_type_symbol_class_init (ValaObjectTypeSymbolClass * klass,
                                    gpointer klass_data)
{
	vala_object_type_symbol_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_type_symbol_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectTypeSymbol_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_object_type_symbol_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_object_type_symbol_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_object_type_symbol_real_add_property;
	((ValaSymbolClass *) klass)->add_signal = (void (*) (ValaSymbol*, ValaSignal*)) vala_object_type_symbol_real_add_signal;
	((ValaSymbolClass *) klass)->add_class = (void (*) (ValaSymbol*, ValaClass*)) vala_object_type_symbol_real_add_class;
	((ValaSymbolClass *) klass)->add_interface = (void (*) (ValaSymbol*, ValaInterface*)) vala_object_type_symbol_real_add_interface;
	((ValaSymbolClass *) klass)->add_struct = (void (*) (ValaSymbol*, ValaStruct*)) vala_object_type_symbol_real_add_struct;
	((ValaSymbolClass *) klass)->add_enum = (void (*) (ValaSymbol*, ValaEnum*)) vala_object_type_symbol_real_add_enum;
	((ValaSymbolClass *) klass)->add_delegate = (void (*) (ValaSymbol*, ValaDelegate*)) vala_object_type_symbol_real_add_delegate;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_object_type_symbol_real_add_constant;
	((ValaTypeSymbolClass *) klass)->get_type_parameter_index = (gint (*) (ValaTypeSymbol*, const gchar*)) vala_object_type_symbol_real_get_type_parameter_index;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_type_symbol_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_type_symbol_real_check;
}

static void
vala_object_type_symbol_instance_init (ValaObjectTypeSymbol * self,
                                       gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GEqualFunc _tmp10_;
	ValaArrayList* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	GEqualFunc _tmp22_;
	ValaArrayList* _tmp23_;
	self->priv = vala_object_type_symbol_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->members = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->methods = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp10_);
	self->priv->signals = (ValaList*) _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp12_);
	self->priv->classes = (ValaList*) _tmp13_;
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_);
	self->priv->interfaces = (ValaList*) _tmp15_;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp16_);
	self->priv->structs = (ValaList*) _tmp17_;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp18_);
	self->priv->enums = (ValaList*) _tmp19_;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	self->priv->delegates = (ValaList*) _tmp21_;
	_tmp22_ = g_direct_equal;
	_tmp23_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp22_);
	self->priv->constants = (ValaList*) _tmp23_;
}

static void
vala_object_type_symbol_finalize (ValaCodeNode * obj)
{
	ValaObjectTypeSymbol * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->members);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->signals);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->interfaces);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_iterable_unref0 (self->priv->constants);
	VALA_CODE_NODE_CLASS (vala_object_type_symbol_parent_class)->finalize (obj);
}

/**
 * Represents a runtime data type for objects and interfaces. This data type may
 * be defined in Vala source code or imported from an external library with a
 * Vala API file.
 */
static GType
vala_object_type_symbol_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectTypeSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_type_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectTypeSymbol), 0, (GInstanceInitFunc) vala_object_type_symbol_instance_init, NULL };
	GType vala_object_type_symbol_type_id;
	vala_object_type_symbol_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaObjectTypeSymbol", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ValaObjectTypeSymbol_private_offset = g_type_add_instance_private (vala_object_type_symbol_type_id, sizeof (ValaObjectTypeSymbolPrivate));
	return vala_object_type_symbol_type_id;
}

GType
vala_object_type_symbol_get_type (void)
{
	static volatile gsize vala_object_type_symbol_type_id__once = 0;
	if (g_once_init_enter (&vala_object_type_symbol_type_id__once)) {
		GType vala_object_type_symbol_type_id;
		vala_object_type_symbol_type_id = vala_object_type_symbol_get_type_once ();
		g_once_init_leave (&vala_object_type_symbol_type_id__once, vala_object_type_symbol_type_id);
	}
	return vala_object_type_symbol_type_id__once;
}

