// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{GLBaseMemory, GLContext};
use glib::{prelude::*, translate::*};
use std::mem;

glib::wrapper! {
    #[doc(alias = "GstGLFramebuffer")]
    pub struct GLFramebuffer(Object<ffi::GstGLFramebuffer, ffi::GstGLFramebufferClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_gl_framebuffer_get_type(),
    }
}

impl GLFramebuffer {
    pub const NONE: Option<&'static GLFramebuffer> = None;

    #[doc(alias = "gst_gl_framebuffer_new")]
    pub fn new(context: &impl IsA<GLContext>) -> GLFramebuffer {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gst_gl_framebuffer_new(
                context.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_gl_framebuffer_new_with_default_depth")]
    #[doc(alias = "new_with_default_depth")]
    pub fn with_default_depth(
        context: &impl IsA<GLContext>,
        width: u32,
        height: u32,
    ) -> GLFramebuffer {
        skip_assert_initialized!();
        unsafe {
            from_glib_none(ffi::gst_gl_framebuffer_new_with_default_depth(
                context.as_ref().to_glib_none().0,
                width,
                height,
            ))
        }
    }
}

unsafe impl Send for GLFramebuffer {}
unsafe impl Sync for GLFramebuffer {}

pub trait GLFramebufferExt: 'static {
    #[doc(alias = "gst_gl_framebuffer_attach")]
    unsafe fn attach(&self, attachment_point: u32, mem: &mut GLBaseMemory);

    #[doc(alias = "gst_gl_framebuffer_bind")]
    fn bind(&self);

    #[doc(alias = "gst_gl_framebuffer_get_effective_dimensions")]
    #[doc(alias = "get_effective_dimensions")]
    fn effective_dimensions(&self) -> (u32, u32);

    #[doc(alias = "gst_gl_framebuffer_get_id")]
    #[doc(alias = "get_id")]
    fn id(&self) -> u32;
}

impl<O: IsA<GLFramebuffer>> GLFramebufferExt for O {
    unsafe fn attach(&self, attachment_point: u32, mem: &mut GLBaseMemory) {
        ffi::gst_gl_framebuffer_attach(
            self.as_ref().to_glib_none().0,
            attachment_point,
            mem.to_glib_none_mut().0,
        );
    }

    fn bind(&self) {
        unsafe {
            ffi::gst_gl_framebuffer_bind(self.as_ref().to_glib_none().0);
        }
    }

    fn effective_dimensions(&self) -> (u32, u32) {
        unsafe {
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            ffi::gst_gl_framebuffer_get_effective_dimensions(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            (width.assume_init(), height.assume_init())
        }
    }

    fn id(&self) -> u32 {
        unsafe { ffi::gst_gl_framebuffer_get_id(self.as_ref().to_glib_none().0) }
    }
}
